/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.idfactory;

import com.phloc.commons.charset.CCharset;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.idfactory.AbstractPersistingIntIDFactory;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.file.SimpleFileIO;
import com.phloc.commons.string.StringParser;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class FileIntIDFactory
extends AbstractPersistingIntIDFactory {
    @Nonnull
    public static final Charset CHARSET_TO_USE = CCharset.CHARSET_ISO_8859_1_OBJ;
    @Nonnegative
    public static final int DEFAULT_RESERVE_COUNT = 20;
    @Nonnull
    private final File m_aFile;

    public FileIntIDFactory(@Nonnull File aFile) {
        this(aFile, 20);
    }

    public FileIntIDFactory(@Nonnull File aFile, @Nonnegative int nReserveCount) {
        super(nReserveCount);
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        if (!FileUtils.canReadAndWriteFile(aFile)) {
            throw new IllegalArgumentException("Cannot read and/or write the file " + aFile + "!");
        }
        this.m_aFile = aFile;
    }

    @Override
    protected final int readAndUpdateIDCounter(@Nonnegative int nReserveCount) {
        String sContent = SimpleFileIO.readFileAsString(this.m_aFile, CHARSET_TO_USE);
        int nRead = sContent != null ? StringParser.parseInt(sContent.trim(), 0) : 0;
        SimpleFileIO.writeFile(this.m_aFile, Integer.toString(nRead + nReserveCount), CHARSET_TO_USE);
        return nRead;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        FileIntIDFactory rhs = (FileIntIDFactory)o;
        return this.m_aFile.equals(rhs.m_aFile);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aFile).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("file", this.m_aFile).toString();
    }
}

