/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resource;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.EAppend;
import com.phloc.commons.io.IReadWriteResource;
import com.phloc.commons.io.file.FileUtils;
import com.phloc.commons.io.file.FilenameHelper;
import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class FileSystemResource
implements IReadWriteResource {
    private static final Logger s_aLogger = LoggerFactory.getLogger(FileSystemResource.class);
    private final File m_aFile;
    private final String m_sPath;
    private Integer m_aHashCode;

    public FileSystemResource(@Nonnull URI aURI) {
        this(new File(aURI));
    }

    public FileSystemResource(@Nonnull String sParentPath, @Nonnull String sChildPath) {
        this(new File(sParentPath, sChildPath));
    }

    public FileSystemResource(@Nonnull String sFilename) {
        this(new File(sFilename));
    }

    public FileSystemResource(@Nonnull File aParentFile, String sChildPath) {
        this(new File(aParentFile, sChildPath));
    }

    public FileSystemResource(@Nonnull File aFile) {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        String sPath = FilenameHelper.getCleanPath(aFile.getAbsolutePath());
        this.m_aFile = new File(sPath);
        this.m_sPath = this.m_aFile.getAbsolutePath();
    }

    @Override
    @Nonnull
    public String getResourceID() {
        return this.getPath();
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.m_sPath;
    }

    @Nullable
    public static InputStream getInputStream(@Nonnull File aFile) {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        return FileUtils.getInputStream(aFile);
    }

    @Nullable
    public static Reader getReader(@Nonnull File aFile, @Nonnull @Nonempty String sCharset) {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        if (StringHelper.hasNoText(sCharset)) {
            throw new IllegalArgumentException("charset");
        }
        return StreamUtils.createReader(FileSystemResource.getInputStream(aFile), sCharset);
    }

    @Nullable
    public static Reader getReader(@Nonnull File aFile, @Nonnull Charset aCharset) {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        if (aCharset == null) {
            throw new NullPointerException("charset");
        }
        return StreamUtils.createReader(FileSystemResource.getInputStream(aFile), aCharset);
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        return FileSystemResource.getInputStream(this.m_aFile);
    }

    @Override
    @Nullable
    public Reader getReader(@Nonnull @Nonempty String sCharset) {
        return FileSystemResource.getReader(this.m_aFile, sCharset);
    }

    @Override
    @Nullable
    public Reader getReader(@Nonnull Charset aCharset) {
        return FileSystemResource.getReader(this.m_aFile, aCharset);
    }

    @Nullable
    public static OutputStream getOutputStream(@Nonnull File aFile, @Nonnull EAppend eAppend) {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        if (eAppend == null) {
            throw new NullPointerException("append");
        }
        return FileUtils.getOutputStream(aFile, eAppend);
    }

    @Nullable
    public static Writer getWriter(@Nonnull File aFile, @Nonnull @Nonempty String sCharset, @Nonnull EAppend eAppend) {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        if (StringHelper.hasNoText(sCharset)) {
            throw new IllegalArgumentException("charset");
        }
        if (eAppend == null) {
            throw new NullPointerException("append");
        }
        return StreamUtils.createWriter(FileSystemResource.getOutputStream(aFile, eAppend), sCharset);
    }

    @Nullable
    public static Writer getWriter(@Nonnull File aFile, @Nonnull Charset aCharset, @Nonnull EAppend eAppend) {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        if (aCharset == null) {
            throw new NullPointerException("charset");
        }
        if (eAppend == null) {
            throw new NullPointerException("append");
        }
        return StreamUtils.createWriter(FileSystemResource.getOutputStream(aFile, eAppend), aCharset);
    }

    @Override
    @Nullable
    public OutputStream getOutputStream(@Nonnull EAppend eAppend) {
        return FileSystemResource.getOutputStream(this.m_aFile, eAppend);
    }

    @Override
    @Nullable
    public Writer getWriter(@Nonnull @Nonempty String sCharset, @Nonnull EAppend eAppend) {
        return FileSystemResource.getWriter(this.m_aFile, sCharset, eAppend);
    }

    @Override
    @Nullable
    public Writer getWriter(@Nonnull Charset aCharset, @Nonnull EAppend eAppend) {
        return FileSystemResource.getWriter(this.m_aFile, aCharset, eAppend);
    }

    @Override
    public boolean exists() {
        return this.m_aFile.exists();
    }

    @Nullable
    public static URL getAsURL(File aFile) {
        try {
            return aFile.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            s_aLogger.warn("Failed to convert file to URL: " + aFile, (Throwable)ex);
            return null;
        }
    }

    @Override
    @Nullable
    public URL getAsURL() {
        return FileSystemResource.getAsURL(this.m_aFile);
    }

    @Override
    @Nonnull
    public File getAsFile() {
        return this.m_aFile;
    }

    @Override
    @Nonnull
    public FileSystemResource getReadableCloneForPath(@Nonnull String sPath) {
        return new FileSystemResource(sPath);
    }

    @Override
    @Nonnull
    public FileSystemResource getWritableCloneForPath(@Nonnull String sPath) {
        return new FileSystemResource(sPath);
    }

    public boolean canRead() {
        return FileUtils.canRead(this.m_aFile);
    }

    public boolean canWrite() {
        return FileUtils.canWrite(this.m_aFile);
    }

    public boolean canExecute() {
        return FileUtils.canExecute(this.m_aFile);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileSystemResource)) {
            return false;
        }
        FileSystemResource rhs = (FileSystemResource)o;
        return this.m_aFile.equals(rhs.m_aFile);
    }

    public int hashCode() {
        if (this.m_aHashCode == null) {
            this.m_aHashCode = new HashCodeGenerator(this).append(this.m_aFile).getHashCodeObj();
        }
        return this.m_aHashCode;
    }

    public String toString() {
        return new ToStringGenerator(null).append("file", this.m_aFile).toString();
    }
}

