/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import com.phloc.commons.stats.IStatisticsHandlerCounter;
import com.phloc.commons.stats.IStatisticsHandlerSize;
import com.phloc.commons.stats.StatisticsManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.Nonnull;

public class CountingFileInputStream
extends FileInputStream {
    private static final IStatisticsHandlerSize s_aReadSizeHdl = StatisticsManager.getSizeHandler(CountingFileInputStream.class.getName() + "$read.bytes");
    private static final IStatisticsHandlerCounter s_aReadFilesHdl = StatisticsManager.getCounterHandler(CountingFileInputStream.class.getName() + "$read.files");

    public CountingFileInputStream(@Nonnull File aFile) throws FileNotFoundException {
        super(aFile);
        s_aReadFilesHdl.increment();
    }

    public CountingFileInputStream(@Nonnull String sFilename) throws FileNotFoundException {
        super(sFilename);
        s_aReadFilesHdl.increment();
    }

    @Override
    public int read() throws IOException {
        int ret = super.read();
        if (ret != -1) {
            s_aReadSizeHdl.addSize(1L);
        }
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int ret = super.read(b);
        if (ret > -1) {
            s_aReadSizeHdl.addSize(ret);
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int nOffset, int nLength) throws IOException {
        int ret = super.read(b, nOffset, nLength);
        if (ret > -1) {
            s_aReadSizeHdl.addSize(ret);
        }
        return ret;
    }
}

