/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.microdom.serialize;

import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.microdom.IMicroCDATA;
import com.phloc.commons.microdom.IMicroComment;
import com.phloc.commons.microdom.IMicroContainer;
import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroDocumentType;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.IMicroEntityReference;
import com.phloc.commons.microdom.IMicroNode;
import com.phloc.commons.microdom.IMicroProcessingInstruction;
import com.phloc.commons.microdom.IMicroText;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.xml.IXMLIterationHandler;
import com.phloc.commons.xml.serialize.AbstractSerializerPhloc;
import com.phloc.commons.xml.serialize.IXMLWriterSettings;
import com.phloc.commons.xml.serialize.XMLEmitterPhloc;
import com.phloc.commons.xml.serialize.XMLWriterSettings;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;

public final class MicroSerializer
extends AbstractSerializerPhloc<IMicroNode> {
    public MicroSerializer() {
        this(XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    public MicroSerializer(@Nonnull IXMLWriterSettings aSettings) {
        super(aSettings);
    }

    private void _writeNode(@Nonnull IXMLIterationHandler aXMLWriter, @Nullable IMicroNode aPrevSibling, @Nonnull IMicroNode aNode, @Nullable IMicroNode aNextSibling) {
        if (aNode == null) {
            throw new NullPointerException("node");
        }
        if (aNode.isElement()) {
            this._writeElement(aXMLWriter, aPrevSibling, (IMicroElement)aNode, aNextSibling);
        } else if (aNode.isText()) {
            MicroSerializer._writeText(aXMLWriter, (IMicroText)aNode);
        } else if (aNode.isCDATA()) {
            MicroSerializer._writeCDATA(aXMLWriter, (IMicroCDATA)aNode);
        } else if (aNode.isComment()) {
            this._writeComment(aXMLWriter, (IMicroComment)aNode);
        } else if (aNode.isEntityReference()) {
            MicroSerializer._writeEntityReference(aXMLWriter, (IMicroEntityReference)aNode);
        } else if (aNode.isDocument()) {
            this._writeDocument(aXMLWriter, (IMicroDocument)aNode);
        } else if (aNode.isDocumentType()) {
            this._writeDocumentType(aXMLWriter, (IMicroDocumentType)aNode);
        } else if (aNode.isProcessingInstruction()) {
            MicroSerializer._writeProcessingInstruction(aXMLWriter, (IMicroProcessingInstruction)aNode);
        } else if (aNode.isContainer()) {
            this._writeContainer(aXMLWriter, (IMicroContainer)aNode);
        } else {
            throw new IllegalArgumentException("Passed node type " + aNode.getClass().getName() + " is not yet supported");
        }
    }

    private void _writeNodeList(@Nonnull IXMLIterationHandler aXMLWriter, @Nonnull List<IMicroNode> aChildren) {
        int nLastIndex = aChildren.size() - 1;
        for (int nIndex = 0; nIndex <= nLastIndex; ++nIndex) {
            this._writeNode(aXMLWriter, nIndex == 0 ? null : aChildren.get(nIndex - 1), aChildren.get(nIndex), nIndex == nLastIndex ? null : aChildren.get(nIndex + 1));
        }
    }

    private void _writeDocument(@Nonnull IXMLIterationHandler aXMLWriter, IMicroDocument aDocument) {
        if (this.m_aSettings.getFormat().hasXMLHeader()) {
            aXMLWriter.onDocumentStart(this.m_aSettings.getXMLVersion(), this.m_aSettings.getCharset(), aDocument.isStandalone());
        }
        if (aDocument.hasChildren()) {
            this._writeNodeList(aXMLWriter, aDocument.getChildren());
        }
    }

    private void _writeDocumentType(@Nonnull IXMLIterationHandler aXMLWriter, IMicroDocumentType aDocType) {
        if (this.m_aSettings.getSerializeDocType().emit()) {
            aXMLWriter.onDocumentType(aDocType.getQualifiedName(), aDocType.getPublicID(), aDocType.getSystemID());
        }
    }

    private static void _writeProcessingInstruction(@Nonnull IXMLIterationHandler aXMLWriter, IMicroProcessingInstruction aPI) {
        aXMLWriter.onProcessingInstruction(aPI.getTarget(), aPI.getData());
    }

    private void _writeContainer(@Nonnull IXMLIterationHandler aXMLWriter, IMicroContainer aContainer) {
        if (aContainer.hasChildren()) {
            this._writeNodeList(aXMLWriter, aContainer.getChildren());
        }
    }

    private static void _writeEntityReference(@Nonnull IXMLIterationHandler aXMLWriter, @Nonnull IMicroEntityReference aEntRef) {
        aXMLWriter.onEntityReference(aEntRef.getName());
    }

    private static void _writeText(@Nonnull IXMLIterationHandler aXMLWriter, @Nonnull IMicroText aText) {
        aXMLWriter.onText(((Object)aText.getData()).toString(), aText.isEscape());
    }

    private void _writeComment(@Nonnull IXMLIterationHandler aXMLWriter, @Nonnull IMicroComment aComment) {
        if (this.m_aSettings.getSerializeComments().emit()) {
            if (this.m_aSettings.getIndent().isIndent() && this.m_aIndent.length() > 0) {
                aXMLWriter.onContentElementWhitespace(this.m_aIndent);
            }
            aXMLWriter.onComment(((Object)aComment.getData()).toString());
            if (this.m_aSettings.getIndent().isAlign()) {
                aXMLWriter.onContentElementWhitespace(NEWLINE);
            }
        }
    }

    private static void _writeCDATA(@Nonnull IXMLIterationHandler aXMLWriter, @Nonnull IMicroCDATA aCDATA) {
        aXMLWriter.onCDATA(((Object)aCDATA.getData()).toString());
    }

    private static boolean _isInlineNode(@Nonnull IMicroNode aNode) {
        return (aNode.isText() || aNode.isCDATA()) && !aNode.isComment() || aNode.isEntityReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeElement(@Nonnull IXMLIterationHandler aXMLWriter, @Nullable IMicroNode aPrevSibling, @Nonnull IMicroElement aElement, @Nullable IMicroNode aNextSibling) {
        String sTagName = aElement.getLocalName() != null ? aElement.getLocalName() : aElement.getTagName();
        List<IMicroNode> aChildNodeList = aElement.getChildren();
        boolean bHasChildren = aElement.hasChildren();
        boolean bIsRootElement = aElement.getParent() != null && aElement.getParent().isDocument();
        boolean bIndentPrev = aPrevSibling == null || !MicroSerializer._isInlineNode(aPrevSibling) || bIsRootElement;
        boolean bIndentNext = aNextSibling == null || !MicroSerializer._isInlineNode(aNextSibling);
        boolean bHasChildElement = bHasChildren && !MicroSerializer._isInlineNode(aElement.getFirstChild());
        LinkedHashMap<String, String> aAttrMap = new LinkedHashMap<String, String>();
        if (aElement.hasAttributes()) {
            aAttrMap.putAll(aElement.getAttributes());
        }
        this.m_aNSStack.push(aAttrMap);
        try {
            String sElementNamespaceURI = aElement.getNamespaceURI();
            String sNSPrefix = this.m_aNSStack.findPrefix(sElementNamespaceURI);
            String sDefaultNS = this.m_aNSStack.getDefaultNamespace();
            if (StringHelper.hasText(sElementNamespaceURI) && sNSPrefix == null && !sElementNamespaceURI.equals(sDefaultNS)) {
                sNSPrefix = this.m_aNSStack.createUniquePrefix(sElementNamespaceURI);
                if (StringHelper.hasNoText(sNSPrefix)) {
                    aAttrMap.put("xmlns", sElementNamespaceURI);
                } else {
                    aAttrMap.put("xmlns:" + sNSPrefix, sElementNamespaceURI);
                }
                this.m_aNSStack.addNamespaceMapping(sNSPrefix, sElementNamespaceURI);
            }
            if (bIsRootElement && sDefaultNS != null) {
                aAttrMap.put("xmlns", sDefaultNS);
                this.m_aNSStack.addNamespaceMapping(null, sDefaultNS);
            }
            if (this.m_aSettings.getIndent().isIndent() && bIndentPrev && this.m_aIndent.length() > 0) {
                aXMLWriter.onContentElementWhitespace(this.m_aIndent);
            }
            aXMLWriter.onElementStart(sNSPrefix, sTagName, aAttrMap, bHasChildren);
            if (bHasChildren) {
                if (this.m_aSettings.getIndent().isAlign() && bHasChildElement) {
                    aXMLWriter.onContentElementWhitespace(NEWLINE);
                }
                this.m_aIndent.append("  ");
                if (aChildNodeList != null) {
                    this._writeNodeList(aXMLWriter, aChildNodeList);
                }
                this.m_aIndent.delete(this.m_aIndent.length() - "  ".length(), this.m_aIndent.length());
                if (this.m_aSettings.getIndent().isIndent() && bHasChildElement && this.m_aIndent.length() > 0) {
                    aXMLWriter.onContentElementWhitespace(this.m_aIndent);
                }
                aXMLWriter.onElementEnd(sNSPrefix, sTagName);
            }
            if (this.m_aSettings.getIndent().isAlign() && bIndentNext) {
                aXMLWriter.onContentElementWhitespace(NEWLINE);
            }
        }
        finally {
            this.m_aNSStack.pop();
        }
    }

    @Override
    public void write(@Nonnull IMicroNode aNode, @Nonnull @WillNotClose Writer aWriter) {
        XMLEmitterPhloc aXMLWriter = new XMLEmitterPhloc(aWriter, this.m_aSettings);
        this._writeNode(aXMLWriter, null, aNode, null);
        StreamUtils.flush(aWriter);
    }

    public void write(@Nonnull IMicroNode aNode, @Nonnull IXMLIterationHandler aXMLEmitter) {
        this._writeNode(aXMLEmitter, null, aNode, null);
    }
}

