/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.simple;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.tree.simple.ITree;
import com.phloc.commons.tree.simple.ITreeItem;
import com.phloc.commons.tree.simple.ITreeItemFactory;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BasicTree<VALUETYPE, ITEMTYPE extends ITreeItem<VALUETYPE, ITEMTYPE>>
implements ITree<VALUETYPE, ITEMTYPE> {
    private final ITEMTYPE m_aRoot;

    public BasicTree(@Nonnull ITreeItemFactory<VALUETYPE, ITEMTYPE> aFactory) {
        if (aFactory == null) {
            throw new NullPointerException("factory");
        }
        this.m_aRoot = aFactory.createRoot();
        if (this.m_aRoot == null) {
            throw new IllegalStateException("Failed to create root item!");
        }
    }

    @Override
    @Nonnull
    public final ITEMTYPE getRootItem() {
        return this.m_aRoot;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        BasicTree rhs = (BasicTree)o;
        return this.m_aRoot.equals(rhs.m_aRoot);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aRoot).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("root", this.m_aRoot).toString();
    }
}

