/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.withid;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.tree.withid.ITreeItemWithID;
import com.phloc.commons.tree.withid.ITreeItemWithIDFactory;
import com.phloc.commons.tree.withid.ITreeWithID;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BasicTreeWithID<KEYTYPE, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>>
implements ITreeWithID<KEYTYPE, VALUETYPE, ITEMTYPE> {
    private final ITEMTYPE m_aRoot;

    public BasicTreeWithID(@Nonnull ITreeItemWithIDFactory<KEYTYPE, VALUETYPE, ITEMTYPE> aFactory) {
        if (aFactory == null) {
            throw new NullPointerException("factory");
        }
        this.m_aRoot = aFactory.createRoot();
        if (this.m_aRoot == null) {
            throw new IllegalStateException("Failed to create root item!");
        }
        if (this.m_aRoot.getParent() != null) {
            throw new IllegalStateException("Create root item has a non-null parent!!!");
        }
    }

    @Override
    @Nonnull
    public final ITEMTYPE getRootItem() {
        return this.m_aRoot;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        BasicTreeWithID rhs = (BasicTreeWithID)o;
        return this.m_aRoot.equals(rhs.m_aRoot);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aRoot).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("root", this.m_aRoot).toString();
    }
}

