/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.ECSSVersion;
import com.phloc.css.ICSSVersionAware;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSDeclarationContainer;
import com.phloc.css.decl.ICSSTopLevelRule;
import com.phloc.css.decl.IHasCSSDeclarations;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSPageRule
implements ICSSTopLevelRule,
IHasCSSDeclarations,
ICSSVersionAware {
    private final String m_sPseudoPage;
    private final CSSDeclarationContainer m_aDeclarations = new CSSDeclarationContainer();

    public CSSPageRule(@Nullable String sPseudoPage) {
        this.m_sPseudoPage = sPseudoPage;
    }

    @Nullable
    public String getPseudoPage() {
        return this.m_sPseudoPage;
    }

    @Override
    public void addDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        this.m_aDeclarations.addDeclaration(aDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnull CSSDeclaration aDeclaration) {
        return this.m_aDeclarations.removeDeclaration(aDeclaration);
    }

    @Override
    @Nonnull
    public EChange removeDeclaration(@Nonnegative int nDeclarationIndex) {
        return this.m_aDeclarations.removeDeclaration(nDeclarationIndex);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSDeclaration> getAllDeclarations() {
        return this.m_aDeclarations.getAllDeclarations();
    }

    @Override
    @Nullable
    public CSSDeclaration getDeclarationAtIndex(@Nonnegative int nIndex) {
        return this.m_aDeclarations.getDeclarationAtIndex(nIndex);
    }

    @Override
    @Nonnegative
    public int getDeclarationCount() {
        return this.m_aDeclarations.getDeclarationCount();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        aSettings.checkVersionRequirements(this);
        if (!aSettings.isWritePageRules()) {
            return "";
        }
        if (aSettings.isRemoveUnnecessaryCode() && this.getDeclarationCount() == 0) {
            return "";
        }
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder("@page");
        if (StringHelper.hasText((CharSequence)this.m_sPseudoPage)) {
            aSB.append(' ').append(this.m_sPseudoPage);
        }
        aSB.append(this.m_aDeclarations.getAsCSSString(aSettings, nIndentLevel));
        if (!bOptimizedOutput) {
            aSB.append('\n');
        }
        return aSB.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS21;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSPageRule)) {
            return false;
        }
        CSSPageRule rhs = (CSSPageRule)o;
        return this.m_aDeclarations.equals(rhs.m_aDeclarations);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aDeclarations).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declarations", (Object)this.m_aDeclarations).toString();
    }
}

