/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.handler;

import com.phloc.css.ECSSVersion;
import com.phloc.css.decl.CSSDeclaration;
import com.phloc.css.decl.CSSDeclarationList;
import com.phloc.css.decl.CSSExpression;
import com.phloc.css.decl.CSSExpressionMemberFunction;
import com.phloc.css.decl.CSSExpressionMemberMath;
import com.phloc.css.decl.CSSExpressionMemberMathProduct;
import com.phloc.css.decl.CSSExpressionMemberMathUnitProduct;
import com.phloc.css.decl.CSSExpressionMemberMathUnitSimple;
import com.phloc.css.decl.CSSExpressionMemberTermSimple;
import com.phloc.css.decl.CSSExpressionMemberTermURI;
import com.phloc.css.decl.CSSFontFaceRule;
import com.phloc.css.decl.CSSImportRule;
import com.phloc.css.decl.CSSKeyframesBlock;
import com.phloc.css.decl.CSSKeyframesRule;
import com.phloc.css.decl.CSSMediaExpression;
import com.phloc.css.decl.CSSMediaQuery;
import com.phloc.css.decl.CSSMediaRule;
import com.phloc.css.decl.CSSPageRule;
import com.phloc.css.decl.CSSSelector;
import com.phloc.css.decl.CSSSelectorAttribute;
import com.phloc.css.decl.CSSSelectorMemberFunctionLike;
import com.phloc.css.decl.CSSSelectorMemberNot;
import com.phloc.css.decl.CSSSelectorSimpleMember;
import com.phloc.css.decl.CSSStyleRule;
import com.phloc.css.decl.CSSURI;
import com.phloc.css.decl.CascadingStyleSheet;
import com.phloc.css.decl.ECSSAttributeOperator;
import com.phloc.css.decl.ECSSExpressionOperator;
import com.phloc.css.decl.ECSSMathOperator;
import com.phloc.css.decl.ECSSSelectorCombinator;
import com.phloc.css.decl.ICSSExpressionMember;
import com.phloc.css.decl.ICSSSelectorMember;
import com.phloc.css.handler.ECSSNodeType;
import com.phloc.css.media.ECSSMediaExpressionFeature;
import com.phloc.css.media.ECSSMedium;
import com.phloc.css.parser.CSSNode;
import com.phloc.css.parser.ParseUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CSSNodeToDomainObject {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSNodeToDomainObject.class);
    private final ECSSVersion m_eVersion;

    public CSSNodeToDomainObject(@Nonnull ECSSVersion eVersion) {
        if (eVersion == null) {
            throw new NullPointerException("version");
        }
        this.m_eVersion = eVersion;
    }

    private void _expectNodeType(@Nonnull CSSNode aNode, @Nonnull ECSSNodeType eExpected) {
        if (!eExpected.isNode(aNode, this.m_eVersion)) {
            throw new IllegalArgumentException("Expected a '" + eExpected.getNodeName(this.m_eVersion) + "' node but received a '" + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + "' node: " + aNode);
        }
    }

    @Nonnull
    private CSSImportRule _createImportRule(CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.IMPORTRULE);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount > 2) {
            throw new IllegalArgumentException("Expected at last 2 children but got " + nChildCount + "!");
        }
        CSSURI aImportURI = null;
        int nCurrentIndex = 0;
        if (nChildCount > 0) {
            CSSNode aURINode = aNode.jjtGetChild(0);
            if (ECSSNodeType.URI.isNode(aURINode, this.m_eVersion)) {
                aImportURI = new CSSURI(aURINode.getText());
                ++nCurrentIndex;
            } else if (!ECSSNodeType.MEDIALIST.isNode(aURINode, this.m_eVersion)) {
                throw new IllegalStateException("Expected an URI node but got " + ECSSNodeType.getNodeName(aURINode, this.m_eVersion));
            }
        }
        if (aImportURI == null) {
            aImportURI = new CSSURI(ParseUtils.extractStringValue(aNode.getText()));
        }
        CSSImportRule ret = new CSSImportRule(aImportURI);
        if (nChildCount > nCurrentIndex) {
            CSSNode aMediaListNode = aNode.jjtGetChild(nCurrentIndex);
            if (ECSSNodeType.MEDIALIST.isNode(aMediaListNode, this.m_eVersion)) {
                for (CSSNode aMediaQueryNode : aMediaListNode) {
                    ret.addMediaQuery(this._createMediaQuery(aMediaQueryNode));
                }
            } else {
                throw new IllegalStateException("Expected an mediaList node but got " + ECSSNodeType.getNodeName(aMediaListNode, this.m_eVersion));
            }
            ++nCurrentIndex;
        }
        if (nCurrentIndex < nChildCount) {
            s_aLogger.warn("Import statement has children which are unhandled.");
        }
        return ret;
    }

    @Nonnull
    private CSSSelectorAttribute _createSelectorAttribute(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.ATTRIB);
        int nChildren = aNode.jjtGetNumChildren();
        if (nChildren == 0) {
            return new CSSSelectorAttribute(aNode.getText());
        }
        if (nChildren != 2) {
            throw new IllegalArgumentException("Illegal number of children present (" + nChildren + ") - expected 2");
        }
        return new CSSSelectorAttribute(aNode.getText(), ECSSAttributeOperator.getFromNameOrNull(aNode.jjtGetChild(0).getText()), aNode.jjtGetChild(1).getText());
    }

    @Nullable
    private ICSSSelectorMember _createSelectorMember(CSSNode aNode) {
        int nChildCount = aNode.jjtGetNumChildren();
        if (ECSSNodeType.NAMESPACEPREFIX.isNode(aNode, this.m_eVersion) || ECSSNodeType.UNIVERSAL.isNode(aNode, this.m_eVersion) || ECSSNodeType.ELEMENTNAME.isNode(aNode, this.m_eVersion) || ECSSNodeType.HASH.isNode(aNode, this.m_eVersion) || ECSSNodeType.CLASS.isNode(aNode, this.m_eVersion)) {
            if (nChildCount != 0) {
                s_aLogger.warn("CSS simple selector member expected 0 children and got " + nChildCount);
            }
            return new CSSSelectorSimpleMember(aNode.getText());
        }
        if (ECSSNodeType.ATTRIB.isNode(aNode, this.m_eVersion)) {
            return this._createSelectorAttribute(aNode);
        }
        if (ECSSNodeType.COMBINATOR.isNode(aNode, this.m_eVersion)) {
            String sText = aNode.getText();
            ECSSSelectorCombinator eCombinator = ECSSSelectorCombinator.getFromNameOrNull(sText);
            if (eCombinator == null) {
                s_aLogger.warn("Failed to parse CSS selector combinator '" + sText + "'");
            }
            return eCombinator;
        }
        if (ECSSNodeType.NEGATION.isNode(aNode, this.m_eVersion)) {
            if (nChildCount != 1) {
                throw new IllegalArgumentException("CSS Negation expected 1 child and got " + nChildCount);
            }
            CSSNode aChildNode = aNode.jjtGetChild(0);
            ICSSSelectorMember aNestedSelector = this._createSelectorMember(aChildNode);
            return new CSSSelectorMemberNot(aNestedSelector);
        }
        if (ECSSNodeType.PSEUDO.isNode(aNode, this.m_eVersion)) {
            if (nChildCount == 0) {
                return new CSSSelectorSimpleMember(aNode.getText());
            }
            if (nChildCount == 1) {
                CSSNode aChildNode = aNode.jjtGetChild(0);
                if (ECSSNodeType.NTH.isNode(aChildNode, this.m_eVersion)) {
                    return new CSSSelectorSimpleMember(aNode.getText() + aChildNode.getText() + ")");
                }
                CSSExpression aExpr = this._createExpression(aChildNode);
                return new CSSSelectorMemberFunctionLike(aNode.getText(), aExpr);
            }
            throw new UnsupportedOperationException("Not supporting pseudo-selectors with functions and " + nChildCount + " args: " + aNode.toString());
        }
        s_aLogger.warn("Unsupported selector child: " + ECSSNodeType.getNodeName(aNode, this.m_eVersion));
        return null;
    }

    @Nonnull
    private CSSSelector _createSelector(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.SELECTOR);
        CSSSelector ret = new CSSSelector();
        for (CSSNode aChildNode : aNode) {
            ICSSSelectorMember aMember = this._createSelectorMember(aChildNode);
            if (aMember == null) continue;
            ret.addMember(aMember);
        }
        return ret;
    }

    @Nonnull
    private CSSExpressionMemberMathProduct _createExpressionMathProduct(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.MATH_PRODUCT);
        CSSExpressionMemberMathProduct ret = new CSSExpressionMemberMathProduct();
        for (CSSNode aChildNode : aNode) {
            if (ECSSNodeType.MATH_UNIT.isNode(aChildNode, this.m_eVersion)) {
                int nChildCount = aChildNode.jjtGetNumChildren();
                if (nChildCount == 0) {
                    ret.addMember(new CSSExpressionMemberMathUnitSimple(aChildNode.getText()));
                    continue;
                }
                if (nChildCount != 1) {
                    throw new IllegalArgumentException("CSS math unit expected 1 child and got " + nChildCount);
                }
                CSSExpressionMemberMathProduct aNestedProduct = this._createExpressionMathProduct(aChildNode.jjtGetChild(0));
                ret.addMember(new CSSExpressionMemberMathUnitProduct(aNestedProduct));
                continue;
            }
            if (ECSSNodeType.MATH_PRODUCTOPERATOR.isNode(aChildNode, this.m_eVersion)) {
                String sText = aChildNode.getText();
                ECSSMathOperator eMathOp = ECSSMathOperator.getFromNameOrNull(sText);
                if (eMathOp == null) {
                    s_aLogger.warn("Failed to parse math product operator '" + sText + "'");
                    continue;
                }
                ret.addMember(eMathOp);
                continue;
            }
            s_aLogger.warn("Unsupported child of " + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSExpressionMemberMath _createExpressionMathTerm(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.MATH);
        CSSExpressionMemberMath ret = new CSSExpressionMemberMath();
        for (CSSNode aChildNode : aNode) {
            if (ECSSNodeType.MATH_PRODUCT.isNode(aChildNode, this.m_eVersion)) {
                ret.addMember(this._createExpressionMathProduct(aChildNode));
                continue;
            }
            if (ECSSNodeType.MATH_SUMOPERATOR.isNode(aChildNode, this.m_eVersion)) {
                String sText = aChildNode.getText();
                ECSSMathOperator eMathOp = ECSSMathOperator.getFromNameOrNull(sText);
                if (eMathOp == null) {
                    s_aLogger.warn("Failed to parse math operator '" + sText + "'");
                    continue;
                }
                ret.addMember(eMathOp);
                continue;
            }
            s_aLogger.warn("Unsupported child of " + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private ICSSExpressionMember _createExpressionTerm(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.TERM);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount != 0 && nChildCount != 1) {
            throw new IllegalArgumentException("Expected 0 or 1 children but got " + nChildCount + "!");
        }
        if (nChildCount == 0) {
            return new CSSExpressionMemberTermSimple(aNode.getText());
        }
        CSSNode aChildNode = aNode.jjtGetChild(0);
        int nChildChildren = aChildNode.jjtGetNumChildren();
        if (ECSSNodeType.URI.isNode(aChildNode, this.m_eVersion)) {
            if (nChildChildren > 0) {
                throw new IllegalArgumentException("Expected 0 children but got " + nChildChildren + "!");
            }
            CSSURI aURI = new CSSURI(aChildNode.getText());
            return new CSSExpressionMemberTermURI(aURI);
        }
        if (ECSSNodeType.FUNCTION.isNode(aChildNode, this.m_eVersion)) {
            if (nChildChildren > 1) {
                throw new IllegalArgumentException("Expected 0 or 1 children but got " + nChildChildren + "!");
            }
            String sFunctionName = aChildNode.getText();
            if (nChildChildren == 1) {
                CSSExpression aFuncExpr = this._createExpression(aChildNode.jjtGetChild(0));
                return new CSSExpressionMemberFunction(sFunctionName, aFuncExpr);
            }
            return new CSSExpressionMemberFunction(sFunctionName);
        }
        if (ECSSNodeType.MATH.isNode(aChildNode, this.m_eVersion)) {
            return this._createExpressionMathTerm(aChildNode);
        }
        throw new IllegalStateException("Expected an expression term but got " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
    }

    @Nonnull
    private CSSExpression _createExpression(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.EXPR);
        CSSExpression ret = new CSSExpression();
        for (CSSNode aChildNode : aNode) {
            if (ECSSNodeType.TERM.isNode(aChildNode, this.m_eVersion)) {
                ret.addMember(this._createExpressionTerm(aChildNode));
                continue;
            }
            if (ECSSNodeType.OPERATOR.isNode(aChildNode, this.m_eVersion)) {
                String sText = aChildNode.getText();
                ECSSExpressionOperator eOp = ECSSExpressionOperator.getFromNameOrNull(sText);
                if (eOp == null) {
                    s_aLogger.warn("Failed to parse expression operator '" + sText + "'");
                    continue;
                }
                ret.addMember(eOp);
                continue;
            }
            s_aLogger.warn("Unsupported child of " + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSDeclaration _createDeclaration(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.DECLARATION);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount != 2 && nChildCount != 3) {
            throw new IllegalArgumentException("Expected 2 or 3 children but got " + nChildCount + ": " + aNode);
        }
        String sProperty = aNode.jjtGetChild(0).getText();
        CSSExpression aExpression = this._createExpression(aNode.jjtGetChild(1));
        boolean bImportant = false;
        if (nChildCount == 3) {
            CSSNode aChildNode = aNode.jjtGetChild(2);
            if (ECSSNodeType.IMPORTANT.isNode(aChildNode, this.m_eVersion)) {
                bImportant = true;
            } else {
                s_aLogger.warn("Expected an " + ECSSNodeType.IMPORTANT.getNodeName(this.m_eVersion) + " token but got a " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
            }
        }
        return new CSSDeclaration(sProperty, aExpression, bImportant);
    }

    @Nonnull
    private CSSStyleRule _createStyleRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.STYLERULE);
        CSSStyleRule ret = new CSSStyleRule();
        boolean bSelectors = true;
        for (CSSNode aChildNode : aNode) {
            if (ECSSNodeType.SELECTOR.isNode(aChildNode, this.m_eVersion)) {
                if (!bSelectors) {
                    s_aLogger.error("Found a selector after a declaration!");
                }
                ret.addSelector(this._createSelector(aChildNode));
                continue;
            }
            bSelectors = false;
            if (ECSSNodeType.STYLEDECLARATION.isNode(aChildNode, this.m_eVersion)) {
                int nDecls = aChildNode.jjtGetNumChildren();
                for (int nDecl = 0; nDecl < nDecls; ++nDecl) {
                    ret.addDeclaration(this._createDeclaration(aChildNode.jjtGetChild(nDecl)));
                }
                continue;
            }
            if (ECSSNodeType.ERROR_SKIPTO.isNode(aChildNode, this.m_eVersion)) continue;
            s_aLogger.warn("Unsupported child of " + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private CSSPageRule _createPageRule(@Nonnull CSSNode aNode) {
        CSSNode aFirstChild;
        this._expectNodeType(aNode, ECSSNodeType.PAGERULE);
        int nChildCount = aNode.jjtGetNumChildren();
        String sPseudoPage = null;
        int nStartIndex = 0;
        if (nChildCount > 0 && ECSSNodeType.PSEUDOPAGE.isNode(aFirstChild = aNode.jjtGetChild(0), this.m_eVersion)) {
            sPseudoPage = aFirstChild.getText();
            ++nStartIndex;
        }
        CSSPageRule ret = new CSSPageRule(sPseudoPage);
        for (int nIndex = nStartIndex; nIndex < nChildCount; ++nIndex) {
            CSSNode aChildNode = aNode.jjtGetChild(nIndex);
            if (ECSSNodeType.STYLEDECLARATION.isNode(aChildNode, this.m_eVersion)) {
                int nDecls = aChildNode.jjtGetNumChildren();
                for (int nDecl = 0; nDecl < nDecls; ++nDecl) {
                    ret.addDeclaration(this._createDeclaration(aChildNode.jjtGetChild(nDecl)));
                }
                continue;
            }
            if (ECSSNodeType.ERROR_SKIPTO.isNode(aChildNode, this.m_eVersion)) continue;
            s_aLogger.warn("Unsupported page rule child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSMediaRule _createMediaRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.MEDIARULE);
        CSSMediaRule ret = new CSSMediaRule();
        for (CSSNode aChildNode : aNode) {
            if (ECSSNodeType.MEDIALIST.isNode(aChildNode, this.m_eVersion)) {
                for (CSSNode aMediaListChildNode : aChildNode) {
                    ret.addMediaQuery(this._createMediaQuery(aMediaListChildNode));
                }
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createStyleRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createPageRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createFontFaceRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createKeyframesRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.ERROR_SKIPTO.isNode(aChildNode, this.m_eVersion)) continue;
            s_aLogger.warn("Unsupported media-rule child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    private CSSMediaQuery _createMediaQuery(@Nonnull CSSNode aNode) {
        CSSNode aNextChild;
        CSSNode aFirstChildNode;
        if (ECSSNodeType.MEDIUM.isNode(aNode, this.m_eVersion)) {
            String sMedium = aNode.getText();
            if (ECSSMedium.getFromNameOrNull(sMedium) == null) {
                s_aLogger.warn("CSS " + this.m_eVersion.getVersionString() + " Media query uses unknown medium '" + sMedium + "'");
            }
            return new CSSMediaQuery(CSSMediaQuery.EModifier.NONE, sMedium);
        }
        this._expectNodeType(aNode, ECSSNodeType.MEDIAQUERY);
        int nChildCount = aNode.jjtGetNumChildren();
        int nStartIndex = 0;
        CSSMediaQuery.EModifier eModifier = CSSMediaQuery.EModifier.NONE;
        if (nChildCount > 0 && ECSSNodeType.MEDIAMODIFIER.isNode(aFirstChildNode = aNode.jjtGetChild(0), this.m_eVersion)) {
            String sMediaModifier = aFirstChildNode.getText();
            if (sMediaModifier != null) {
                if ("not".equalsIgnoreCase(sMediaModifier)) {
                    eModifier = CSSMediaQuery.EModifier.NOT;
                } else if ("only".equalsIgnoreCase(sMediaModifier)) {
                    eModifier = CSSMediaQuery.EModifier.ONLY;
                } else {
                    s_aLogger.warn("Unsupported media modifier '" + sMediaModifier + "' found!");
                }
            }
            ++nStartIndex;
        }
        String sMedium = null;
        if (nChildCount > nStartIndex && ECSSNodeType.MEDIUM.isNode(aNextChild = aNode.jjtGetChild(nStartIndex), this.m_eVersion)) {
            sMedium = aNextChild.getText();
            if (ECSSMedium.getFromNameOrNull(sMedium) == null) {
                s_aLogger.warn("CSS " + this.m_eVersion.getVersionString() + " media query uses unknown medium '" + sMedium + "'");
            }
            ++nStartIndex;
        }
        CSSMediaQuery ret = new CSSMediaQuery(eModifier, sMedium);
        for (int i = nStartIndex; i < nChildCount; ++i) {
            CSSNode aChildNode = aNode.jjtGetChild(i);
            if (ECSSNodeType.MEDIAEXPR.isNode(aChildNode, this.m_eVersion)) {
                ret.addMediaExpression(this._createMediaExpr(aChildNode));
                continue;
            }
            if (ECSSNodeType.ERROR_SKIPTO.isNode(aChildNode, this.m_eVersion)) continue;
            s_aLogger.warn("Unsupported media query child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSMediaExpression _createMediaExpr(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.MEDIAEXPR);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount != 1 && nChildCount != 2) {
            throw new IllegalArgumentException("Expected 1 or 2 children but got " + nChildCount + ": " + aNode);
        }
        CSSNode aFeatureNode = aNode.jjtGetChild(0);
        if (!ECSSNodeType.MEDIAFEATURE.isNode(aFeatureNode, this.m_eVersion)) {
            throw new IllegalStateException("Expected a media feature but got " + ECSSNodeType.getNodeName(aFeatureNode, this.m_eVersion));
        }
        String sFeature = aFeatureNode.getText();
        if (ECSSMediaExpressionFeature.getFromNameOrNull(sFeature) == null) {
            s_aLogger.warn("Media expression uses unsupported feature '" + sFeature + "'");
        }
        if (nChildCount == 1) {
            return new CSSMediaExpression(sFeature);
        }
        CSSNode aValueNode = aNode.jjtGetChild(1);
        return new CSSMediaExpression(sFeature, this._createExpression(aValueNode));
    }

    @Nonnull
    private CSSFontFaceRule _createFontFaceRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.FONTFACERULE);
        CSSFontFaceRule ret = new CSSFontFaceRule();
        for (CSSNode aChildNode : aNode) {
            if (ECSSNodeType.STYLEDECLARATION.isNode(aChildNode, this.m_eVersion)) {
                int nDecls = aChildNode.jjtGetNumChildren();
                for (int nDecl = 0; nDecl < nDecls; ++nDecl) {
                    ret.addDeclaration(this._createDeclaration(aChildNode.jjtGetChild(nDecl)));
                }
                continue;
            }
            if (ECSSNodeType.ERROR_SKIPTO.isNode(aChildNode, this.m_eVersion)) continue;
            s_aLogger.warn("Unsupported font-face rule child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    private CSSKeyframesRule _createKeyframesRule(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.KEYFRAMESRULE);
        int nChildCount = aNode.jjtGetNumChildren();
        if (nChildCount == 0) {
            throw new IllegalArgumentException("Expected at least 1 child but got " + nChildCount + ": " + aNode);
        }
        String sKeyframesDeclaration = aNode.getText();
        CSSNode aAnimationNameNode = aNode.jjtGetChild(0);
        this._expectNodeType(aAnimationNameNode, ECSSNodeType.KEYFRAMESIDENTIFIER);
        String sAnimationName = aAnimationNameNode.getText();
        CSSKeyframesRule ret = new CSSKeyframesRule(sKeyframesDeclaration, sAnimationName);
        CSSKeyframesBlock aBlock = null;
        for (int nIndex = 1; nIndex < nChildCount; ++nIndex) {
            CSSNode aChildNode = aNode.jjtGetChild(nIndex);
            if (ECSSNodeType.KEYFRAMESSELECTOR.isNode(aChildNode, this.m_eVersion)) {
                ArrayList<String> aKeyframesSelectors = new ArrayList<String>();
                for (CSSNode aSelectorChild : aChildNode) {
                    this._expectNodeType(aSelectorChild, ECSSNodeType.SINGLEKEYFRAMESELECTOR);
                    aKeyframesSelectors.add(aSelectorChild.getText());
                }
                aBlock = new CSSKeyframesBlock(aKeyframesSelectors);
                ret.addBlock(aBlock);
                continue;
            }
            if (ECSSNodeType.STYLEDECLARATION.isNode(aChildNode, this.m_eVersion)) {
                if (aBlock == null) {
                    throw new IllegalStateException("No keyframes block present!");
                }
                int nDecls = aChildNode.jjtGetNumChildren();
                for (int nDecl = 0; nDecl < nDecls; ++nDecl) {
                    aBlock.addDeclaration(this._createDeclaration(aChildNode.jjtGetChild(nDecl)));
                }
                continue;
            }
            if (ECSSNodeType.ERROR_SKIPTO.isNode(aChildNode, this.m_eVersion)) continue;
            s_aLogger.warn("Unsupported keyframes rule child: " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    public CascadingStyleSheet createCascadingStyleSheetFromNode(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.ROOT);
        CascadingStyleSheet ret = new CascadingStyleSheet();
        for (CSSNode aChildNode : aNode) {
            if (ECSSNodeType.CHARSET.isNode(aChildNode, this.m_eVersion)) continue;
            if (ECSSNodeType.IMPORTRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addImportRule(this._createImportRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.STYLERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createStyleRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.PAGERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createPageRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.MEDIARULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createMediaRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.FONTFACERULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createFontFaceRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.KEYFRAMESRULE.isNode(aChildNode, this.m_eVersion)) {
                ret.addRule(this._createKeyframesRule(aChildNode));
                continue;
            }
            if (ECSSNodeType.UNKNOWNRULE.isNode(aChildNode, this.m_eVersion)) {
                s_aLogger.warn("Unknown rule object is currently ignored: " + aChildNode);
                continue;
            }
            s_aLogger.warn("Unsupported child of " + ECSSNodeType.getNodeName(aNode, this.m_eVersion) + ": " + ECSSNodeType.getNodeName(aChildNode, this.m_eVersion));
        }
        return ret;
    }

    @Nonnull
    public CSSDeclarationList createDeclarationListFromNode(@Nonnull CSSNode aNode) {
        this._expectNodeType(aNode, ECSSNodeType.STYLEDECLARATION);
        CSSDeclarationList ret = new CSSDeclarationList();
        int nDecls = aNode.jjtGetNumChildren();
        for (int nDecl = 0; nDecl < nDecls; ++nDecl) {
            ret.addDeclaration(this._createDeclaration(aNode.jjtGetChild(nDecl)));
        }
        return ret;
    }
}

