/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.cff.CFFDataInput;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CFFParser;
import org.apache.fontbox.cff.charset.CFFCharset;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.OpenFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTFFile
extends OpenFont {
    protected CFFFont fileFont;

    public OTFFile() throws IOException {
        this.checkForFontbox();
    }

    private void checkForFontbox() throws IOException {
        try {
            Class.forName("org.apache.fontbox.cff.CFFFont");
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("The Fontbox jar was not found in the classpath. This is required for OTF CFF ssupport.");
        }
    }

    @Override
    protected void updateBBoxAndOffset() throws IOException {
        List<Mapping> gidMappings = this.getGIDMappings(this.fileFont);
        Map<Integer, String> sidNames = this.constructNameMap(gidMappings);
        OpenFont.UnicodeMapping[] mappings = this.unicodeMappings.toArray(new OpenFont.UnicodeMapping[this.unicodeMappings.size()]);
        for (int i = 0; i < mappings.length; ++i) {
            int glyphIdx = mappings[i].getGlyphIndex();
            Mapping m = gidMappings.get(glyphIdx);
            String name = sidNames.get(m.getSID());
            this.mtxTab[glyphIdx].setName(name);
        }
    }

    private List<Mapping> getGIDMappings(CFFFont font) {
        ArrayList<Mapping> gidMappings = new ArrayList<Mapping>();
        Mapping notdef = new Mapping();
        gidMappings.add(notdef);
        for (CFFCharset.Entry entry : font.getCharset().getEntries()) {
            String name = entry.getName();
            byte[] bytes = (byte[])font.getCharStringsDict().get(name);
            if (bytes == null) continue;
            Mapping mapping = new Mapping();
            mapping.setSID(entry.getSID());
            mapping.setName(name);
            mapping.setBytes(bytes);
            gidMappings.add(mapping);
        }
        return gidMappings;
    }

    private Map<Integer, String> constructNameMap(Collection<Mapping> mappings) {
        HashMap<Integer, String> sidNames = new HashMap<Integer, String>();
        for (Mapping mapping : mappings) {
            sidNames.put(mapping.getSID(), mapping.getName());
        }
        return sidNames;
    }

    @Override
    protected void initializeFont(FontFileReader in) throws IOException {
        this.fontFile = in;
        this.fontFile.seekSet(0L);
        CFFParser parser = new CFFParser();
        this.fileFont = (CFFFont)parser.parse(in.getAllBytes()).get(0);
    }

    @Override
    protected void readName() throws IOException {
        Object familyName = this.fileFont.getProperty("FamilyName");
        if (familyName != null && !familyName.equals("")) {
            this.familyNames.add(familyName.toString());
            this.fullName = familyName.toString();
        } else {
            this.fullName = this.fileFont.getName();
            this.familyNames.add(this.fullName);
        }
    }

    public static byte[] getCFFData(FontFileReader fontFile) throws IOException {
        byte[] cff = fontFile.getAllBytes();
        CFFDataInput input = new CFFDataInput(fontFile.getAllBytes());
        input.readBytes(4);
        int numTables = input.readShort();
        input.readShort();
        input.readShort();
        input.readShort();
        for (int q = 0; q < numTables; ++q) {
            String tagName = new String(input.readBytes(4));
            OTFFile.readLong(input);
            long offset = OTFFile.readLong(input);
            long length = OTFFile.readLong(input);
            if (!tagName.equals("CFF ")) continue;
            cff = new byte[(int)length];
            System.arraycopy(fontFile.getAllBytes(), (int)offset, cff, 0, cff.length);
            break;
        }
        return cff;
    }

    private static long readLong(CFFDataInput input) throws IOException {
        return input.readCard16() << 16 | input.readCard16();
    }

    private static class Mapping {
        private int sid;
        private String name;
        private byte[] bytes;

        private Mapping() {
        }

        public void setSID(int sid) {
            this.sid = sid;
        }

        public int getSID() {
            return this.sid;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

