/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.area.Area;
import org.apache.fop.area.SideFloat;
import org.apache.fop.fo.flow.Float;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.layoutmgr.AreaAdditionUtil;
import org.apache.fop.layoutmgr.BlockLayoutManager;
import org.apache.fop.layoutmgr.Keep;
import org.apache.fop.layoutmgr.KnuthBlockBox;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.SpacedBorderedPaddedBlockLayoutManager;
import org.apache.fop.layoutmgr.inline.FloatLayoutManager;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatContentLayoutManager
extends SpacedBorderedPaddedBlockLayoutManager {
    private SideFloat floatContentArea;
    private int side;
    private int yOffset;

    public FloatContentLayoutManager(Float node) {
        super(node);
        this.generatesReferenceArea = true;
        this.side = node.getFloat();
    }

    @Override
    public Keep getKeepTogether() {
        return this.getParentKeepTogether();
    }

    @Override
    public Keep getKeepWithNext() {
        return Keep.KEEP_AUTO;
    }

    @Override
    public Keep getKeepWithPrevious() {
        return Keep.KEEP_ALWAYS;
    }

    @Override
    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        this.floatContentArea = new SideFloat();
        AreaAdditionUtil.addAreas(this, parentIter, layoutContext);
        this.flush();
    }

    @Override
    public void addChildArea(Area childArea) {
        this.floatContentArea.addChildArea(childArea);
        this.floatContentArea.setBPD(childArea.getAllocBPD());
        int effectiveContentIPD = childArea.getEffectiveAllocIPD();
        int contentIPD = childArea.getIPD();
        int xOffset = childArea.getBorderAndPaddingWidthStart();
        this.floatContentArea.setIPD(effectiveContentIPD);
        childArea.activateEffectiveIPD();
        if (this.side == 39 || this.side == 120) {
            this.floatContentArea.setXOffset((xOffset += this.getStartIndent()) + contentIPD - effectiveContentIPD);
        } else if (this.side == 135 || this.side == 73) {
            this.floatContentArea.setXOffset(xOffset);
        }
        LayoutManager lm = this.parentLayoutManager;
        while (!lm.getGeneratesReferenceArea()) {
            lm = lm.getParent();
        }
        this.yOffset = lm.getParentArea(this.floatContentArea).getBPD();
        lm.addChildArea(this.floatContentArea);
        if (this.side == 39 || this.side == 120) {
            lm.getPSLM().setEndIntrusionAdjustment(effectiveContentIPD);
        } else if (this.side == 135 || this.side == 73) {
            lm.getPSLM().setStartIntrusionAdjustment(effectiveContentIPD);
        }
    }

    public static List<FloatContentLayoutManager> checkForFloats(List<ListElement> elemenList, int startIndex, int endIndex) {
        ListIterator<ListElement> iter = elemenList.listIterator(startIndex);
        ArrayList<FloatContentLayoutManager> floats = new ArrayList<FloatContentLayoutManager>();
        while (iter.nextIndex() <= endIndex) {
            ListElement element = iter.next();
            if (element instanceof KnuthInlineBox && ((KnuthInlineBox)element).isFloatAnchor()) {
                floats.add(((KnuthInlineBox)element).getFloatContentLM());
                continue;
            }
            if (!(element instanceof KnuthBlockBox) || !((KnuthBlockBox)element).hasFloatAnchors()) continue;
            floats.addAll(((KnuthBlockBox)element).getFloatContentLMs());
        }
        if (floats.isEmpty()) {
            return Collections.emptyList();
        }
        return floats;
    }

    @Override
    protected CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return null;
    }

    public void processAreas(LayoutContext layoutContext) {
        if (this.getParent() instanceof FloatLayoutManager) {
            FloatLayoutManager flm = (FloatLayoutManager)this.getParent();
            flm.processAreas(layoutContext);
        }
    }

    public int getFloatHeight() {
        return this.floatContentArea.getAllocBPD();
    }

    public int getFloatYOffset() {
        return this.yOffset;
    }

    private int getStartIndent() {
        LayoutManager lm = this.getParent();
        while (!(lm instanceof BlockLayoutManager)) {
            lm = lm.getParent();
        }
        int startIndent = ((BlockLayoutManager)lm).startIndent;
        return startIndent;
    }
}

