/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.codec;

import com.phloc.commons.codec.DecoderException;
import com.phloc.commons.codec.IByteArrayDecoder;
import com.phloc.commons.io.streams.NonBlockingByteArrayInputStream;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DCTCodec
implements IByteArrayDecoder {
    private static final Logger s_aLogger = LoggerFactory.getLogger(DCTCodec.class);

    @Override
    @Nullable
    public byte[] decode(@Nullable byte[] aEncodedBuffer) {
        BufferedImage aImg;
        if (aEncodedBuffer == null) {
            return null;
        }
        try {
            aImg = ImageIO.read(new NonBlockingByteArrayInputStream(aEncodedBuffer));
            if (aImg == null) {
                throw new DecoderException("Failed to read image");
            }
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Read DCT encoded image with " + aEncodedBuffer.length + " bytes");
            }
        }
        catch (Throwable t) {
            throw new DecoderException("Failed to read image", t);
        }
        int nWidth = ((Image)aImg).getWidth(null);
        int nHeight = ((Image)aImg).getHeight(null);
        int[] aPixels = new int[nWidth * nHeight];
        PixelGrabber aGrabber = new PixelGrabber(aImg, 0, 0, nWidth, nHeight, aPixels, 0, nWidth);
        try {
            if (!aGrabber.grabPixels()) {
                throw new DecoderException("Failed to grab pixels!");
            }
        }
        catch (InterruptedException ex) {
            throw new DecoderException(ex);
        }
        byte[] ret = new byte[aPixels.length * 3];
        for (int i = 0; i < aPixels.length; ++i) {
            ret[i * 3] = (byte)(aPixels[i] >> 24 & 0xFF);
            ret[i * 3 + 1] = (byte)(aPixels[i] >> 16 & 0xFF);
            ret[i * 3 + 2] = (byte)(aPixels[i] >> 8 & 0xFF);
        }
        return ret;
    }
}

