/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.pair;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.collections.pair.ComparatorPairFirst;
import com.phloc.commons.collections.pair.ComparatorPairSecond;
import com.phloc.commons.collections.pair.IReadonlyPair;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PairUtils {
    private PairUtils() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <V1 extends Comparable<? super V1>, V2> List<IReadonlyPair<V1, V2>> getSortedByPairFirst(@Nonnull Collection<? extends IReadonlyPair<V1, V2>> aList) {
        return ContainerHelper.getSorted(aList, new ComparatorPairFirst());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <V1, V2 extends Comparable<? super V2>> List<IReadonlyPair<V1, V2>> getSortedByPairSecond(@Nonnull Collection<? extends IReadonlyPair<V1, V2>> aList) {
        return ContainerHelper.getSorted(aList, new ComparatorPairSecond());
    }
}

