/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.graph.impl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.collections.attrs.MapBasedAttributeContainer;
import com.phloc.commons.graph.IGraphObject;
import com.phloc.commons.graph.impl.GraphObjectIDFactory;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractGraphObject
extends MapBasedAttributeContainer
implements IGraphObject {
    private final String m_sID;

    public AbstractGraphObject(@Nullable String sID) {
        this.m_sID = StringHelper.hasNoText(sID) ? GraphObjectIDFactory.createNewGraphObjectID() : sID;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getID() {
        return this.m_sID;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractGraphObject rhs = (AbstractGraphObject)o;
        return this.m_sID.equals(rhs.m_sID);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_sID).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("id", this.m_sID).toString();
    }
}

