/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.annotations.ReturnsImmutableObject;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.xml.XMLFactory;
import com.phloc.commons.xml.dom.EXMLDOMFeature;
import com.phloc.commons.xml.dom.EXMLDOMFeatureVersion;
import com.phloc.commons.xml.dom.EXMLDOMNodeType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;

public final class XMLDebug {
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLDebug.class);
    private static final Map<EXMLDOMFeatureVersion, List<String>> s_aSupportedFeatures = new LinkedHashMap<EXMLDOMFeatureVersion, List<String>>();
    private static final XMLDebug s_aInstance;

    private static void _initFeature(@Nonnull EXMLDOMFeature eFeature) {
        DOMImplementation aDOMImplementation = XMLFactory.getDOMImplementation();
        for (EXMLDOMFeatureVersion eFeatureVersion : EXMLDOMFeatureVersion.values()) {
            if (aDOMImplementation.hasFeature(eFeature.getID(), eFeatureVersion.getID())) {
                s_aSupportedFeatures.get(eFeatureVersion).add(eFeature.getID());
                continue;
            }
            if (!aDOMImplementation.hasFeature(eFeature.getPlusFeature(), eFeatureVersion.getID())) continue;
            s_aSupportedFeatures.get(eFeatureVersion).add(eFeature.getPlusFeature());
        }
    }

    private XMLDebug() {
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Map<EXMLDOMFeatureVersion, List<String>> getSupportedFeatures() {
        return ContainerHelper.makeUnmodifiable(s_aSupportedFeatures);
    }

    @Nullable
    public static List<String> getSupportedFeatures(@Nonnull EXMLDOMFeatureVersion eFeatureVersion) {
        return s_aSupportedFeatures.get(eFeatureVersion);
    }

    public static void debugLogDOMFeatures() {
        for (Map.Entry<EXMLDOMFeatureVersion, List<String>> aEntry : s_aSupportedFeatures.entrySet()) {
            for (String sFeature : aEntry.getValue()) {
                s_aLogger.info("DOM " + aEntry.getKey().getID() + " feature '" + sFeature + "' is present");
            }
        }
    }

    @Nonnull
    public static String getNodeTypeAsString(int nNodeType) {
        EXMLDOMNodeType eNodeType = EXMLDOMNodeType.getFromIDOrNull(nNodeType);
        if (eNodeType != null) {
            return eNodeType.name();
        }
        s_aLogger.warn("Unknown Node type " + nNodeType);
        return Integer.toString(nNodeType);
    }

    static {
        for (EXMLDOMFeatureVersion eFeatureVersion : EXMLDOMFeatureVersion.values()) {
            s_aSupportedFeatures.put(eFeatureVersion, new ArrayList());
        }
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_CORE);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_XML);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_UI_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_MOUSE_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_TEXT_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_KEYBOARD_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_MUTATION_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_MUTATION_NAME_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_HTML_EVENTS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_LS);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_LS_ASYNC);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_VALIDATION);
        XMLDebug._initFeature(EXMLDOMFeature.DOM_FEATURE_XPATH);
        s_aInstance = new XMLDebug();
    }
}

