/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.changelog;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.ReturnsImmutableObject;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.changelog.AbstractChangeLogEntry;
import com.phloc.commons.changelog.ChangeLogEntry;
import com.phloc.commons.changelog.ChangeLogRelease;
import com.phloc.commons.changelog.EChangeLogCategory;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.version.Version;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ChangeLog {
    private final Version m_aVersion;
    private final String m_sComponent;
    private final List<AbstractChangeLogEntry> m_aEntries = new ArrayList<AbstractChangeLogEntry>();

    public ChangeLog(@Nonnull Version aVersion, @Nonnull @Nonempty String sComponent) {
        if (aVersion == null) {
            throw new NullPointerException("version");
        }
        if (StringHelper.hasNoText(sComponent)) {
            throw new IllegalArgumentException("component");
        }
        this.m_aVersion = aVersion;
        this.m_sComponent = sComponent;
    }

    @Nonnull
    public Version getVersion() {
        return this.m_aVersion;
    }

    @Nonnull
    @Nonempty
    public String getComponent() {
        return this.m_sComponent;
    }

    public void addEntry(@Nonnull ChangeLogEntry aEntry) {
        if (aEntry == null) {
            throw new NullPointerException("entry");
        }
        this.m_aEntries.add(aEntry);
    }

    public void addEntry(@Nonnegative int nIndex, @Nonnull ChangeLogEntry aEntry) {
        if (aEntry == null) {
            throw new NullPointerException("entry");
        }
        this.m_aEntries.add(nIndex, aEntry);
    }

    @Nonnull
    @ReturnsImmutableObject
    public List<AbstractChangeLogEntry> getAllBaseEntries() {
        return ContainerHelper.makeUnmodifiable(this.m_aEntries);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ChangeLogEntry> getAllEntries() {
        ArrayList<ChangeLogEntry> ret = new ArrayList<ChangeLogEntry>();
        for (AbstractChangeLogEntry aEntry : this.m_aEntries) {
            if (!(aEntry instanceof ChangeLogEntry)) continue;
            ret.add((ChangeLogEntry)aEntry);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ChangeLogEntry> getAllEntriesOfCategory(@Nonnull EChangeLogCategory eCategory) {
        if (eCategory == null) {
            throw new NullPointerException("category");
        }
        ArrayList<ChangeLogEntry> ret = new ArrayList<ChangeLogEntry>();
        for (AbstractChangeLogEntry aEntry : this.m_aEntries) {
            ChangeLogEntry aRealEntry;
            if (!(aEntry instanceof ChangeLogEntry) || !(aRealEntry = (ChangeLogEntry)aEntry).getCategory().equals(eCategory)) continue;
            ret.add(aRealEntry);
        }
        return ret;
    }

    public void addRelease(@Nonnull ChangeLogRelease aRelease) {
        if (aRelease == null) {
            throw new NullPointerException("release");
        }
        this.m_aEntries.add(aRelease);
    }

    public void addRelease(@Nonnegative int nIndex, @Nonnull ChangeLogRelease aRelease) {
        if (aRelease == null) {
            throw new NullPointerException("release");
        }
        this.m_aEntries.add(nIndex, aRelease);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ChangeLogRelease> getAllReleases() {
        ArrayList<ChangeLogRelease> ret = new ArrayList<ChangeLogRelease>();
        for (AbstractChangeLogEntry aEntry : this.m_aEntries) {
            if (!(aEntry instanceof ChangeLogRelease)) continue;
            ret.add((ChangeLogRelease)aEntry);
        }
        return ret;
    }

    @Nullable
    public ChangeLogRelease getLatestRelease() {
        ChangeLogRelease aLatest = null;
        for (AbstractChangeLogEntry aEntry : this.m_aEntries) {
            if (!(aEntry instanceof ChangeLogRelease)) continue;
            ChangeLogRelease aRelease = (ChangeLogRelease)aEntry;
            if (aLatest != null && aRelease.getDate().getTime() <= aLatest.getDate().getTime()) continue;
            aLatest = aRelease;
        }
        return aLatest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeLog)) {
            return false;
        }
        ChangeLog rhs = (ChangeLog)o;
        return this.m_aVersion.equals(rhs.m_aVersion) && this.m_sComponent.equals(rhs.m_sComponent) && ((Object)this.m_aEntries).equals(rhs.m_aEntries);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aVersion).append(this.m_sComponent).append(this.m_aEntries)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("version", this.m_aVersion).append("component", this.m_sComponent).append("entries", this.m_aEntries).toString();
    }
}

