/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.filter;

import com.phloc.commons.filter.IFilter;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractFilter<DATATYPE>
implements IFilter<DATATYPE> {
    private final IFilter<DATATYPE> m_aNestedFilter;

    public AbstractFilter() {
        this(null);
    }

    public AbstractFilter(@Nullable IFilter<DATATYPE> aCustomFilter) {
        this.m_aNestedFilter = aCustomFilter;
    }

    protected abstract boolean matchesThisFilter(DATATYPE var1);

    @Override
    public final boolean matchesFilter(DATATYPE aValue) {
        if (this.matchesThisFilter(aValue)) {
            return true;
        }
        if (this.m_aNestedFilter == null) {
            return true;
        }
        return this.m_aNestedFilter.matchesFilter(aValue);
    }

    @Nullable
    public IFilter<DATATYPE> getNestedFilter() {
        return this.m_aNestedFilter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        AbstractFilter rhs = (AbstractFilter)o;
        return this.m_aNestedFilter.equals(rhs.m_aNestedFilter);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aNestedFilter).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("customFilter", this.m_aNestedFilter).toString();
    }
}

