/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mutable;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mutable.IMutableNumeric;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MutableFloat
extends Number
implements IMutableNumeric<MutableFloat> {
    public static final float DEFAULT_VALUE = 0.0f;
    private float m_fValue;

    public MutableFloat() {
        this(0.0f);
    }

    public MutableFloat(@Nonnull Float aValue) {
        this(aValue.floatValue());
    }

    public MutableFloat(float fValue) {
        this.m_fValue = fValue;
    }

    @Override
    public float floatValue() {
        return this.m_fValue;
    }

    @Nonnull
    public Float getAsFloat() {
        return Float.valueOf(this.m_fValue);
    }

    @Override
    public double doubleValue() {
        return this.m_fValue;
    }

    @Override
    public int intValue() {
        return (int)this.m_fValue;
    }

    @Override
    public long longValue() {
        return (long)this.m_fValue;
    }

    public float inc() {
        return this.inc(1.0f);
    }

    public float inc(float fDelta) {
        this.m_fValue += fDelta;
        return this.m_fValue;
    }

    public float dec() {
        return this.inc(-1.0f);
    }

    public float dec(float fDelta) {
        return this.inc(-fDelta);
    }

    @Nonnull
    public EChange set(float fValue) {
        if (EqualsUtils.equals(fValue, this.m_fValue)) {
            return EChange.UNCHANGED;
        }
        this.m_fValue = fValue;
        return EChange.CHANGED;
    }

    @Override
    public boolean is0() {
        return EqualsUtils.equals(this.m_fValue, 0.0f);
    }

    @Override
    public boolean isNot0() {
        return !this.is0();
    }

    @Override
    public boolean isSmaller0() {
        return Double.compare(this.m_fValue, 0.0) < 0;
    }

    @Override
    public boolean isSmallerOrEqual0() {
        return Double.compare(this.m_fValue, 0.0) <= 0;
    }

    @Override
    public boolean isGreater0() {
        return Double.compare(this.m_fValue, 0.0) > 0;
    }

    @Override
    public boolean isGreaterOrEqual0() {
        return Double.compare(this.m_fValue, 0.0) >= 0;
    }

    @Override
    public int compareTo(MutableFloat rhs) {
        return Double.compare(this.m_fValue, rhs.m_fValue);
    }

    @Override
    @Nonnull
    public MutableFloat getClone() {
        return new MutableFloat(this.m_fValue);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MutableFloat)) {
            return false;
        }
        MutableFloat rhs = (MutableFloat)o;
        return EqualsUtils.equals(this.m_fValue, rhs.m_fValue);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_fValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_fValue).toString();
    }
}

