/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.ls;

import com.phloc.commons.io.IInputStreamProvider;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.string.ToStringGenerator;
import java.io.InputStream;
import java.io.Reader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.ls.LSInput;

public final class ResourceLSInput
implements LSInput {
    private final IInputStreamProvider m_aISP;
    private String m_sEncoding;
    private String m_sPublicId;
    private String m_sSystemId;
    private boolean m_bCertifiedText;
    private String m_sBaseURI;
    private String m_sStringData;

    public ResourceLSInput(@Nonnull IReadableResource aResource) {
        this(aResource, aResource.getResourceID());
    }

    public ResourceLSInput(@Nonnull IInputStreamProvider aISP, @Nullable String sSystemID) {
        if (aISP == null) {
            throw new NullPointerException("inputStreamProvider");
        }
        this.m_aISP = aISP;
        this.setSystemId(sSystemID);
    }

    @Override
    @Nullable
    public String getBaseURI() {
        return this.m_sBaseURI;
    }

    @Override
    public void setBaseURI(@Nullable String sBaseURI) {
        this.m_sBaseURI = sBaseURI;
    }

    @Override
    @Nonnull
    public InputStream getByteStream() {
        return this.m_aISP.getInputStream();
    }

    @Override
    public void setByteStream(InputStream aByteStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getCertifiedText() {
        return this.m_bCertifiedText;
    }

    @Override
    public void setCertifiedText(boolean bCertifiedText) {
        this.m_bCertifiedText = bCertifiedText;
    }

    @Override
    @Nullable
    public Reader getCharacterStream() {
        return null;
    }

    @Override
    public void setCharacterStream(Reader aCharacterStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public String getEncoding() {
        return this.m_sEncoding;
    }

    @Override
    public void setEncoding(@Nullable String sEncoding) {
        this.m_sEncoding = sEncoding;
    }

    @Override
    @Nullable
    public String getPublicId() {
        return this.m_sPublicId;
    }

    @Override
    public void setPublicId(@Nullable String sPublicId) {
        this.m_sPublicId = sPublicId;
    }

    @Override
    @Nullable
    public String getStringData() {
        return this.m_sStringData;
    }

    @Override
    public void setStringData(@Nullable String sStringData) {
        this.m_sStringData = sStringData;
    }

    @Override
    @Nullable
    public String getSystemId() {
        return this.m_sSystemId;
    }

    @Override
    public void setSystemId(@Nullable String sSystemId) {
        this.m_sSystemId = sSystemId;
    }

    public String toString() {
        return new ToStringGenerator(this).append("ISP", this.m_aISP).appendIfNotNull("encoding", this.m_sEncoding).appendIfNotNull("publicId", this.m_sPublicId).appendIfNotNull("systemId", this.m_sSystemId).append("certifiedText", this.m_bCertifiedText).appendIfNotNull("baseURI", this.m_sBaseURI).appendIfNotNull("stringData", this.m_sStringData).toString();
    }
}

