/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.validate.nvdl;

import com.oxygenxml.validate.nvdl.NamespaceSpecification;
import junit.framework.TestCase;

public class NamespaceSpecificationTest
extends TestCase {
    public void testCovers() {
        this.doCovers("*");
        this.doCovers("\\");
        this.doCovers("#");
    }

    public void doCovers(String string) {
        NamespaceSpecification namespaceSpecification = new NamespaceSpecification("##any", NamespaceSpecification.DEFAULT_WILDCARD);
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("##any"));
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("otherNamespace"));
        namespaceSpecification = new NamespaceSpecification("http://www.oxygenxml.com/test", string);
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("##any"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/test"));
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/test1"));
        namespaceSpecification = new NamespaceSpecification("http://www.oxygenxml.com/test" + string, string);
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("##any"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/test"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/test/test"));
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/xtest"));
        namespaceSpecification = new NamespaceSpecification("http://www.oxygenxml.com/" + string + "test", string);
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("##any"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/test"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/test/test"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/xtest"));
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/testx"));
        namespaceSpecification = new NamespaceSpecification(string + "http://www.oxygenxml.com/test", string);
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("##any"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/test"));
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/test/test"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("xhttp://www.oxygenxml.com/test"));
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("xhttp://www.oxygenxml.com/testy"));
        namespaceSpecification = new NamespaceSpecification(string + "http://www.oxygenxml.com/test" + string, string);
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("##any"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/test"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("XXXhttp://www.oxygenxml.com/testXXX"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/testXXX"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("XXXhttp://www.oxygenxml.com/test"));
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("http://www.oxygenxmlX.com/test"));
        namespaceSpecification = new NamespaceSpecification("http://www.oxygenxml.com/" + string + "test" + string, string);
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("##any"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/XXXtest"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/testXXX"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/XXXtestXXXXX"));
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("http://www.oxygenxml.comX/XXXtestXXXXX"));
        namespaceSpecification = new NamespaceSpecification("http://www.oxygenxml." + string + "/" + string + "test", string);
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("##any"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/XXXtest"));
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("http://www.oxygenxml.XXX/XXXtest"));
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("http://www.oxygenxml.com/XXXtestX"));
        namespaceSpecification = new NamespaceSpecification("http://www.oxygenxml." + string + "/" + string + "test", "");
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.covers("http://www.oxygenxml." + string + "/" + string + "test"));
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.covers("http://www.oxygenxml.XXX/" + string + "test"));
    }

    public void testCompete() {
        this.doCompete("*", "*");
        this.doCompete("#", "#");
        this.doCompete("\\", "\\");
        this.doCompete("*", "#");
        this.doCompete("*", "\\");
        this.doCompete("#", "\\");
    }

    private void doCompete(String string, String string2) {
        NamespaceSpecification namespaceSpecification = new NamespaceSpecification("", string);
        NamespaceSpecification namespaceSpecification2 = new NamespaceSpecification("", string2);
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.compete(namespaceSpecification2));
        namespaceSpecification = new NamespaceSpecification("http://www.oxygenxml.com", string);
        namespaceSpecification2 = new NamespaceSpecification("http://www.oxygenxml.com", string2);
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.compete(namespaceSpecification2));
        namespaceSpecification = new NamespaceSpecification("http://www.oxygenxml.com/test", string);
        namespaceSpecification2 = new NamespaceSpecification("http://www.oxygenxml.com", string2);
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.compete(namespaceSpecification2));
        namespaceSpecification = new NamespaceSpecification("http://www.oxygenxml.com" + string, string);
        namespaceSpecification2 = new NamespaceSpecification("http://www.oxygenxml.com", string2);
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.compete(namespaceSpecification2));
        namespaceSpecification = new NamespaceSpecification("http://www.oxygenxml.com" + string, string);
        namespaceSpecification2 = new NamespaceSpecification("http://www.oxygenxml.com/test", string2);
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.compete(namespaceSpecification2));
        namespaceSpecification = new NamespaceSpecification("http://www.oxygenxml2.com" + string, string);
        namespaceSpecification2 = new NamespaceSpecification("http://www.oxygenxml.com", string2);
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.compete(namespaceSpecification2));
        namespaceSpecification = new NamespaceSpecification("http://www." + string + ".com", string);
        namespaceSpecification2 = new NamespaceSpecification("http://www.oxygenxml." + string2, string2);
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.compete(namespaceSpecification2));
        namespaceSpecification = new NamespaceSpecification("http" + string + "://www." + string + ".com", string);
        namespaceSpecification2 = new NamespaceSpecification("http://www.oxyg" + string2 + "enxml." + string2, string2);
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.compete(namespaceSpecification2));
        namespaceSpecification = new NamespaceSpecification("http://www." + string + ".com", string);
        namespaceSpecification2 = new NamespaceSpecification("##any", NamespaceSpecification.DEFAULT_WILDCARD);
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.compete(namespaceSpecification2));
        namespaceSpecification = new NamespaceSpecification("##any", NamespaceSpecification.DEFAULT_WILDCARD);
        namespaceSpecification2 = new NamespaceSpecification("##any", NamespaceSpecification.DEFAULT_WILDCARD);
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.compete(namespaceSpecification2));
        namespaceSpecification = new NamespaceSpecification("http://www.oxygenxml.com/test", "");
        namespaceSpecification2 = new NamespaceSpecification("http://www.oxyg" + string2 + "enxml." + string2, string2);
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.compete(namespaceSpecification2));
        namespaceSpecification = new NamespaceSpecification("http://www.oxygenxml.com/test", "");
        namespaceSpecification2 = new NamespaceSpecification("http://www.oxygenxml.com/test", "");
        NamespaceSpecificationTest.assertTrue((boolean)namespaceSpecification.compete(namespaceSpecification2));
        namespaceSpecification = new NamespaceSpecification("http://www.oxygenxml.com/test", "");
        namespaceSpecification2 = new NamespaceSpecification("http://www.oxygenxml.com/test/x", "");
        NamespaceSpecificationTest.assertFalse((boolean)namespaceSpecification.compete(namespaceSpecification2));
    }
}

