/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.fonts.FontRuntimeException;

public class RasterFont
extends AFPFont {
    protected static final Log LOG = LogFactory.getLog((String)"org.apache.fop.afp.fonts");
    private final SortedMap<Integer, CharacterSet> charSets = new TreeMap<Integer, CharacterSet>();
    private Map<Integer, CharacterSet> substitutionCharSets;
    private CharacterSet charSet;

    public RasterFont(String name, boolean embeddable) {
        super(name, embeddable);
    }

    public void addCharacterSet(int size, CharacterSet characterSet) {
        this.charSets.put(new Integer(size), characterSet);
        this.charSet = characterSet;
    }

    public CharacterSet getCharacterSet(int sizeInMpt) {
        Integer requestedSize = sizeInMpt;
        CharacterSet csm = (CharacterSet)this.charSets.get(requestedSize);
        double sizeInPt = (double)sizeInMpt / 1000.0;
        if (csm != null) {
            return csm;
        }
        if (this.substitutionCharSets != null) {
            csm = this.substitutionCharSets.get(requestedSize);
        }
        if (csm == null && !this.charSets.isEmpty()) {
            SortedMap<Integer, CharacterSet> smallerSizes = this.charSets.headMap(requestedSize);
            SortedMap<Integer, CharacterSet> largerSizes = this.charSets.tailMap(requestedSize);
            int smallerSize = smallerSizes.isEmpty() ? 0 : smallerSizes.lastKey();
            int largerSize = largerSizes.isEmpty() ? Integer.MAX_VALUE : largerSizes.firstKey();
            Integer fontSize = !smallerSizes.isEmpty() && sizeInMpt - smallerSize <= largerSize - sizeInMpt ? Integer.valueOf(smallerSize) : Integer.valueOf(largerSize);
            csm = (CharacterSet)this.charSets.get(fontSize);
            if (csm != null) {
                if (this.substitutionCharSets == null) {
                    this.substitutionCharSets = new HashMap<Integer, CharacterSet>();
                }
                this.substitutionCharSets.put(requestedSize, csm);
                if (!(Math.abs((double)fontSize.intValue() / 1000.0 - sizeInPt) < 0.1)) {
                    String msg = "No " + sizeInPt + "pt font " + this.getFontName() + " found, substituted with " + (float)fontSize.intValue() / 1000.0f + "pt font";
                    LOG.warn((Object)msg);
                }
            }
        }
        if (csm == null) {
            String msg = "No font found for font " + this.getFontName() + " with point size " + sizeInPt;
            LOG.error((Object)msg);
            throw new FontRuntimeException(msg);
        }
        return csm;
    }

    private int metricsToAbsoluteSize(CharacterSet cs, int value, int givenSize) {
        int nominalVerticalSize = cs.getNominalVerticalSize();
        if (nominalVerticalSize != 0) {
            return value * nominalVerticalSize;
        }
        return value * givenSize;
    }

    private int metricsToAbsoluteSize(CharacterSet cs, double value, int givenSize) {
        int nominalVerticalSize = cs.getNominalVerticalSize();
        if (nominalVerticalSize != 0) {
            return (int)(value * (double)nominalVerticalSize);
        }
        return (int)(value * (double)givenSize);
    }

    public int getAscender(int size) {
        CharacterSet cs = this.getCharacterSet(size);
        return this.metricsToAbsoluteSize(cs, cs.getAscender(), size);
    }

    public int getUnderlinePosition(int size) {
        CharacterSet cs = this.getCharacterSet(size);
        return this.metricsToAbsoluteSize(cs, cs.getUnderscorePosition(), size);
    }

    public int getUnderlineThickness(int size) {
        CharacterSet cs = this.getCharacterSet(size);
        int underscoreWidth = cs.getUnderscoreWidth();
        return underscoreWidth == 0 ? super.getUnderlineThickness(size) : this.metricsToAbsoluteSize(cs, underscoreWidth, size);
    }

    public int getCapHeight(int size) {
        CharacterSet cs = this.getCharacterSet(size);
        return this.metricsToAbsoluteSize(cs, cs.getCapHeight(), size);
    }

    public int getDescender(int size) {
        CharacterSet cs = this.getCharacterSet(size);
        return this.metricsToAbsoluteSize(cs, cs.getDescender(), size);
    }

    public int getXHeight(int size) {
        CharacterSet cs = this.getCharacterSet(size);
        return this.metricsToAbsoluteSize(cs, cs.getXHeight(), size);
    }

    public int getWidth(int character, int size) {
        CharacterSet cs = this.getCharacterSet(size);
        return this.metricsToAbsoluteSize(cs, cs.getWidth(RasterFont.toUnicodeCodepoint(character), 1), size);
    }

    public Rectangle getBoundingBox(int character, int size) {
        CharacterSet cs = this.getCharacterSet(size);
        Rectangle characterBox = cs.getCharacterBox(RasterFont.toUnicodeCodepoint(character), 1);
        int x = this.metricsToAbsoluteSize(cs, characterBox.getX(), size);
        int y = this.metricsToAbsoluteSize(cs, characterBox.getY(), size);
        int w = this.metricsToAbsoluteSize(cs, characterBox.getWidth(), size);
        int h = this.metricsToAbsoluteSize(cs, characterBox.getHeight(), size);
        return new Rectangle(x, y, w, h);
    }

    public boolean hasChar(char c) {
        return this.charSet.hasChar(c);
    }

    public char mapChar(char c) {
        return this.charSet.mapChar(c);
    }

    public String getEncodingName() {
        return this.charSet.getEncoding();
    }
}

