/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections.attrs;

import com.phloc.commons.collections.attrs.IReadonlyAttributeContainer;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.string.StringParser;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class AbstractReadonlyAttributeContainer
implements IReadonlyAttributeContainer {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractReadonlyAttributeContainer.class);

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getCastedAttribute(@Nullable String sName) {
        return (DATATYPE)GenericReflection.uncheckedCast(this.getAttributeObject(sName));
    }

    @Override
    @Nullable
    public final <DATATYPE> DATATYPE getCastedAttribute(@Nullable String sName, @Nullable DATATYPE aDefault) {
        DATATYPE aValue = this.getCastedAttribute(sName);
        return aValue == null ? aDefault : aValue;
    }

    @Override
    @Nullable
    public final String getAttributeAsString(@Nullable String sName) {
        return this.getAttributeAsString(sName, null);
    }

    @Nullable
    public static final String getAsString(@Nullable String sParamName, @Nullable Object aValue, @Nullable String sDefault) {
        if (aValue == null) {
            return sDefault;
        }
        if (aValue instanceof String) {
            return (String)aValue;
        }
        if (aValue instanceof String[]) {
            Object[] aArray = (String[])aValue;
            s_aLogger.warn("The parameter '" + sParamName + "' is an array with " + aArray.length + " items; using the first one if possible: " + Arrays.toString(aArray));
            return aArray.length > 0 ? aArray[0] : sDefault;
        }
        return aValue.toString();
    }

    @Override
    @Nullable
    public final String getAttributeAsString(@Nullable String sName, @Nullable String sDefault) {
        Object aValue = this.getAttributeObject(sName);
        return AbstractReadonlyAttributeContainer.getAsString(sName, aValue, sDefault);
    }

    @Override
    public final int getAttributeAsInt(@Nullable String sName) {
        return this.getAttributeAsInt(sName, -1);
    }

    @Override
    public final int getAttributeAsInt(@Nullable String sName, int nDefault) {
        String sValue = this.getAttributeAsString(sName);
        return StringParser.parseInt(sValue, nDefault);
    }

    @Override
    public final double getAttributeAsDouble(@Nullable String sName) {
        return this.getAttributeAsDouble(sName, -1.0);
    }

    @Override
    public final double getAttributeAsDouble(@Nullable String sName, double dDefault) {
        String sValue = this.getAttributeAsString(sName);
        return StringParser.parseDouble(sValue, dDefault);
    }

    @Override
    public final boolean getAttributeAsBoolean(@Nullable String sName) {
        return this.getAttributeAsBoolean(sName, false);
    }

    @Override
    public final boolean getAttributeAsBoolean(@Nullable String sName, boolean bDefault) {
        String sValue = this.getAttributeAsString(sName);
        return StringParser.parseBool(sValue, bDefault);
    }
}

