/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file.filter;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.file.filter.AbstractFileFilter;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FileFilterParentDirectoryPublic
extends AbstractFileFilter {
    private static final FileFilterParentDirectoryPublic s_aInstance = new FileFilterParentDirectoryPublic();

    private FileFilterParentDirectoryPublic() {
    }

    @Override
    public boolean accept(@Nullable File aFile) {
        File aParentFile = aFile != null ? aFile.getAbsoluteFile().getParentFile() : null;
        return aParentFile != null && !StringHelper.startsWith((CharSequence)aParentFile.getName(), '.');
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof FileFilterParentDirectoryPublic;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).toString();
    }

    @Nonnull
    public static FileFilterParentDirectoryPublic getInstance() {
        return s_aInstance;
    }
}

