/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.lang;

import com.phloc.commons.string.StringHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class StackTraceHelper {
    private static final char STACKELEMENT_LINESEP = '\n';
    private static final List<String> STACKTRACE_OMIT_UNITTEST = new ArrayList<String>();
    private static final List<String> STACKTRACE_OMIT_APPSRV = new ArrayList<String>();
    private static final StackTraceHelper s_aInstance;

    private StackTraceHelper() {
    }

    private static boolean _stopStackTraceListing(@Nonnull String sStackTraceLine) {
        for (String sOmit : STACKTRACE_OMIT_UNITTEST) {
            if (!sStackTraceLine.startsWith(sOmit)) continue;
            return true;
        }
        for (String sOmit : STACKTRACE_OMIT_APPSRV) {
            if (!sStackTraceLine.startsWith(sOmit)) continue;
            return true;
        }
        return false;
    }

    private static boolean _matchesParentStackTrace(@Nonnull StackTraceElement aElement, @Nullable StackTraceElement[] aParentElements) {
        if (aParentElements != null) {
            for (StackTraceElement aParentElement : aParentElements) {
                if (!aParentElement.equals(aElement)) continue;
                return true;
            }
        }
        return false;
    }

    private static void _appendSingleStackTraceToString(@Nonnull StringBuilder aSB, @Nonnull StackTraceElement[] aStackTraceElements, @Nullable StackTraceElement[] aParentStackTraceElements, boolean bOmitCommonStackTraceElements) {
        for (int i = 0; i < aStackTraceElements.length; ++i) {
            StackTraceElement aStackTraceElement = aStackTraceElements[i];
            String sStackTraceElement = aStackTraceElement.toString();
            if (bOmitCommonStackTraceElements && StackTraceHelper._stopStackTraceListing(sStackTraceElement) || StackTraceHelper._matchesParentStackTrace(aStackTraceElement, aParentStackTraceElements)) {
                aSB.append("  [").append(aStackTraceElements.length - i).append(" elements omitted -- ").append(sStackTraceElement).append(']').append('\n');
                break;
            }
            aSB.append(i + 1).append(".: ").append(sStackTraceElement).append('\n');
        }
    }

    public static void appendStackToString(@Nonnull StringBuilder aSB, @Nonnull StackTraceElement[] aStackTraceElements) {
        StackTraceHelper._appendSingleStackTraceToString(aSB, aStackTraceElements, null, true);
    }

    @Nonnull
    public static String getStackAsString(@Nonnull StackTraceElement[] aStackTraceElements, boolean bOmitCommonStackTraceElements) {
        StringBuilder aSB = new StringBuilder();
        StackTraceHelper._appendSingleStackTraceToString(aSB, aStackTraceElements, null, bOmitCommonStackTraceElements);
        return aSB.toString();
    }

    @Nonnull
    public static String getStackAsString(@Nonnull StackTraceElement[] aStackTraceElements) {
        return StackTraceHelper.getStackAsString(aStackTraceElements, true);
    }

    @Nonnull
    public static String getStackAsString(@Nonnull Thread aThread) {
        return StackTraceHelper.getStackAsString(aThread.getStackTrace(), true);
    }

    @Nonnull
    public static String getStackAsString(@Nonnull Thread aThread, boolean bOmitCommonStackTraceElements) {
        return StackTraceHelper.getStackAsString(aThread.getStackTrace(), bOmitCommonStackTraceElements);
    }

    @Nonnull
    public static String getCurrentThreadStackAsString() {
        return StackTraceHelper.getStackAsString(Thread.currentThread().getStackTrace(), true);
    }

    private static StringBuilder _getRecursiveStackAsStringBuilder(@Nonnull Throwable aThrowable, @Nullable Throwable aParentThrowable, @Nullable StringBuilder aInitialSB, @Nonnegative int nLevel, boolean bOmitCommonStackTraceElements) {
        StringBuilder aSB = aInitialSB == null ? new StringBuilder() : aInitialSB;
        aSB.append(aThrowable.toString()).append('\n');
        StackTraceHelper._appendSingleStackTraceToString(aSB, aThrowable.getStackTrace(), aParentThrowable == null ? null : aParentThrowable.getStackTrace(), bOmitCommonStackTraceElements);
        if (aThrowable.getCause() != null) {
            aSB.append("==> [").append(nLevel).append("] caused by ");
            StackTraceHelper._getRecursiveStackAsStringBuilder(aThrowable.getCause(), aThrowable, aSB, nLevel + 1, bOmitCommonStackTraceElements);
        }
        return aSB;
    }

    @Nonnull
    public static String getStackAsString(@Nullable Throwable t) {
        return StackTraceHelper.getStackAsString(t, true);
    }

    @Nonnull
    public static String getStackAsString(@Nullable Throwable t, boolean bOmitCommonStackTraceElements) {
        if (t == null) {
            return "";
        }
        StringBuilder aCallStack = StackTraceHelper._getRecursiveStackAsStringBuilder(t, null, null, 1, bOmitCommonStackTraceElements);
        if (StringHelper.getLastChar(aCallStack) == '\n') {
            aCallStack.deleteCharAt(aCallStack.length() - 1);
        }
        return aCallStack.toString();
    }

    public static boolean containsUnitTestElement(@Nullable Throwable t) {
        return t == null ? false : StackTraceHelper.containsUnitTestElement(t.getStackTrace());
    }

    public static boolean containsUnitTestElement(@Nullable StackTraceElement[] aStackTrace) {
        if (aStackTrace != null) {
            for (StackTraceElement aStackTraceElement : aStackTrace) {
                String sStackTraceLine = aStackTraceElement.toString();
                for (String sUnitTestPackage : STACKTRACE_OMIT_UNITTEST) {
                    if (!sStackTraceLine.startsWith(sUnitTestPackage)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    static {
        STACKTRACE_OMIT_UNITTEST.add("org.testng");
        STACKTRACE_OMIT_UNITTEST.add("org.junit.");
        STACKTRACE_OMIT_UNITTEST.add("junit.framework.");
        STACKTRACE_OMIT_APPSRV.add("org.apache.catalina.core");
        STACKTRACE_OMIT_APPSRV.add("org.mortbay.jetty.");
        STACKTRACE_OMIT_APPSRV.add("org.eclipse.jetty.");
        s_aInstance = new StackTraceHelper();
    }
}

