/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.resource;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.text.resource.ResourceBundleUtils;
import java.io.Serializable;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.PropertyKey;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ResourceBundleKey
implements Serializable {
    private final String m_sBundleName;
    private final String m_sKey;

    public ResourceBundleKey(@Nonnull @Nonempty String sBundleName, @Nonnull @PropertyKey @Nonempty String sKey) {
        if (StringHelper.hasNoText(sBundleName)) {
            throw new IllegalArgumentException("bundleName");
        }
        if (StringHelper.hasNoText(sKey)) {
            throw new IllegalArgumentException("key");
        }
        this.m_sBundleName = sBundleName;
        this.m_sKey = sKey;
    }

    @Nonnull
    @Nonempty
    public String getBundleName() {
        return this.m_sBundleName;
    }

    @Nonnull
    @PropertyKey
    @Nonempty
    public String getKey() {
        return this.m_sKey;
    }

    @Nullable
    public String getString(@Nonnull Locale aContentLocale) {
        return ResourceBundleUtils.getString(this.m_sBundleName, aContentLocale, this.m_sKey);
    }

    @Nullable
    public String getString(@Nonnull Locale aContentLocale, @Nonnull ClassLoader aClassLoader) {
        return ResourceBundleUtils.getString(this.m_sBundleName, aContentLocale, this.m_sKey, aClassLoader);
    }

    @Nullable
    public String getUtf8String(@Nonnull Locale aContentLocale) {
        return ResourceBundleUtils.getUtf8String(this.m_sBundleName, aContentLocale, this.m_sKey);
    }

    @Nullable
    public String getUtf8String(@Nonnull Locale aContentLocale, @Nonnull ClassLoader aClassLoader) {
        return ResourceBundleUtils.getUtf8String(this.m_sBundleName, aContentLocale, this.m_sKey, aClassLoader);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceBundleKey)) {
            return false;
        }
        ResourceBundleKey rhs = (ResourceBundleKey)o;
        return this.m_sBundleName.equals(rhs.m_sBundleName) && this.m_sKey.equals(rhs.m_sKey);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sBundleName).append(this.m_sKey).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("bundleName", this.m_sBundleName).append("key", this.m_sKey).toString();
    }
}

