/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.url;

import com.phloc.commons.ICloneable;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.url.AbstractSimpleURL;
import com.phloc.commons.url.IURLData;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class SimpleURL
extends AbstractSimpleURL
implements ICloneable<SimpleURL> {
    public SimpleURL() {
    }

    public SimpleURL(@Nonnull String sHref) {
        super(sHref);
    }

    public SimpleURL(@Nonnull String sHref, @Nullable Map<String, String> aParams) {
        super(sHref, aParams);
    }

    public SimpleURL(@Nonnull String sHref, @Nullable Map<String, String> aParams, @Nullable String sAnchor) {
        super(sHref, aParams, sAnchor);
    }

    public SimpleURL(@Nonnull IURLData aURL) {
        super(aURL);
    }

    @Nonnull
    public SimpleURL add(@Nonnull String sKey, @Nonnull String sValue) {
        if (StringHelper.hasNoText(sKey)) {
            throw new IllegalArgumentException("key may not be empty!");
        }
        if (sValue == null) {
            throw new NullPointerException("value");
        }
        if (this.m_aParams == null) {
            this.m_aParams = new LinkedHashMap();
        }
        this.m_aParams.put(sKey, sValue);
        return this;
    }

    @Nonnull
    public SimpleURL add(@Nonnull String sKey, int nValue) {
        return this.add(sKey, Integer.toString(nValue));
    }

    @Nonnull
    public SimpleURL addIfNonNull(@Nonnull String sKey, @Nullable String sValue) {
        if (sValue != null) {
            this.add(sKey, sValue);
        }
        return this;
    }

    @Nonnull
    public SimpleURL addAll(@Nullable Map<String, String> aParams) {
        if (!ContainerHelper.isEmpty(aParams)) {
            if (this.m_aParams == null) {
                this.m_aParams = new LinkedHashMap();
            }
            this.m_aParams.putAll(aParams);
        }
        return this;
    }

    @Nonnull
    public SimpleURL remove(@Nullable String sKey) {
        if (this.m_aParams != null) {
            this.m_aParams.remove(sKey);
        }
        return this;
    }

    @Nonnull
    public SimpleURL setAnchor(@Nullable String sAnchor) {
        this.m_sAnchor = sAnchor;
        return this;
    }

    @Override
    @Nonnull
    public SimpleURL getClone() {
        return new SimpleURL(this);
    }
}

