/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.serialize;

import com.phloc.commons.io.streams.StreamUtils;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.xml.EXMLVersion;
import com.phloc.commons.xml.IXMLIterationHandler;
import com.phloc.commons.xml.XMLHelper;
import com.phloc.commons.xml.serialize.AbstractSerializerPhloc;
import com.phloc.commons.xml.serialize.IXMLWriterSettings;
import com.phloc.commons.xml.serialize.XMLEmitterPhloc;
import com.phloc.commons.xml.serialize.XMLWriterSettings;
import java.io.Writer;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class XMLSerializerPhloc
extends AbstractSerializerPhloc<Node> {
    public XMLSerializerPhloc() {
        this(XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    public XMLSerializerPhloc(@Nonnull IXMLWriterSettings aSettings) {
        super(aSettings);
    }

    private void _writeNode(@Nonnull IXMLIterationHandler aEmitter, @Nonnull Node aNode) {
        short nNodeType = aNode.getNodeType();
        if (nNodeType == 1) {
            this._writeElement(aEmitter, (Element)aNode);
        } else if (nNodeType == 3) {
            XMLSerializerPhloc._writeText(aEmitter, (Text)aNode);
        } else if (nNodeType == 4) {
            XMLSerializerPhloc._writeCDATA(aEmitter, (CDATASection)aNode);
        } else if (nNodeType == 8) {
            this._writeComment(aEmitter, (Comment)aNode);
        } else if (nNodeType == 5) {
            XMLSerializerPhloc._writeEntityReference(aEmitter, (EntityReference)aNode);
        } else if (nNodeType == 9) {
            this._writeDocument(aEmitter, (Document)aNode);
        } else if (nNodeType == 10) {
            this._writeDocumentType(aEmitter, (DocumentType)aNode);
        } else if (nNodeType == 7) {
            XMLSerializerPhloc._writeProcessingInstruction(aEmitter, (ProcessingInstruction)aNode);
        } else {
            throw new IllegalArgumentException("Passed node type " + nNodeType + " is not yet supported");
        }
    }

    private void _writeDocument(@Nonnull IXMLIterationHandler aEmitter, @Nonnull Document aDocument) {
        if (this.m_aSettings.getFormat().hasXMLHeader()) {
            String sXMLVersion = null;
            boolean bIsDocumentStandalone = false;
            try {
                sXMLVersion = aDocument.getXmlVersion();
                bIsDocumentStandalone = aDocument.getXmlStandalone();
            }
            catch (Throwable t) {
                // empty catch block
            }
            EXMLVersion eXMLVersion = EXMLVersion.getFromVersionOrDefault(sXMLVersion, this.m_aSettings.getXMLVersion());
            aEmitter.onDocumentStart(eXMLVersion, this.m_aSettings.getCharset(), bIsDocumentStandalone || aDocument.getDoctype() == null);
        }
        NodeList aNL = aDocument.getChildNodes();
        for (int i = 0; i < aNL.getLength(); ++i) {
            this._writeNode(aEmitter, aNL.item(i));
        }
    }

    private void _writeDocumentType(@Nonnull IXMLIterationHandler aEmitter, @Nonnull DocumentType aDocType) {
        if (this.m_aSettings.getSerializeDocType().emit()) {
            aEmitter.onDocumentType(aDocType.getName(), aDocType.getPublicId(), aDocType.getSystemId());
        }
    }

    private static void _writeProcessingInstruction(@Nonnull IXMLIterationHandler aEmitter, @Nonnull ProcessingInstruction aPI) {
        aEmitter.onProcessingInstruction(aPI.getTarget(), aPI.getData());
    }

    private static void _writeEntityReference(@Nonnull IXMLIterationHandler aEmitter, @Nonnull EntityReference aEntRef) {
        aEmitter.onEntityReference(aEntRef.getNodeName());
    }

    private void _writeComment(@Nonnull IXMLIterationHandler aEmitter, @Nonnull Comment aComment) {
        if (this.m_aSettings.getSerializeComments().emit()) {
            aEmitter.onComment(aComment.getData());
        }
    }

    private static void _writeText(@Nonnull IXMLIterationHandler aEmitter, @Nonnull Text aText) {
        aEmitter.onText(aText.getData(), true);
    }

    private static void _writeCDATA(@Nonnull IXMLIterationHandler aEmitter, @Nonnull Text aText) {
        aEmitter.onCDATA(aText.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _writeElement(@Nonnull IXMLIterationHandler aEmitter, @Nonnull Element aElement) {
        String sTagName = aElement.getLocalName() != null ? aElement.getLocalName() : aElement.getTagName();
        Document doc = aElement.getOwnerDocument();
        NodeList aChildNodeList = aElement.getChildNodes();
        boolean bHasChildren = aChildNodeList.getLength() > 0;
        boolean bIsRootElement = doc != null && aElement.equals(doc.getDocumentElement());
        boolean bIndentPrev = aElement.getPreviousSibling() == null || !XMLHelper.isTextNode(aElement.getPreviousSibling()) || bIsRootElement;
        boolean bIndentNext = aElement.getNextSibling() == null || !XMLHelper.isTextNode(aElement.getNextSibling());
        boolean bHasChildElement = bHasChildren && !XMLHelper.isTextNode(aElement.getFirstChild());
        TreeMap<String, String> aAttrMap = new TreeMap<String, String>();
        NamedNodeMap aAttrs = aElement.getAttributes();
        for (int i = 0; i < aAttrs.getLength(); ++i) {
            Attr aAttr = (Attr)aAttrs.item(i);
            aAttrMap.put(aAttr.getName(), aAttr.getValue());
        }
        this.m_aNSStack.push(aAttrMap);
        try {
            String sElementNamespaceURI = aElement.getNamespaceURI();
            String sNSPrefix = this.m_aNSStack.findPrefix(sElementNamespaceURI);
            String sDefaultNS = this.m_aNSStack.getDefaultNamespace();
            if (StringHelper.hasText(sElementNamespaceURI) && sNSPrefix == null && !sElementNamespaceURI.equals(sDefaultNS)) {
                sNSPrefix = this.m_aNSStack.createUniquePrefix(sElementNamespaceURI);
                if (StringHelper.hasNoText(sNSPrefix)) {
                    aAttrMap.put("xmlns", sElementNamespaceURI);
                } else {
                    aAttrMap.put("xmlns:" + sNSPrefix, sElementNamespaceURI);
                }
                this.m_aNSStack.addNamespaceMapping(sNSPrefix, sElementNamespaceURI);
            }
            if (bIsRootElement && sDefaultNS != null) {
                aAttrMap.put("xmlns", sDefaultNS);
                this.m_aNSStack.addNamespaceMapping(null, sDefaultNS);
            }
            if (this.m_aSettings.getIndent().isIndent() && bIndentPrev && this.m_aIndent.length() > 0) {
                aEmitter.onContentElementWhitespace(this.m_aIndent);
            }
            aEmitter.onElementStart(sNSPrefix, sTagName, aAttrMap, bHasChildren);
            if (bHasChildren) {
                if (this.m_aSettings.getIndent().isAlign() && bHasChildElement) {
                    aEmitter.onContentElementWhitespace(NEWLINE);
                }
                this.m_aIndent.append("  ");
                for (int i = 0; i < aChildNodeList.getLength(); ++i) {
                    this._writeNode(aEmitter, aChildNodeList.item(i));
                }
                this.m_aIndent.delete(this.m_aIndent.length() - "  ".length(), this.m_aIndent.length());
                if (this.m_aSettings.getIndent().isIndent() && bHasChildElement && this.m_aIndent.length() > 0) {
                    aEmitter.onContentElementWhitespace(this.m_aIndent);
                }
                aEmitter.onElementEnd(sNSPrefix, sTagName);
            }
            if (this.m_aSettings.getIndent().isAlign() && bIndentNext) {
                aEmitter.onContentElementWhitespace(NEWLINE);
            }
        }
        finally {
            this.m_aNSStack.pop();
        }
    }

    @Override
    public void write(@Nonnull Node aNode, @Nonnull @WillNotClose Writer aWriter) {
        XMLEmitterPhloc aXMLWriter = new XMLEmitterPhloc(aWriter, this.m_aSettings);
        this._writeNode(aXMLWriter, aNode);
        StreamUtils.flush(aWriter);
    }

    public void write(@Nonnull Node aNode, @Nonnull IXMLIterationHandler aXMLEmitter) {
        this._writeNode(aXMLEmitter, aNode);
    }
}

