/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.media;

import com.phloc.commons.IHasSize;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.css.media.ECSSMedium;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSMediaList
implements Serializable,
IHasSize {
    private final Set<ECSSMedium> m_aMedia = new LinkedHashSet<ECSSMedium>();

    public CSSMediaList() {
    }

    public CSSMediaList(@Nonnull ECSSMedium eMedium) {
        this.addMedium(eMedium);
    }

    public CSSMediaList(ECSSMedium ... aMedia) {
        if (aMedia != null) {
            for (ECSSMedium eMedium : aMedia) {
                this.addMedium(eMedium);
            }
        }
    }

    public CSSMediaList(@Nullable Iterable<ECSSMedium> aMedia) {
        if (aMedia != null) {
            for (ECSSMedium eMedium : aMedia) {
                this.addMedium(eMedium);
            }
        }
    }

    @Nonnull
    public CSSMediaList addMedium(@Nonnull ECSSMedium eMedium) {
        if (eMedium == null) {
            throw new NullPointerException("medium");
        }
        this.m_aMedia.add(eMedium);
        return this;
    }

    @Nonnull
    public EChange removeMedium(@Nullable ECSSMedium eMedium) {
        return EChange.valueOf((boolean)this.m_aMedia.remove(eMedium));
    }

    @Deprecated
    public boolean hasMedia() {
        return this.hasAnyMedia();
    }

    public boolean hasAnyMedia() {
        return !this.m_aMedia.isEmpty();
    }

    public boolean containsMedium(@Nullable ECSSMedium eMedium) {
        return this.m_aMedia.contains(eMedium);
    }

    public boolean containsMediumOrAll(@Nullable ECSSMedium eMedium) {
        return this.containsMedium(eMedium) || this.containsMedium(ECSSMedium.ALL);
    }

    public boolean isForScreen() {
        return this.m_aMedia.isEmpty() || this.containsMediumOrAll(ECSSMedium.SCREEN);
    }

    @Deprecated
    @Nonnull
    @ReturnsMutableCopy
    public Set<ECSSMedium> getMedia() {
        return this.getAllMedia();
    }

    @Nonnull
    @ReturnsMutableCopy
    public Set<ECSSMedium> getAllMedia() {
        return ContainerHelper.newSet(this.m_aMedia);
    }

    @Nonnull
    public String getMediaString() {
        return this.getMediaString(", ");
    }

    @Nonnull
    public String getMediaString(@Nonnull String sSeparator) {
        if (sSeparator == null) {
            throw new NullPointerException("separator");
        }
        if (this.m_aMedia.isEmpty()) {
            return "";
        }
        StringBuilder aSB = new StringBuilder();
        for (ECSSMedium eMedia : this.m_aMedia) {
            if (aSB.length() > 0) {
                aSB.append(sSeparator);
            }
            aSB.append(eMedia.getName());
        }
        return aSB.toString();
    }

    @Nonnegative
    public int size() {
        return this.m_aMedia.size();
    }

    public boolean isEmpty() {
        return this.m_aMedia.isEmpty();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CSSMediaList)) {
            return false;
        }
        CSSMediaList rhs = (CSSMediaList)o;
        return ((Object)this.m_aMedia).equals(rhs.m_aMedia);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMedia).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("media", this.m_aMedia).toString();
    }
}

