/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.validate.nvdl;

import com.oxygenxml.validate.nvdl.ActionSet;
import com.oxygenxml.validate.nvdl.AttributeActionSet;
import com.oxygenxml.validate.nvdl.FilteredAttributes;
import com.oxygenxml.validate.nvdl.Hashset;
import com.oxygenxml.validate.nvdl.IntSet;
import com.oxygenxml.validate.nvdl.Mode;
import com.oxygenxml.validate.nvdl.ModeUsage;
import com.oxygenxml.validate.nvdl.NoResultAction;
import com.oxygenxml.validate.nvdl.ResultAction;
import com.oxygenxml.validate.nvdl.SectionState;
import com.oxygenxml.validate.nvdl.Triggers;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

class ValidatorImpl
extends DefaultHandler
implements Validator {
    protected static Logger logger = Logger.getLogger((Class)ValidatorImpl.class);
    private static final String VIRTUAL_ELEMENT_URI = "http://purl.oclc.org/dsdl/nvdl/ns/instance/1.0";
    private static final String VIRTUAL_ELEMENT_LOCAL_NAME = "virtualElement";
    private static final String NO_NS = "\u0000";
    private final ErrorHandler eh;
    private final PropertyMap properties;
    private final Triggers triggers;
    private Locator locator;
    private Section currentSection;
    private PrefixMapping prefixMapping = null;
    private final Hashtable validatorHandlerCache = new Hashtable();
    private final Localizer localizer = new Localizer(ValidatorImpl.class);
    private final Hashset noResultActions = new Hashset();
    private final Hashtable attributeNamespaceIndexSets = new Hashtable();
    private final Vector activeHandlersAttributeIndexSets = new Vector();
    private final Hashset attributeSchemas = new Hashset();
    private boolean attributeNamespaceRejected;
    private Attributes filteredAttributes;
    private final Mode startMode;
    private final Stack elementsLocalNameStack;

    ValidatorImpl(Mode mode, Triggers triggers, PropertyMap propertyMap) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Creating NVDL validator...");
        }
        this.properties = propertyMap;
        this.triggers = triggers;
        this.eh = ValidateProperty.ERROR_HANDLER.get(propertyMap);
        this.startMode = mode;
        this.elementsLocalNameStack = new Stack();
        this.initCurrentSection();
    }

    private void initCurrentSection() {
        this.currentSection = new Section(NO_NS, null);
        this.currentSection.addChildMode(new ModeUsage(this.startMode, this.startMode), null);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        int n3 = this.currentSection.activeHandlers.size();
        for (int i = 0; i < n3; ++i) {
            ((ContentHandler)this.currentSection.activeHandlers.elementAt(i)).characters(cArray, n, n2);
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        int n3 = this.currentSection.activeHandlers.size();
        for (int i = 0; i < n3; ++i) {
            ((ContentHandler)this.currentSection.activeHandlers.elementAt(i)).ignorableWhitespace(cArray, n, n2);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Start element: " + string3));
        }
        if (!string.equals(this.currentSection.ns)) {
            this.startSection(string);
        } else if (this.triggers.trigger(string, string2, String.valueOf(this.elementsLocalNameStack.peek()))) {
            this.startSection(string);
        }
        this.elementsLocalNameStack.push(string2);
        ++this.currentSection.depth;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Section depth: " + this.currentSection.depth));
        }
        if (this.currentSection.contextDependent) {
            this.currentSection.context.push(string2);
        }
        boolean bl = this.processAttributes(attributes);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("transformAttributes: " + bl));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Notify section active handlers: " + this.currentSection.activeHandlers.size()));
        }
        int n = this.currentSection.activeHandlers.size();
        for (int i = 0; i < n; ++i) {
            ContentHandler contentHandler = (ContentHandler)this.currentSection.activeHandlers.elementAt(i);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Call start element on handler: " + contentHandler));
            }
            contentHandler.startElement(string, string2, string3, bl ? ValidatorImpl.filterAttributes((IntSet)this.activeHandlersAttributeIndexSets.elementAt(i), attributes) : attributes);
        }
        if (this.currentSection.depth == 1 && this.currentSection.placeholderHandlers.size() > 0) {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "ns", "ns", "", string);
            attributesImpl.addAttribute("", "localName", "localName", "", string2);
            int n2 = this.currentSection.placeholderHandlers.size();
            for (n = 0; n < n2; ++n) {
                ContentHandler contentHandler = (ContentHandler)this.currentSection.placeholderHandlers.elementAt(n);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Call start placeholder element on handler: " + contentHandler));
                }
                contentHandler.startPrefixMapping("", VIRTUAL_ELEMENT_URI);
                contentHandler.startElement(VIRTUAL_ELEMENT_URI, "placeholder", "placeholder", attributesImpl);
            }
        }
    }

    private static Attributes filterAttributes(IntSet intSet, Attributes attributes) {
        if (intSet.size() == attributes.getLength()) {
            return attributes;
        }
        return new FilteredAttributes(intSet, attributes);
    }

    private boolean processAttributes(Attributes attributes) throws SAXException {
        Object object;
        if (this.currentSection.attributeProcessing == 0 || attributes.getLength() == 0) {
            return false;
        }
        this.attributeNamespaceIndexSets.clear();
        int n = attributes.getLength();
        for (int i = 0; i < n; i += 1) {
            String string = attributes.getURI(i);
            object = (IntSet)this.attributeNamespaceIndexSets.get(string);
            if (object == null) {
                object = new IntSet();
                this.attributeNamespaceIndexSets.put(string, object);
            }
            ((IntSet)object).add(i);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Added index " + i + " for attribute " + attributes.getQName(i) + " for namespace " + string));
        }
        if (this.currentSection.attributeProcessing == 1 && this.attributeNamespaceIndexSets.size() == 1 && this.attributeNamespaceIndexSets.get("") != null) {
            return false;
        }
        Vector vector = this.currentSection.activeHandlersAttributeModeUsage;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Active handlers attribute mode usage: " + vector));
        }
        this.activeHandlersAttributeIndexSets.setSize(vector.size());
        int n2 = vector.size();
        for (n = 0; n < n2; n += 1) {
            this.activeHandlersAttributeIndexSets.setElementAt(new IntSet(), n);
        }
        n = 0;
        Vector vector2 = this.currentSection.attributeValidationModeUsages;
        object = this.attributeNamespaceIndexSets.keys();
        while (object.hasMoreElements()) {
            ModeUsage modeUsage;
            int n3;
            String string = (String)object.nextElement();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Enumerate attribute namespaces: [" + string + "]"));
            }
            IntSet intSet = (IntSet)this.attributeNamespaceIndexSets.get(string);
            this.attributeSchemas.clear();
            this.filteredAttributes = null;
            this.attributeNamespaceRejected = false;
            int n4 = vector.size();
            for (n3 = 0; n3 < n4; ++n3) {
                modeUsage = (ModeUsage)vector.elementAt(n3);
                AttributeActionSet attributeActionSet = this.processAttributeSection(modeUsage, string, intSet, attributes);
                if (attributeActionSet.getAttach()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Got an attach action for mode usage " + modeUsage));
                    }
                    ((IntSet)this.activeHandlersAttributeIndexSets.get(n3)).addAll(intSet);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("No attach! for ns " + string + " and mode usage " + modeUsage));
                }
                n = 1;
            }
            n4 = vector2.size();
            for (n3 = 0; n3 < n4; ++n3) {
                modeUsage = (ModeUsage)vector2.elementAt(n3);
                this.processAttributeSection(modeUsage, string, intSet, attributes);
            }
        }
        return n != 0;
    }

    private AttributeActionSet processAttributeSection(ModeUsage modeUsage, String string, IntSet intSet, Attributes attributes) throws SAXException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Start processAttributeSection for ns " + string));
        }
        Mode mode = modeUsage.getMode(this.currentSection.context);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Mode is " + mode.getName()));
        }
        AttributeActionSet attributeActionSet = mode.getAttributeActions(string);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Got schemas in actions: " + attributeActionSet.getSchemas().length));
        }
        if (attributeActionSet.getReject() && !this.attributeNamespaceRejected) {
            this.attributeNamespaceRejected = true;
            if (this.eh != null) {
                this.eh.error(new SAXParseException(this.localizer.message("reject_attribute", string), this.locator));
            }
        }
        Schema[] schemaArray = attributeActionSet.getSchemas();
        for (int i = 0; i < schemaArray.length; ++i) {
            if (this.attributeSchemas.contains(schemaArray[i])) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding attribute schema: " + schemaArray[i]));
            }
            this.attributeSchemas.add(schemaArray[i]);
            if (this.filteredAttributes == null) {
                this.filteredAttributes = ValidatorImpl.filterAttributes(intSet, attributes);
            }
            this.validateAttributes(schemaArray[i], this.filteredAttributes);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("End processAttributeSection returning " + attributeActionSet));
        }
        return attributeActionSet;
    }

    private void validateAttributes(Schema schema, Attributes attributes) throws SAXException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Start validateAttributes with schema: " + schema));
        }
        Validator validator = this.createValidator(schema);
        ContentHandler contentHandler = validator.getContentHandler();
        this.initHandler(contentHandler);
        contentHandler.startElement(VIRTUAL_ELEMENT_URI, VIRTUAL_ELEMENT_LOCAL_NAME, VIRTUAL_ELEMENT_LOCAL_NAME, attributes);
        contentHandler.endElement(VIRTUAL_ELEMENT_URI, VIRTUAL_ELEMENT_LOCAL_NAME, VIRTUAL_ELEMENT_LOCAL_NAME);
        this.cleanupHandler(contentHandler);
        this.releaseValidator(schema, validator);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"End validateAttributes");
        }
    }

    private void startSection(String string) throws SAXException {
        Object object;
        int n;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Start a new section for uri: " + string + " after " + this.currentSection.ns));
        }
        Section section = new Section(string, this.currentSection);
        Vector vector = this.currentSection.childPrograms;
        this.noResultActions.clear();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Iterate programs " + vector.size()));
        }
        int n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            ResultAction resultAction;
            object = (Program)vector.elementAt(n);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Program " + ((Program)object).modeUsage.currentMode.getName() + "->" + ((Program)object).modeUsage.getMode(this.currentSection.context).getName() + ":" + ((Program)object).handler));
            }
            ActionSet actionSet = ((Program)object).modeUsage.getMode(this.currentSection.context).getElementActions(string);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Result action: " + actionSet.getResultAction()));
            }
            if ((resultAction = actionSet.getResultAction()) != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Performing ra: " + resultAction));
                }
                resultAction.perform(((Program)object).handler, section);
            }
            NoResultAction[] noResultActionArray = actionSet.getNoResultActions();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No result actions: " + noResultActionArray.length));
            }
            for (int i = 0; i < noResultActionArray.length; ++i) {
                NoResultAction noResultAction = noResultActionArray[i];
                if (this.noResultActions.contains(noResultAction)) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Performing nra: " + noResultActionArray[i]));
                }
                noResultActionArray[i].perform(section);
                this.noResultActions.add(noResultAction);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Section validators: " + section.validators.size()));
        }
        n2 = section.validators.size();
        for (n = 0; n < n2; ++n) {
            object = ((Validator)section.validators.elementAt(n)).getContentHandler();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Init validator handler: " + object));
            }
            this.initHandler((ContentHandler)object);
        }
        this.currentSection = section;
    }

    private void initHandler(ContentHandler contentHandler) throws SAXException {
        if (this.locator != null) {
            contentHandler.setDocumentLocator(this.locator);
        }
        contentHandler.startDocument();
        PrefixMapping prefixMapping = this.prefixMapping;
        while (prefixMapping != null) {
            contentHandler.startPrefixMapping(prefixMapping.prefix, prefixMapping.uri);
            prefixMapping = prefixMapping.parent;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        int n;
        this.elementsLocalNameStack.pop();
        int n2 = this.currentSection.activeHandlers.size();
        for (n = 0; n < n2; ++n) {
            ((ContentHandler)this.currentSection.activeHandlers.elementAt(n)).endElement(string, string2, string3);
        }
        --this.currentSection.depth;
        if (this.currentSection.contextDependent) {
            this.currentSection.context.pop();
        }
        if (this.currentSection.depth == 0) {
            n2 = this.currentSection.placeholderHandlers.size();
            for (n = 0; n < n2; ++n) {
                ContentHandler contentHandler = (ContentHandler)this.currentSection.placeholderHandlers.elementAt(n);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Call end placeholder element on handler: " + contentHandler));
                }
                contentHandler.endPrefixMapping("");
                contentHandler.endElement(VIRTUAL_ELEMENT_URI, "placeholder", "placeholder");
            }
            this.endSection();
        }
    }

    private void endSection() throws SAXException {
        int n = this.currentSection.validators.size();
        for (int i = 0; i < n; ++i) {
            Validator validator = (Validator)this.currentSection.validators.elementAt(i);
            this.cleanupHandler(validator.getContentHandler());
            this.releaseValidator((Schema)this.currentSection.schemas.elementAt(i), validator);
            this.currentSection.validators.setElementAt(null, i);
        }
        this.currentSection = this.currentSection.parent;
    }

    private void cleanupHandler(ContentHandler contentHandler) throws SAXException {
        PrefixMapping prefixMapping = this.prefixMapping;
        while (prefixMapping != null) {
            contentHandler.endPrefixMapping(prefixMapping.prefix);
            prefixMapping = prefixMapping.parent;
        }
        contentHandler.endDocument();
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        super.startPrefixMapping(string, string2);
        this.prefixMapping = new PrefixMapping(string, string2, this.prefixMapping);
    }

    public void endPrefixMapping(String string) throws SAXException {
        super.endPrefixMapping(string);
        this.prefixMapping = this.prefixMapping.parent;
    }

    private Validator createValidator(Schema schema) {
        Stack stack = (Stack)this.validatorHandlerCache.get(schema);
        if (stack == null) {
            stack = new Stack();
            this.validatorHandlerCache.put(schema, stack);
        }
        if (stack.empty()) {
            return schema.createValidator(this.properties);
        }
        return (Validator)stack.pop();
    }

    private void releaseValidator(Schema schema, Validator validator) {
        if (validator == null) {
            return;
        }
        validator.reset();
        ((Stack)this.validatorHandlerCache.get(schema)).push(validator);
    }

    public void reset() {
        while (this.currentSection != null) {
            int n = this.currentSection.validators.size();
            for (int i = 0; i < n; ++i) {
                this.releaseValidator((Schema)this.currentSection.schemas.elementAt(i), (Validator)this.currentSection.validators.elementAt(i));
            }
            this.currentSection = this.currentSection.parent;
        }
        this.initCurrentSection();
    }

    public ContentHandler getContentHandler() {
        return this;
    }

    public DTDHandler getDTDHandler() {
        return this;
    }

    private static class Program {
        final ModeUsage modeUsage;
        final ContentHandler handler;

        Program(ModeUsage modeUsage, ContentHandler contentHandler) {
            this.modeUsage = modeUsage;
            this.handler = contentHandler;
        }
    }

    private class Section
    implements SectionState {
        final Section parent;
        final String ns;
        int depth = 0;
        final Vector validators = new Vector();
        final Vector schemas = new Vector();
        final Vector activeHandlers = new Vector();
        final Vector activeHandlersAttributeModeUsage = new Vector();
        final Vector attributeValidationModeUsages = new Vector();
        final Vector childPrograms = new Vector();
        final Stack context = new Stack();
        boolean contextDependent = false;
        int attributeProcessing = 0;
        final Vector placeholderHandlers = new Vector();
        final Vector placeholderModeUsages = new Vector();

        Section(String string, Section section) {
            this.ns = string;
            this.parent = section;
        }

        public void addChildMode(ModeUsage modeUsage, ContentHandler contentHandler) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add child mode: " + modeUsage.currentMode.getName() + ":" + contentHandler));
            }
            this.childPrograms.addElement(new Program(modeUsage, contentHandler));
            if (modeUsage.isContextDependent()) {
                this.contextDependent = true;
            }
        }

        public void addValidator(Schema schema, ModeUsage modeUsage) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add validator: " + modeUsage.currentMode.getName() + ":" + schema));
            }
            this.schemas.addElement(schema);
            Validator validator = ValidatorImpl.this.createValidator(schema);
            this.validators.addElement(validator);
            ContentHandler contentHandler = validator.getContentHandler();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add active handler: " + modeUsage.currentMode.getName() + ":" + contentHandler));
            }
            this.activeHandlers.addElement(validator.getContentHandler());
            this.activeHandlersAttributeModeUsage.addElement(modeUsage);
            this.attributeProcessing = Math.max(this.attributeProcessing, modeUsage.getAttributeProcessing());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add child mode: " + modeUsage.currentMode.getName() + ":" + contentHandler));
            }
            this.childPrograms.addElement(new Program(modeUsage, validator.getContentHandler()));
            if (modeUsage.isContextDependent()) {
                this.contextDependent = true;
            }
        }

        public void addActiveHandler(ContentHandler contentHandler, ModeUsage modeUsage) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Add active handler: " + modeUsage.currentMode.getName() + ":" + contentHandler));
            }
            this.activeHandlers.addElement(contentHandler);
            this.activeHandlersAttributeModeUsage.addElement(modeUsage);
            this.attributeProcessing = Math.max(this.attributeProcessing, modeUsage.getAttributeProcessing());
            if (modeUsage.isContextDependent()) {
                this.contextDependent = true;
            }
        }

        public void addAttributeValidationModeUsage(ModeUsage modeUsage) {
            int n = modeUsage.getAttributeProcessing();
            if (n != 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Add attribute validation mode usage: " + modeUsage.currentMode.getName()));
                }
                this.attributeValidationModeUsages.addElement(modeUsage);
                this.attributeProcessing = Math.max(n, this.attributeProcessing);
                if (modeUsage.isContextDependent()) {
                    this.contextDependent = true;
                }
            }
        }

        public void reject() throws SAXException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Reject called!");
            }
            if (ValidatorImpl.this.eh != null) {
                ValidatorImpl.this.eh.error(new SAXParseException(ValidatorImpl.this.localizer.message("reject_element", this.ns), ValidatorImpl.this.locator));
            }
        }

        public void attachPlaceholder(ModeUsage modeUsage, ContentHandler contentHandler) {
            this.placeholderHandlers.add(contentHandler);
            this.placeholderModeUsages.add(modeUsage);
        }
    }

    private static class PrefixMapping {
        final String prefix;
        final String uri;
        final PrefixMapping parent;

        PrefixMapping(String string, String string2, PrefixMapping prefixMapping) {
            this.prefix = string;
            this.uri = string2;
            this.parent = prefixMapping;
        }
    }
}

