/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.equals;

import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.equals.EqualsImplementationRegistry;
import com.phloc.commons.lang.ClassHelper;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ContainerEqualsUtils {
    private ContainerEqualsUtils() {
    }

    @Nullable
    public static EContainerType getContainerTypeOfClass(@Nullable Class<?> aClass) {
        if (aClass != null) {
            if (Set.class.isAssignableFrom(aClass)) {
                return EContainerType.SET;
            }
            if (Collection.class.isAssignableFrom(aClass)) {
                return EContainerType.COLLECTION;
            }
            if (Map.class.isAssignableFrom(aClass)) {
                return EContainerType.MAP;
            }
            if (ClassHelper.isArrayClass(aClass)) {
                return EContainerType.ARRAY;
            }
            if (Iterator.class.isAssignableFrom(aClass)) {
                return EContainerType.ITERATOR;
            }
            if (Iterable.class.isAssignableFrom(aClass)) {
                return EContainerType.ITERABLE;
            }
            if (Enumeration.class.isAssignableFrom(aClass)) {
                return EContainerType.ENUMERATION;
            }
        }
        return null;
    }

    @Nullable
    public static EContainerType getContainerTypeOfObject(@Nullable Object aObj) {
        return aObj == null ? null : ContainerEqualsUtils.getContainerTypeOfClass(aObj.getClass());
    }

    public static boolean isContainerClass(@Nullable Class<?> aClass) {
        return ContainerEqualsUtils.getContainerTypeOfClass(aClass) != null;
    }

    public static boolean isContainerObject(@Nullable Object aObj) {
        return ContainerEqualsUtils.getContainerTypeOfObject(aObj) != null;
    }

    private static boolean _areChildrenEqual(@Nullable Object aObj1, @Nullable Object aObj2) {
        if (ContainerEqualsUtils.isContainerObject(aObj1) && ContainerEqualsUtils.isContainerObject(aObj2)) {
            return ContainerEqualsUtils.equals(aObj1, aObj2);
        }
        return EqualsImplementationRegistry.areEqual(aObj1, aObj2);
    }

    public static boolean equals(@Nullable Object aObj1, @Nullable Object aObj2) {
        if (aObj1 == aObj2) {
            return true;
        }
        if (aObj1 == null || aObj2 == null) {
            return false;
        }
        EContainerType eType1 = ContainerEqualsUtils.getContainerTypeOfObject(aObj1);
        EContainerType eType2 = ContainerEqualsUtils.getContainerTypeOfObject(aObj2);
        if (eType1 == null) {
            throw new IllegalArgumentException("The first parameter is not a container type: " + aObj1);
        }
        if (eType2 == null) {
            throw new IllegalArgumentException("The second parameter is not a container type: " + aObj2);
        }
        if (!eType1.equals((Object)eType2)) {
            return false;
        }
        switch (eType1) {
            case COLLECTION: {
                Collection aCont1 = (Collection)aObj1;
                Collection aCont2 = (Collection)aObj2;
                if (aCont1.isEmpty() && aCont2.isEmpty()) {
                    return true;
                }
                if (aCont1.size() != aCont2.size()) {
                    return false;
                }
                Iterator aIter1 = aCont1.iterator();
                Iterator aIter2 = aCont2.iterator();
                while (aIter1.hasNext()) {
                    Object aChildObj2;
                    Object aChildObj1 = aIter1.next();
                    if (ContainerEqualsUtils._areChildrenEqual(aChildObj1, aChildObj2 = aIter2.next())) continue;
                    return false;
                }
                return true;
            }
            case SET: {
                Set aCont1 = (Set)aObj1;
                Set aCont2 = (Set)aObj2;
                if (aCont1.isEmpty() && aCont2.isEmpty()) {
                    return true;
                }
                if (aCont1.size() != aCont2.size()) {
                    return false;
                }
                for (Object aChildObj1 : aCont1) {
                    if (aCont2.contains(aChildObj1)) continue;
                    return false;
                }
                return true;
            }
            case MAP: {
                Map aCont1 = (Map)aObj1;
                Map aCont2 = (Map)aObj2;
                if (aCont1.isEmpty() && aCont2.isEmpty()) {
                    return true;
                }
                if (aCont1.size() != aCont2.size()) {
                    return false;
                }
                for (Map.Entry aEntry : aCont1.entrySet()) {
                    Object aChildObj2;
                    Object aChildObj1 = aEntry.getValue();
                    if (ContainerEqualsUtils._areChildrenEqual(aChildObj1, aChildObj2 = aCont2.get(aEntry.getKey()))) continue;
                    return false;
                }
                return true;
            }
            case ARRAY: {
                Class<?> aComponentClass1 = aObj1.getClass().getComponentType();
                Class<?> aComponentClass2 = aObj2.getClass().getComponentType();
                if (ContainerEqualsUtils.isContainerClass(aComponentClass1) && ContainerEqualsUtils.isContainerClass(aComponentClass2)) {
                    Object[] aArray1 = (Object[])aObj1;
                    Object[] aArray2 = (Object[])aObj2;
                    if (aArray1.length != aArray2.length) {
                        return false;
                    }
                    for (int i = 0; i < aArray1.length; ++i) {
                        Object aChildObj1 = aArray1[i];
                        Object aChildObj2 = aArray2[i];
                        if (ContainerEqualsUtils._areChildrenEqual(aChildObj1, aChildObj2)) continue;
                        return false;
                    }
                    return true;
                }
                return EqualsImplementationRegistry.areEqual(aObj1, aObj2);
            }
            case ITERATOR: {
                Iterator aIter1 = (Iterator)aObj1;
                Iterator aIter2 = (Iterator)aObj2;
                while (aIter1.hasNext()) {
                    Object aChildObj2;
                    if (!aIter2.hasNext()) {
                        return false;
                    }
                    Object aChildObj1 = aIter1.next();
                    if (ContainerEqualsUtils._areChildrenEqual(aChildObj1, aChildObj2 = aIter2.next())) continue;
                    return false;
                }
                return !aIter2.hasNext();
            }
            case ITERABLE: {
                Iterable aIterable1 = (Iterable)aObj1;
                Iterable aIterable2 = (Iterable)aObj2;
                return ContainerEqualsUtils.equals(aIterable1.iterator(), aIterable2.iterator());
            }
            case ENUMERATION: {
                Enumeration aEnum1 = (Enumeration)aObj1;
                Enumeration aEnum2 = (Enumeration)aObj2;
                while (aEnum1.hasMoreElements()) {
                    Object aChildObj2;
                    if (!aEnum2.hasMoreElements()) {
                        return false;
                    }
                    Object aChildObj1 = aEnum1.nextElement();
                    if (ContainerEqualsUtils._areChildrenEqual(aChildObj1, aChildObj2 = aEnum2.nextElement())) continue;
                    return false;
                }
                return !aEnum2.hasMoreElements();
            }
        }
        throw new IllegalStateException("Unhandled container type " + (Object)((Object)eType1) + "!");
    }

    @Nonnull
    public static List<?> getAsList(@Nonnull Object aObj) {
        if (aObj == null) {
            throw new NullPointerException("object");
        }
        EContainerType eType = ContainerEqualsUtils.getContainerTypeOfObject(aObj);
        if (eType == null) {
            return ContainerHelper.newList(aObj);
        }
        switch (eType) {
            case COLLECTION: {
                if (aObj instanceof List) {
                    return (List)aObj;
                }
                return ContainerHelper.newList((Collection)aObj);
            }
            case SET: {
                return ContainerHelper.newList((Set)aObj);
            }
            case MAP: {
                return ContainerHelper.newList(((Map)aObj).entrySet());
            }
            case ARRAY: {
                return ContainerHelper.newList((Object[])aObj);
            }
            case ITERATOR: {
                return ContainerHelper.newList((Iterator)aObj);
            }
            case ITERABLE: {
                return ContainerHelper.newList((Iterable)aObj);
            }
            case ENUMERATION: {
                return ContainerHelper.newList((Enumeration)aObj);
            }
        }
        throw new IllegalStateException("Unhandled container type " + (Object)((Object)eType) + "!");
    }

    public static boolean equalsAsList(@Nullable Object aObj1, @Nullable Object aObj2) {
        if (aObj1 == aObj2) {
            return true;
        }
        if (aObj1 == null || aObj2 == null) {
            return false;
        }
        List<?> aCollection1 = ContainerEqualsUtils.getAsList(aObj1);
        List<?> aCollection2 = ContainerEqualsUtils.getAsList(aObj2);
        return ContainerEqualsUtils.equals(aCollection1, aCollection2);
    }

    public static enum EContainerType {
        COLLECTION,
        SET,
        MAP,
        ARRAY,
        ITERATOR,
        ITERABLE,
        ENUMERATION;

    }
}

