/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.jaxb.utils;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.annotations.OverrideOnDemand;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.error.IResourceErrorGroup;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.IWritableResource;
import com.phloc.commons.jaxb.JAXBContextCache;
import com.phloc.commons.jaxb.validation.AbstractValidationEventHandler;
import com.phloc.commons.jaxb.validation.CollectingLoggingValidationEventHandlerFactory;
import com.phloc.commons.jaxb.validation.CollectingValidationEventHandler;
import com.phloc.commons.jaxb.validation.IValidationEventHandlerFactory;
import com.phloc.commons.state.EChange;
import com.phloc.commons.state.ESuccess;
import com.phloc.commons.xml.XMLFactory;
import com.phloc.commons.xml.schema.XMLSchemaCache;
import com.phloc.commons.xml.transform.ResourceStreamResult;
import com.phloc.commons.xml.transform.TransformSourceFactory;
import java.io.File;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@NotThreadSafe
public abstract class AbstractJAXBMarshaller<JAXBTYPE> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractJAXBMarshaller.class);
    private final Class<JAXBTYPE> m_aType;
    private final IReadableResource[] m_aXSDs;
    private IValidationEventHandlerFactory m_aVEHFactory = new CollectingLoggingValidationEventHandlerFactory();
    private ValidationEventHandler m_aLastEventHandler;

    protected AbstractJAXBMarshaller(@Nonnull Class<JAXBTYPE> aType, @Nonnull @Nonempty List<? extends IReadableResource> aXSDs) {
        if (aType == null) {
            throw new NullPointerException("type");
        }
        this.m_aType = aType;
        this.m_aXSDs = ArrayHelper.newArray(aXSDs, IReadableResource.class);
    }

    public final void setValidationEventHandlerFactory(@Nullable IValidationEventHandlerFactory aVEHFactory) {
        this.m_aVEHFactory = aVEHFactory;
    }

    @Nullable
    public final IValidationEventHandlerFactory getValidationEventHandlerFactory() {
        return this.m_aVEHFactory;
    }

    @Nullable
    public final ValidationEventHandler getLastValidationEventHandler() {
        return this.m_aLastEventHandler;
    }

    @Nullable
    public final CollectingValidationEventHandler getCollectingValidationEventHandler() {
        ValidationEventHandler aHandler = this.m_aLastEventHandler;
        while (aHandler != null) {
            if (aHandler instanceof CollectingValidationEventHandler) {
                return (CollectingValidationEventHandler)aHandler;
            }
            if (aHandler instanceof AbstractValidationEventHandler) {
                aHandler = ((AbstractValidationEventHandler)aHandler).getWrappedHandler();
                continue;
            }
            aHandler = null;
        }
        return null;
    }

    @Nullable
    public final IResourceErrorGroup getLastValidationErrors() {
        CollectingValidationEventHandler aHandler = this.getCollectingValidationEventHandler();
        return aHandler == null ? null : aHandler.getResourceErrors();
    }

    @Nonnull
    public final EChange clearLastValidationErrors() {
        CollectingValidationEventHandler aHandler = this.getCollectingValidationEventHandler();
        return aHandler == null ? EChange.UNCHANGED : aHandler.clearResourceErrors();
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public final List<IReadableResource> getOriginalXSDs() {
        return ContainerHelper.newList(this.m_aXSDs);
    }

    @OverrideOnDemand
    protected boolean useJAXContextCache() {
        return true;
    }

    @Nullable
    @OverrideOnDemand
    protected Schema createValidationSchema() {
        return ArrayHelper.isEmpty(this.m_aXSDs) ? null : XMLSchemaCache.getInstance().getSchema(this.m_aXSDs);
    }

    @Nonnull
    private Unmarshaller _createUnmarshaller() throws JAXBException {
        Package aPackage = this.m_aType.getPackage();
        JAXBContext aJAXBContext = this.useJAXContextCache() ? (JAXBContext)JAXBContextCache.getInstance().getFromCache(aPackage) : JAXBContext.newInstance((String)aPackage.getName());
        Unmarshaller aUnmarshaller = aJAXBContext.createUnmarshaller();
        if (this.m_aVEHFactory != null) {
            this.m_aLastEventHandler = this.m_aVEHFactory.create(aUnmarshaller.getEventHandler());
            aUnmarshaller.setEventHandler(this.m_aLastEventHandler);
        } else {
            this.m_aLastEventHandler = null;
        }
        Schema aValidationSchema = this.createValidationSchema();
        if (aValidationSchema != null) {
            aUnmarshaller.setSchema(aValidationSchema);
        }
        return aUnmarshaller;
    }

    @Nullable
    public final JAXBTYPE read(@Nonnull File aFile) {
        if (aFile == null) {
            throw new NullPointerException("file");
        }
        return this.read(TransformSourceFactory.create(aFile));
    }

    @Nullable
    public final JAXBTYPE read(@Nonnull IReadableResource aResource) {
        if (aResource == null) {
            throw new NullPointerException("resource");
        }
        return this.read(TransformSourceFactory.create(aResource));
    }

    @Nullable
    public final JAXBTYPE read(@Nonnull Node aNode) {
        if (aNode == null) {
            throw new NullPointerException("node");
        }
        return this.read(TransformSourceFactory.create(aNode));
    }

    @Nullable
    public final JAXBTYPE read(@Nonnull Source aSource) {
        if (aSource == null) {
            throw new NullPointerException("source");
        }
        try {
            Unmarshaller aUnmarshaller = this._createUnmarshaller();
            return (JAXBTYPE)aUnmarshaller.unmarshal(aSource, this.m_aType).getValue();
        }
        catch (UnmarshalException ex) {
            s_aLogger.error("Unmarshal exception reading document", (Throwable)ex);
        }
        catch (JAXBException ex) {
            s_aLogger.warn("JAXB Exception reading document", (Throwable)ex);
        }
        return null;
    }

    @Nonnull
    private Marshaller _createMarshaller() throws JAXBException {
        Package aPackage = this.m_aType.getPackage();
        JAXBContext aJAXBContext = this.useJAXContextCache() ? (JAXBContext)JAXBContextCache.getInstance().getFromCache(aPackage) : JAXBContext.newInstance((String)aPackage.getName());
        Marshaller aMarshaller = aJAXBContext.createMarshaller();
        if (this.m_aVEHFactory != null) {
            this.m_aLastEventHandler = this.m_aVEHFactory.create(aMarshaller.getEventHandler());
            aMarshaller.setEventHandler(this.m_aLastEventHandler);
        } else {
            this.m_aLastEventHandler = null;
        }
        Schema aValidationSchema = this.createValidationSchema();
        if (aValidationSchema != null) {
            aMarshaller.setSchema(aValidationSchema);
        }
        return aMarshaller;
    }

    @Nonnull
    protected abstract JAXBElement<JAXBTYPE> wrapObject(@Nonnull JAXBTYPE var1);

    @Nullable
    public final Document write(@Nonnull JAXBTYPE aObject) {
        if (aObject == null) {
            throw new NullPointerException("object");
        }
        Document aDoc = XMLFactory.newDocument();
        return this.write(aObject, new DOMResult(aDoc)).isSuccess() ? aDoc : null;
    }

    @Nonnull
    public final ESuccess write(@Nonnull JAXBTYPE aObject, @Nonnull File aResultFile) {
        return this.write(aObject, new StreamResult(aResultFile));
    }

    @Nonnull
    public final ESuccess write(@Nonnull JAXBTYPE aObject, @Nonnull IWritableResource aResource) {
        return this.write(aObject, new ResourceStreamResult(aResource));
    }

    @Nonnull
    public final ESuccess write(@Nonnull JAXBTYPE aObject, @Nonnull Result aResult) {
        if (aObject == null) {
            throw new NullPointerException("object");
        }
        if (aResult == null) {
            throw new NullPointerException("result");
        }
        try {
            Marshaller aMarshaller = this._createMarshaller();
            JAXBElement<JAXBTYPE> aJAXBElement = this.wrapObject(aObject);
            aMarshaller.marshal(aJAXBElement, aResult);
            return ESuccess.SUCCESS;
        }
        catch (MarshalException ex) {
            s_aLogger.error("Marshal exception writing object", (Throwable)ex);
        }
        catch (JAXBException ex) {
            s_aLogger.warn("JAXB Exception writing object", (Throwable)ex);
        }
        return ESuccess.FAILURE;
    }
}

