/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.locale.country;

import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.collections.ContainerHelper;
import com.phloc.commons.locale.LocaleCache;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.StringHelper;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CountryCache {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CountryCache.class);
    private static final ReadWriteLock s_aRWLock = new ReentrantReadWriteLock();
    private static final Set<String> s_aCountries = new HashSet<String>();
    private static final CountryCache s_aInstance;

    private CountryCache() {
    }

    @Nonnull
    private static String _getUnifiedCountry(@Nonnull String sCountry) {
        return sCountry.toUpperCase(Locale.US);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    static EChange addCountry(@Nonnull String sCountry) {
        if (sCountry == null) {
            throw new NullPointerException("country");
        }
        if (!sCountry.equals(CountryCache._getUnifiedCountry(sCountry))) {
            throw new IllegalArgumentException("illegal casing of '" + sCountry + "'");
        }
        s_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.valueOf(s_aCountries.add(sCountry));
            return eChange;
        }
        finally {
            s_aRWLock.writeLock().unlock();
        }
    }

    @Nullable
    public static Locale getCountry(@Nullable Locale aCountry) {
        return aCountry == null ? null : CountryCache.getCountry(aCountry.getCountry());
    }

    @Nullable
    public static Locale getCountry(@Nullable String sCountry) {
        if (StringHelper.hasNoText(sCountry)) {
            return null;
        }
        if (sCountry.indexOf(95) >= 0) {
            return CountryCache.getCountry(LocaleCache.getLocale(sCountry));
        }
        String sRealCountry = CountryCache._getUnifiedCountry(sCountry);
        if (!CountryCache.containsCountry(sRealCountry)) {
            s_aLogger.warn("Trying to retrieve unsupported country " + sRealCountry);
        }
        return LocaleCache.getLocale("", sRealCountry, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public static Set<String> getAllCountries() {
        s_aRWLock.readLock().lock();
        try {
            Set<String> set = ContainerHelper.newSet(s_aCountries);
            return set;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    public static boolean containsCountry(@Nullable Locale aCountry) {
        return aCountry == null ? false : CountryCache.containsCountry(aCountry.getCountry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsCountry(@Nullable String sCountry) {
        if (sCountry == null) {
            return false;
        }
        s_aRWLock.readLock().lock();
        try {
            boolean bl = s_aCountries.contains(CountryCache._getUnifiedCountry(sCountry));
            return bl;
        }
        finally {
            s_aRWLock.readLock().unlock();
        }
    }

    static {
        for (Locale aLocale : LocaleCache.getAllLocales()) {
            String sCountry = aLocale.getCountry();
            if (!StringHelper.hasText(sCountry)) continue;
            CountryCache.addCountry(sCountry);
        }
        s_aInstance = new CountryCache();
    }
}

