/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.css.decl;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.css.ICSSWriterSettings;
import com.phloc.css.decl.CSSDeclarationList;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class CSSDeclarationContainer
extends CSSDeclarationList {
    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings aSettings, @Nonnegative int nIndentLevel) {
        boolean bOptimizedOutput = aSettings.isOptimizedOutput();
        StringBuilder aSB = new StringBuilder();
        int nDeclCount = this.getDeclarationCount();
        if (nDeclCount == 0) {
            aSB.append(bOptimizedOutput ? "{}" : " {}");
        } else if (nDeclCount == 1) {
            aSB.append(bOptimizedOutput ? "{" : " { ");
            aSB.append(super.getAsCSSString(aSettings, nIndentLevel));
            aSB.append(bOptimizedOutput ? "}" : " }");
        } else {
            aSB.append(bOptimizedOutput ? "{" : " {\n");
            aSB.append(super.getAsCSSString(aSettings, nIndentLevel));
            if (!bOptimizedOutput) {
                aSB.append(aSettings.getIndent(nIndentLevel));
            }
            aSB.append('}');
        }
        return aSB.toString();
    }
}

