/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.cvs;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.w3c.cvs.CVS;
import org.w3c.cvs.CvsCommitHandler;
import org.w3c.cvs.CvsEntry;
import org.w3c.cvs.CvsException;
import org.w3c.cvs.CvsRunner;
import org.w3c.cvs.CvsStatusHandler;
import org.w3c.cvs.CvsUpdateHandler;
import org.w3c.cvs.DirectoryEnumeration;
import org.w3c.cvs.DirectoryFilter;
import org.w3c.cvs.DirectoryUpdateHandler;
import org.w3c.cvs.FileEnumeration;
import org.w3c.cvs.LoadUpdateHandler;
import org.w3c.cvs.UncheckedOutException;
import org.w3c.util.AsyncLRUList;
import org.w3c.util.LRUAble;
import org.w3c.util.LRUList;

public class CvsDirectory
implements LRUAble,
CVS {
    public static final String CVSPATH_P = "org.w3c.cvs.path";
    public static final String CVSROOT_P = "org.w3c.cvs.root";
    public static final String CVSWRAP_P = "org.w3c.cvs.wrapper";
    public static final String cvspath_def = "/usr/local/bin/cvs";
    public static final String cvsroot_def = "/afs/w3.org/CVS-Repository";
    public static final String cvswrap_def = "/afs/w3.org/usr/abaird/Jigsaw/bin/cvs_wrapper";
    protected static Hashtable cache = new Hashtable(23);
    protected static LRUList lru = new AsyncLRUList();
    protected static int cachesize = 32;
    protected LRUAble prev = null;
    protected LRUAble next = null;
    protected long cvscheck_stamp = -1L;
    protected long cvsrep_stamp = -1L;
    protected boolean clean = true;
    protected File directory = null;
    protected File repdir = null;
    protected Hashtable entries = null;
    protected CvsRunner runner = null;
    public Properties props = null;
    String cvspath = "/usr/local/bin/cvs";
    String cvsroot = "/afs/w3.org/CVS-Repository";
    String[] cvswrapper = new String[]{"/afs/w3.org/usr/abaird/Jigsaw/bin/cvs_wrapper"};
    public static Properties defprops = null;

    private static String[] parseArrayProperty(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    File computeRepositoryDirectory(File file) {
        File file2 = new File(new File(file, "CVS"), "Repository");
        File file3 = null;
        if (!file2.exists()) {
            return null;
        }
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file2));
            String string = dataInputStream.readLine();
            file3 = string.startsWith("/") ? new File(string) : new File(this.cvsroot, string);
            dataInputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return file3;
    }

    protected String[] getCvsWrapper() {
        return this.cvswrapper;
    }

    protected String[] getCvsDefaults() {
        String[] stringArray = new String[]{"-directory", this.getDirectory().getAbsolutePath(), this.cvspath, "-q", "-d", this.cvsroot};
        return stringArray;
    }

    protected synchronized void createFileEntry(long l, String string, int n) {
        if (this.entries == null) {
            this.entries = new Hashtable(13);
        }
        CvsEntry cvsEntry = new CvsEntry(this, l, string, false, n);
        this.entries.put(string, cvsEntry);
    }

    protected synchronized void createDirectoryEntry(long l, String string, int n) {
        if (this.entries == null) {
            this.entries = new Hashtable(13);
        }
        CvsEntry cvsEntry = new CvsEntry(this, l, string, true, n);
        this.entries.put(string, cvsEntry);
    }

    public static synchronized CvsDirectory getManager(File file, Properties properties, String string, String string2, String[] stringArray) throws CvsException {
        String string3;
        CvsDirectory cvsDirectory;
        if (defprops == null) {
            defprops = System.getProperties();
        }
        if ((cvsDirectory = (CvsDirectory)cache.get(string3 = file.getAbsolutePath())) != null) {
            cvsDirectory.cacheLoaded();
            return cvsDirectory;
        }
        cvsDirectory = new CvsDirectory(file, properties == null ? defprops : properties, string, string2, stringArray);
        if (cache.size() >= cachesize) {
            CvsDirectory.cacheUnload();
        }
        cache.put(string3, cvsDirectory);
        lru.toHead(cvsDirectory);
        return cvsDirectory;
    }

    public static CvsDirectory getManager(File file) throws CvsException {
        return CvsDirectory.getManager(file, null, null, null, null);
    }

    public static CvsDirectory getManager(File file, Properties properties) throws CvsException {
        return CvsDirectory.getManager(file, properties, null, null, null);
    }

    protected static CvsDirectory getManager(CvsDirectory cvsDirectory, File file) throws CvsException {
        return CvsDirectory.getManager(file, cvsDirectory.props, null, null, null);
    }

    public LRUAble getNext() {
        return this.next;
    }

    public LRUAble getPrev() {
        return this.prev;
    }

    public void setNext(LRUAble lRUAble) {
        this.next = lRUAble;
    }

    public void setPrev(LRUAble lRUAble) {
        this.prev = lRUAble;
    }

    public static String statusToString(int n) {
        return n > 0 && n < CVS.status.length ? CVS.status[n] : "unknown";
    }

    protected void cacheLoaded() throws CvsException {
        lru.toHead(this);
    }

    protected static synchronized void cacheUnload() {
        CvsDirectory cvsDirectory = (CvsDirectory)lru.removeTail();
        if (cvsDirectory != null) {
            cvsDirectory.entries = null;
            cvsDirectory.clean = true;
            cvsDirectory.cvsrep_stamp = -1L;
            cvsDirectory.cvscheck_stamp = -1L;
            cache.remove(cvsDirectory.getDirectory().getAbsolutePath());
        }
    }

    protected CvsEntry getFileEntry(String string) {
        return this.entries != null ? (CvsEntry)this.entries.get(string) : null;
    }

    protected void removeFileEntry(String string) {
        if (this.entries != null) {
            this.entries.remove(string);
        }
    }

    protected CvsEntry getDirectoryEntry(String string) {
        return this.entries != null ? (CvsEntry)this.entries.get(string) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws CvsException {
        CvsDirectory cvsDirectory = this;
        synchronized (cvsDirectory) {
            LoadUpdateHandler loadUpdateHandler = new LoadUpdateHandler(this);
            CvsStatusHandler cvsStatusHandler = new CvsStatusHandler(this);
            try {
                this.entries = null;
                this.runner.cvsLoad(this, loadUpdateHandler, cvsStatusHandler);
            }
            catch (CvsException cvsException) {
                this.clean = true;
                this.entries = null;
                throw cvsException;
            }
            this.clean = false;
            this.cvscheck_stamp = this.getDirectory().lastModified();
            loadUpdateHandler.notifyEnd();
            cvsStatusHandler.notifyEnd();
        }
        lru.toHead(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(String string) throws CvsException {
        CvsDirectory cvsDirectory = this;
        synchronized (cvsDirectory) {
            LoadUpdateHandler loadUpdateHandler = new LoadUpdateHandler(this);
            CvsStatusHandler cvsStatusHandler = new CvsStatusHandler(this);
            this.runner.cvsLoad(this, string, loadUpdateHandler, cvsStatusHandler);
            loadUpdateHandler.notifyEnd();
            cvsStatusHandler.notifyEnd();
        }
        lru.toHead(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshStatus(String string) throws CvsException {
        CvsDirectory cvsDirectory = this;
        synchronized (cvsDirectory) {
            LoadUpdateHandler loadUpdateHandler = new LoadUpdateHandler(this);
            this.runner.cvsLoad(this, string, loadUpdateHandler);
            loadUpdateHandler.notifyEnd();
        }
        lru.toHead(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshRevision(String string) throws CvsException {
        CvsDirectory cvsDirectory = this;
        synchronized (cvsDirectory) {
            CvsStatusHandler cvsStatusHandler = new CvsStatusHandler(this);
            this.runner.cvsStatus(this, string, cvsStatusHandler);
            cvsStatusHandler.notifyEnd();
        }
    }

    protected synchronized void checkUse() throws CvsException {
        if (this.clean) {
            if (cache.size() >= cachesize) {
                CvsDirectory.cacheUnload();
            }
            this.cacheLoaded();
            cache.put(this.getDirectory().getAbsolutePath(), this);
            this.clean = false;
        }
        if (this.needsUpdate()) {
            this.refresh();
        }
    }

    protected synchronized void checkUse(String string) throws CvsException {
        CvsEntry cvsEntry = this.getFileEntry(string);
        if (cvsEntry == null || cvsEntry.needsUpdate()) {
            this.refresh();
        }
    }

    protected synchronized void checkDirectoryUse() throws CvsException {
        if (this.repdir == null && (this.repdir = this.computeRepositoryDirectory(this.getDirectory())) == null) {
            throw new CvsException("Repository not accessible.");
        }
        if (this.cvsrep_stamp < this.repdir.lastModified()) {
            int n;
            long l = System.currentTimeMillis();
            String[] stringArray = this.repdir.list(new DirectoryFilter());
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    File file = new File(this.getDirectory(), stringArray[n]);
                    if (file.exists()) {
                        this.createDirectoryEntry(l, stringArray[n], 9);
                        continue;
                    }
                    this.createDirectoryEntry(l, stringArray[n], 10);
                }
            }
            if ((stringArray = this.getDirectory().list(new DirectoryFilter())) != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    if (this.getDirectoryEntry(stringArray[n]) != null) continue;
                    this.createDirectoryEntry(l, stringArray[n], 11);
                }
            }
            this.cvsrep_stamp = l;
        }
    }

    protected synchronized void checkDirectoryUse(String string) throws CvsException {
        if (this.repdir == null && (this.repdir = this.computeRepositoryDirectory(this.getDirectory())) == null) {
            throw new CvsException("Repository not accessible.");
        }
        if (this.cvsrep_stamp < this.repdir.lastModified()) {
            long l = System.currentTimeMillis();
            File file = new File(this.repdir, string);
            if (file.exists()) {
                File file2 = new File(this.getDirectory(), string);
                if (file2.exists()) {
                    this.createDirectoryEntry(l, string, 9);
                } else {
                    this.createDirectoryEntry(l, string, 10);
                }
            } else {
                this.createDirectoryEntry(l, string, 11);
            }
        }
    }

    protected boolean needsUpdate() {
        if (this.cvscheck_stamp < this.directory.lastModified()) {
            return true;
        }
        if (this.entries != null) {
            Enumeration enumeration = this.entries.elements();
            while (enumeration.hasMoreElements()) {
                CvsEntry cvsEntry = (CvsEntry)enumeration.nextElement();
                if (!cvsEntry.needsUpdate()) continue;
                return true;
            }
        }
        return false;
    }

    public Enumeration listFiles() throws CvsException {
        lru.toHead(this);
        this.checkUse();
        return new FileEnumeration(this.entries);
    }

    public Enumeration listDirectories() throws CvsException {
        lru.toHead(this);
        this.checkDirectoryUse();
        return new DirectoryEnumeration(this.entries);
    }

    public int status(String string, boolean bl) throws CvsException {
        if (bl) {
            this.refreshStatus(string);
        }
        return this.status(string);
    }

    public int status(String string) throws CvsException {
        CvsEntry cvsEntry;
        lru.toHead(this);
        this.checkUse(string);
        CvsEntry cvsEntry2 = cvsEntry = this.entries != null ? (CvsEntry)this.entries.get(string) : null;
        if (cvsEntry == null) {
            this.refresh(string);
            CvsEntry cvsEntry3 = cvsEntry = this.entries != null ? (CvsEntry)this.entries.get(string) : null;
            if (cvsEntry == null) {
                throw new CvsException(string + ": no such entry.");
            }
        }
        return cvsEntry.getStatus();
    }

    public String revision(String string) throws CvsException {
        CvsEntry cvsEntry;
        lru.toHead(this);
        this.checkUse(string);
        CvsEntry cvsEntry2 = cvsEntry = this.entries != null ? (CvsEntry)this.entries.get(string) : null;
        if (cvsEntry == null) {
            this.refresh(string);
            CvsEntry cvsEntry3 = cvsEntry = this.entries != null ? (CvsEntry)this.entries.get(string) : null;
            if (cvsEntry == null) {
                throw new CvsException(string + ": no such entry.");
            }
        } else if (cvsEntry.getRevision() == null && cvsEntry.getStatus() != 7) {
            this.refreshRevision(string);
        }
        return cvsEntry.getRevision();
    }

    public String stickyOptions(String string) throws CvsException {
        CvsEntry cvsEntry;
        lru.toHead(this);
        this.checkUse(string);
        CvsEntry cvsEntry2 = cvsEntry = this.entries != null ? (CvsEntry)this.entries.get(string) : null;
        if (cvsEntry == null) {
            this.refresh(string);
            CvsEntry cvsEntry3 = cvsEntry = this.entries != null ? (CvsEntry)this.entries.get(string) : null;
            if (cvsEntry == null) {
                throw new CvsException(string + ": no such entry.");
            }
        } else if (cvsEntry.getRevision() == null && cvsEntry.getStatus() != 7) {
            this.refreshRevision(string);
        }
        return cvsEntry.getStickyOptions();
    }

    public void update(String[] stringArray) throws CvsException {
        lru.toHead(this);
        CvsUpdateHandler cvsUpdateHandler = new CvsUpdateHandler(this);
        this.runner.cvsUpdate(this, stringArray, cvsUpdateHandler);
    }

    public void update(String string) throws CvsException {
        String[] stringArray = new String[]{string};
        this.update(stringArray);
    }

    public void update() throws CvsException {
        lru.toHead(this);
        CvsUpdateHandler cvsUpdateHandler = new CvsUpdateHandler(this);
        this.runner.cvsUpdate(this, cvsUpdateHandler);
    }

    public void updateRegexp(String string) throws CvsException {
        this.update(string);
    }

    public void get(String string) throws CvsException {
        lru.toHead(this);
        this.runner.cvsGet(this, string);
    }

    public void commit(String[] stringArray, String string, String[] stringArray2) throws CvsException {
        lru.toHead(this);
        CvsCommitHandler cvsCommitHandler = new CvsCommitHandler(this);
        this.runner.cvsCommit(this, stringArray, string, cvsCommitHandler, stringArray2);
    }

    public void commit(String string, String string2, String[] stringArray) throws CvsException {
        lru.toHead(this);
        String[] stringArray2 = new String[]{string};
        this.commit(stringArray2, string2, stringArray);
    }

    public void commit(String[] stringArray, String string) throws CvsException {
        lru.toHead(this);
        CvsCommitHandler cvsCommitHandler = new CvsCommitHandler(this);
        this.runner.cvsCommit(this, stringArray, string, cvsCommitHandler);
    }

    public void commit(String string, String string2) throws CvsException {
        String[] stringArray = new String[]{string};
        this.commit(stringArray, string2);
    }

    public void commit(String string) throws CvsException {
        lru.toHead(this);
        CvsCommitHandler cvsCommitHandler = new CvsCommitHandler(this);
        this.runner.cvsCommit(this, string, cvsCommitHandler);
    }

    public void commit(String string, String[] stringArray) throws CvsException {
        lru.toHead(this);
        CvsCommitHandler cvsCommitHandler = new CvsCommitHandler(this);
        this.runner.cvsCommit(this, string, cvsCommitHandler, stringArray);
    }

    public void commitRegexp(String string, String string2, String[] stringArray) throws CvsException {
        this.commit(string, string2, stringArray);
    }

    public void revert(String string, String string2, String string3, String[] stringArray) throws CvsException {
        File file = new File(this.getDirectory(), string);
        if (!file.exists()) {
            throw new CvsException("the file " + file + " can't be reverted : " + "it doesn't exists!");
        }
        file.delete();
        String[] stringArray2 = new String[]{string};
        this.runner.cvsRevert(this, string, string2, file, stringArray);
    }

    public void revert(String string, OutputStream outputStream, String string2, String[] stringArray) throws CvsException {
        this.runner.cvsRevert(this, string, string2, outputStream, stringArray);
    }

    public String log(String string) throws CvsException {
        lru.toHead(this);
        return this.runner.cvsLog(this, string);
    }

    public String diff(String string) throws CvsException {
        lru.toHead(this);
        this.checkUse(string);
        CvsEntry cvsEntry = this.getFileEntry(string);
        if (cvsEntry != null && !cvsEntry.needsUpdate() && cvsEntry.getStatus() == 1) {
            return null;
        }
        return this.runner.cvsDiff(this, string);
    }

    public void add(String[] stringArray) throws CvsException {
        this.add(stringArray, null);
    }

    public void add(String[] stringArray, String[] stringArray2) throws CvsException {
        lru.toHead(this);
        long l = System.currentTimeMillis();
        this.runner.cvsAdd(this, stringArray, stringArray2);
        for (int i = 0; i < stringArray.length; ++i) {
            CvsEntry cvsEntry = this.getFileEntry(stringArray[i]);
            if (cvsEntry != null) {
                cvsEntry.setStatus(l, 2);
                continue;
            }
            this.createFileEntry(l, stringArray[i], 2);
        }
    }

    public void addRegexp(String string, String[] stringArray) throws CvsException {
        lru.toHead(this);
        String[] stringArray2 = new String[]{string};
        this.runner.cvsAdd(this, stringArray2, stringArray);
        this.refresh();
    }

    public void remove(String[] stringArray, String string, String[] stringArray2) throws CvsException {
        lru.toHead(this);
        long l = System.currentTimeMillis();
        this.runner.cvsRemove(this, stringArray);
        this.commit(stringArray, string, stringArray2);
        for (int i = 0; i < stringArray.length; ++i) {
            this.removeFileEntry(stringArray[i]);
        }
    }

    public void admin(String[] stringArray) throws CvsException {
        lru.toHead(this);
        this.runner.cvsAdmin(this, stringArray);
    }

    public void display(PrintStream printStream) {
        lru.toHead(this);
        try {
            Enumeration enumeration = this.listFiles();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                int n = this.status(string);
                printStream.println(string + ": " + CVS.status[n]);
            }
        }
        catch (CvsException cvsException) {
            printStream.println("*** CVS Error: " + cvsException.getMessage());
        }
    }

    public int getDirectoryStatus(String string) throws CvsException {
        return this.getDirectoryStatus(string, true);
    }

    public int getDirectoryStatus(String string, boolean bl) throws CvsException {
        lru.toHead(this);
        if (bl) {
            this.checkDirectoryUse();
        } else {
            this.checkDirectoryUse(string);
        }
        CvsEntry cvsEntry = this.getDirectoryEntry(string);
        return cvsEntry == null ? 11 : cvsEntry.getStatus();
    }

    public void updateDirectory(String string) throws CvsException {
        lru.toHead(this);
        this.checkDirectoryUse();
        CvsEntry cvsEntry = this.getDirectoryEntry(string);
        if (cvsEntry == null) {
            throw new CvsException("Unknown subdirectory " + string);
        }
        DirectoryUpdateHandler directoryUpdateHandler = new DirectoryUpdateHandler(this);
        this.runner.cvsUpdateDirectory(this, cvsEntry.file, directoryUpdateHandler);
        cvsEntry.setStatus(directoryUpdateHandler.stamp, 9);
    }

    public File getDirectory() {
        return this.directory;
    }

    protected CvsDirectory(File file, Properties properties, String string, String string2, String[] stringArray) throws CvsException {
        if (!file.exists()) {
            throw new UncheckedOutException("Unchecked out directory: " + file.getAbsolutePath());
        }
        this.props = properties;
        this.cvspath = string == null ? properties.getProperty(CVSPATH_P, cvspath_def) : string;
        this.cvsroot = string2 == null ? properties.getProperty(CVSROOT_P, cvsroot_def) : string2;
        this.cvswrapper = stringArray == null ? CvsDirectory.parseArrayProperty(properties.getProperty(CVSWRAP_P, cvswrap_def)) : stringArray;
        this.directory = file;
        this.cvscheck_stamp = -1L;
        this.runner = new CvsRunner();
    }

    public static void usage() {
        System.out.println("CvsDirectory <dir> [command] [files]");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String[] stringArray2 = null;
        File file = null;
        switch (stringArray.length) {
            case 0: {
                CvsDirectory.usage();
                break;
            }
            case 1: {
                file = new File(stringArray[0]);
                break;
            }
            case 2: {
                file = new File(stringArray[0]);
                string = stringArray[1];
                break;
            }
            default: {
                file = new File(stringArray[0]);
                string = stringArray[1];
                stringArray2 = new String[stringArray.length - 2];
                System.arraycopy(stringArray, 2, stringArray2, 0, stringArray.length - 2);
            }
        }
        try {
            CvsDirectory cvsDirectory = CvsDirectory.getManager(new File(stringArray[0]));
            if (string == null) {
                cvsDirectory.display(System.out);
            } else if (string.equals("update")) {
                if (stringArray2 != null) {
                    cvsDirectory.update(stringArray2);
                } else {
                    cvsDirectory.update();
                }
            } else if (string.equals("status")) {
                if (stringArray2.length != 1) {
                    CvsDirectory.usage();
                }
                System.out.println(CVS.status[cvsDirectory.status(stringArray2[0])]);
            } else if (string.equals("diff")) {
                if (stringArray2.length != 1) {
                    CvsDirectory.usage();
                }
                System.out.println(cvsDirectory.diff(stringArray2[0]));
            } else if (string.equals("log")) {
                if (stringArray2.length != 1) {
                    CvsDirectory.usage();
                }
                System.out.println(cvsDirectory.log(stringArray2[0]));
            } else if (string.equals("add")) {
                if (stringArray2.length == 0) {
                    CvsDirectory.usage();
                }
                cvsDirectory.add(stringArray2);
            } else if (string.equals("listdir")) {
                Enumeration enumeration = cvsDirectory.listDirectories();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    System.out.println(string2 + ": " + CVS.status[cvsDirectory.getDirectoryStatus(string2)]);
                }
            } else if (string.equals("updatedir")) {
                if (stringArray2.length == 0) {
                    CvsDirectory.usage();
                }
                cvsDirectory.updateDirectory(stringArray2[0]);
            } else {
                System.err.println("Unknown command [" + string + "]");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

