/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.http.socket;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import org.w3c.jigsaw.http.Client;
import org.w3c.jigsaw.http.ClientException;
import org.w3c.jigsaw.http.httpd;
import org.w3c.jigsaw.http.socket.SocketClientFactory;
import org.w3c.jigsaw.http.socket.SocketClientState;
import org.w3c.jigsaw.http.socket.SocketOutputBuffer;

public class SocketClient
extends Client
implements Runnable {
    private static final boolean trace = false;
    private SocketClientFactory pool = null;
    protected Socket socket = null;
    protected boolean alive = false;
    SocketClientState state = null;
    protected int bindcount = 0;
    protected Thread thread = null;
    protected SocketOutputBuffer bufout = null;
    protected boolean idle = false;
    protected boolean done = false;

    public String toString() {
        if (this.thread != null) {
            return "client-" + this.state.id + "(" + this.thread.getName() + ")";
        }
        return "client-" + this.state.id;
    }

    public void join() {
        if (this.thread != null) {
            while (true) {
                try {
                    while (true) {
                        this.thread.join();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.thread = Thread.currentThread();
        try {
            if (this.bufout == null) {
                int n = this.getServer().getClientBufferSize() - 1;
                this.bufout = new SocketOutputBuffer(this.socket.getOutputStream(), n);
            } else {
                this.bufout.reuse(this.socket.getOutputStream());
            }
            this.startConnection(new BufferedInputStream(this.socket.getInputStream()), new DataOutputStream(this.bufout));
        }
        catch (IOException iOException) {
            if (this.debug) {
                iOException.printStackTrace();
            }
        }
        catch (ClientException clientException) {
            if (this.debug) {
                clientException.printStackTrace();
            }
            if (this.debug) {
                if (clientException.ex != null) {
                    clientException.ex.printStackTrace();
                } else {
                    clientException.printStackTrace();
                }
            }
            if (this.alive && !this.idle) {
                this.error("caught ClientException: [" + clientException.getClass().getName() + "] " + clientException.getMessage());
            }
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println("unknown exception caught in client run");
                exception.printStackTrace();
            }
        }
        finally {
            if (!this.pool.clientConnectionFinished(this)) {
                this.pool.clientFinished(this);
            }
            this.thread = null;
        }
    }

    public InetAddress getInetAddress() {
        return this.socket != null ? this.socket.getInetAddress() : null;
    }

    protected void stopConnection() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    protected Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean idleConnection() {
        SocketClientState socketClientState = this.state;
        synchronized (socketClientState) {
            this.idle = true;
            return !this.pool.notifyIdle(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void usedConnection() {
        SocketClientState socketClientState = this.state;
        synchronized (socketClientState) {
            this.idle = false;
            this.pool.notifyUse(this);
        }
    }

    protected synchronized void bind(Socket socket) {
        this.done = false;
        httpd httpd2 = this.getServer();
        this.socket = socket;
        try {
            socket.setSoTimeout(this.pool.timeout);
        }
        catch (SocketException socketException) {
            httpd2.errlog("Unable to set socket timeout!");
        }
        this.idle = false;
        ++this.bindcount;
        this.pool.run(this);
    }

    protected synchronized void unbind() {
        this.interruptConnection(true);
    }

    protected synchronized void kill(boolean bl) {
        this.alive = false;
        this.interruptConnection(bl);
    }

    public final int getBindCount() {
        return this.bindcount;
    }

    protected SocketClient(httpd httpd2, SocketClientFactory socketClientFactory, SocketClientState socketClientState) {
        this.initialize(httpd2, socketClientState.id);
        this.socket = null;
        this.pool = socketClientFactory;
        this.state = socketClientState;
        this.alive = true;
    }
}

