/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.factory;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.factory.IFactory;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.lang.ClassHelper;
import com.phloc.commons.lang.GenericReflection;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class FactoryNewInstance<DATATYPE>
implements IFactory<DATATYPE> {
    private final Class<? extends DATATYPE> m_aClass;

    public FactoryNewInstance(@Nullable Class<? extends DATATYPE> aClass, boolean bCheckInstancable) {
        if (bCheckInstancable && !ClassHelper.isInstancableClass(aClass)) {
            throw new IllegalArgumentException("The passed class '" + aClass + "' is not instancable or doesn't have a no-argument constructor!");
        }
        this.m_aClass = aClass;
    }

    @Override
    @Nullable
    public DATATYPE create() {
        return GenericReflection.newInstance(this.m_aClass);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FactoryNewInstance)) {
            return false;
        }
        FactoryNewInstance rhs = (FactoryNewInstance)o;
        return EqualsUtils.equals(this.m_aClass, rhs.m_aClass);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aClass).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("class", this.m_aClass).toString();
    }

    @Nonnull
    public static <DATATYPE> FactoryNewInstance<DATATYPE> create(@Nullable Class<DATATYPE> aClass) {
        return FactoryNewInstance.create(aClass, false);
    }

    @Nonnull
    public static <DATATYPE> FactoryNewInstance<DATATYPE> create(@Nullable Class<DATATYPE> aClass, boolean bCheckInstancable) {
        return new FactoryNewInstance<DATATYPE>(aClass, bCheckInstancable);
    }
}

