/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.stats;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.stats.IStatisticsHandlerCache;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class StatisticsHandlerCache
implements IStatisticsHandlerCache {
    private final AtomicInteger m_aHits = new AtomicInteger();
    private final AtomicInteger m_aMisses = new AtomicInteger();

    StatisticsHandlerCache() {
    }

    @Override
    @Nonnegative
    public int getInvocationCount() {
        return this.getHits() + this.getMisses();
    }

    @Override
    public void cacheHit() {
        this.m_aHits.incrementAndGet();
    }

    @Override
    public void cacheMiss() {
        this.m_aMisses.incrementAndGet();
    }

    @Override
    @Nonnegative
    public int getHits() {
        return this.m_aHits.intValue();
    }

    @Override
    @Nonnegative
    public int getMisses() {
        return this.m_aMisses.intValue();
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsString() {
        return "invocations=" + this.getInvocationCount() + ";hits=" + this.getHits() + ";misses=" + this.getMisses();
    }
}

