/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.text.impl;

import com.phloc.commons.callback.IChangeNotify;
import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.locale.LocaleCache;
import com.phloc.commons.locale.LocaleUtils;
import com.phloc.commons.state.EChange;
import com.phloc.commons.text.IMultiLingualText;
import com.phloc.commons.text.IReadonlyMultiLingualText;
import com.phloc.commons.text.ISimpleMultiLingualText;
import com.phloc.commons.text.impl.TextProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MultiLingualText
extends TextProvider
implements IMultiLingualText {
    private static final long serialVersionUID = 136888667633487L;
    public static final IMultiLingualText EMPTY_MULTILINGUAL_TEXT = new MultiLingualText();
    private List<IChangeNotify<IMultiLingualText>> m_aChangeNotifyList;

    public MultiLingualText() {
    }

    public MultiLingualText(@Nonnull ISimpleMultiLingualText aSimpleMLT) {
        if (aSimpleMLT == null) {
            throw new NullPointerException("MLT");
        }
        for (Locale aLocale : aSimpleMLT.getAllLocales()) {
            this.internalAddText(aLocale, aSimpleMLT.getText(aLocale));
        }
    }

    public MultiLingualText(@Nonnull IReadonlyMultiLingualText aMLT) {
        if (aMLT == null) {
            throw new NullPointerException("MLT");
        }
        for (Map.Entry<Locale, String> aEntry : aMLT.getMap().entrySet()) {
            this.internalAddText(aEntry.getKey(), aEntry.getValue());
        }
    }

    private boolean _beforeChange() {
        if (this.m_aChangeNotifyList != null) {
            for (IChangeNotify<IMultiLingualText> aNotify : this.m_aChangeNotifyList) {
                if (!aNotify.beforeChange(this).isBreak()) continue;
                return false;
            }
        }
        return true;
    }

    private void _afterChange() {
        if (this.m_aChangeNotifyList != null) {
            for (IChangeNotify<IMultiLingualText> aNotify : this.m_aChangeNotifyList) {
                aNotify.afterChange(this);
            }
        }
    }

    @Override
    @Nonnull
    public EChange addText(@Nonnull Locale aContentLocale, @Nullable String sText) {
        if (aContentLocale == null) {
            throw new NullPointerException("locale");
        }
        if (super.containsLocale(aContentLocale)) {
            return EChange.UNCHANGED;
        }
        if (!this._beforeChange()) {
            return EChange.UNCHANGED;
        }
        this.internalAddText(aContentLocale, sText);
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange setText(@Nonnull Locale aContentLocale, @Nullable String sText) {
        if (aContentLocale == null) {
            throw new NullPointerException("locale");
        }
        if (this.containsLocale(aContentLocale)) {
            String sOldText = super.internalGetText(aContentLocale);
            if (EqualsUtils.equals(sOldText, sText)) {
                return EChange.UNCHANGED;
            }
            if (!this._beforeChange()) {
                return EChange.UNCHANGED;
            }
            this.internalSetText(aContentLocale, sText);
            this._afterChange();
            return EChange.CHANGED;
        }
        if (!this._beforeChange()) {
            return EChange.UNCHANGED;
        }
        this.internalAddText(aContentLocale, sText);
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange removeText(@Nonnull Locale aContentLocale) {
        for (Locale aCurrentLocale : LocaleUtils.getCalculatedLocaleListForResolving(aContentLocale)) {
            if (!super.containsLocale(aCurrentLocale)) continue;
            if (!this._beforeChange()) {
                return EChange.UNCHANGED;
            }
            this.internalRemoveText(aCurrentLocale);
            this._afterChange();
            return EChange.CHANGED;
        }
        return EChange.UNCHANGED;
    }

    @Override
    @Nonnull
    public EChange clear() {
        if (!this.isEmpty() && this._beforeChange()) {
            this.internalClear();
            this._afterChange();
            return EChange.CHANGED;
        }
        return EChange.UNCHANGED;
    }

    @Override
    @Nonnull
    public EChange assignFrom(@Nonnull IReadonlyMultiLingualText aMLT) {
        if (aMLT == null) {
            throw new NullPointerException("mlt");
        }
        if (((Object)this.getMap()).equals(aMLT.getMap()) || !this._beforeChange()) {
            return EChange.UNCHANGED;
        }
        this.internalClear();
        for (Map.Entry<Locale, String> aEntry : aMLT.getMap().entrySet()) {
            this.internalAddText(aEntry.getKey(), aEntry.getValue());
        }
        this._afterChange();
        return EChange.CHANGED;
    }

    @Override
    public void addChangeNotifier(@Nonnull IChangeNotify<IMultiLingualText> aCallback) {
        if (aCallback == null) {
            throw new NullPointerException("callback");
        }
        if (this.m_aChangeNotifyList == null) {
            this.m_aChangeNotifyList = new ArrayList<IChangeNotify<IMultiLingualText>>();
        }
        this.m_aChangeNotifyList.add(aCallback);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Nonnull
    public static IMultiLingualText createFromMap(@Nonnull Map<String, String> aMap) {
        MultiLingualText ret = new MultiLingualText();
        for (Map.Entry<String, String> aEntry : aMap.entrySet()) {
            String sText = aEntry.getValue();
            if (sText == null) continue;
            ret.setText(LocaleCache.getLocale(aEntry.getKey()), sText);
        }
        return ret;
    }

    @Nonnull
    public static IMultiLingualText getCopyWithLocales(@Nonnull IReadonlyMultiLingualText aMLT, @Nonnull Collection<Locale> aContentLocales) {
        MultiLingualText ret = new MultiLingualText();
        for (Locale aConrentLocale : aContentLocales) {
            if (!aMLT.containsLocale(aConrentLocale)) continue;
            ret.setText(aConrentLocale, aMLT.getText(aConrentLocale));
        }
        return ret;
    }
}

