/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.collections.ContainerHelper;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EXMLIncorrectCharacterHandling {
    THROW_EXCEPTION(true, false){

        @Override
        public void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String sText, @Nonnull Set<Character> aInvalidChars) throws IllegalArgumentException {
            throw new IllegalArgumentException("XML content contains invalid character data: '" + sText + "'. Invalid chars are: " + EXMLIncorrectCharacterHandling._getAsString(aInvalidChars));
        }
    }
    ,
    WRITE_TO_FILE_NO_LOG(false, false){

        @Override
        public void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String sText, @Nonnull Set<Character> aInvalidChars) {
        }
    }
    ,
    WRITE_TO_FILE_LOG_WARNING(false, false){

        @Override
        public void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String sText, @Nonnull Set<Character> aInvalidChars) {
            s_aLogger.warn("XML content contains invalid character data (no replacement): '" + sText + "'. Invalid chars are: " + EXMLIncorrectCharacterHandling._getAsString(aInvalidChars));
        }
    }
    ,
    DO_NOT_WRITE_NO_LOG(true, true){

        @Override
        public void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String sText, @Nonnull Set<Character> aInvalidChars) {
        }
    }
    ,
    DO_NOT_WRITE_LOG_WARNING(true, true){

        @Override
        public void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String sText, @Nonnull Set<Character> aInvalidChars) {
            s_aLogger.warn("XML content contains invalid character data (will replace): '" + sText + "'. Invalid chars are: " + EXMLIncorrectCharacterHandling._getAsString(aInvalidChars));
        }
    };

    public static final EXMLIncorrectCharacterHandling DEFAULT;
    private static final Logger s_aLogger;
    private final boolean m_bIsTestRequired;
    private final boolean m_bReplaceWithNothing;

    private EXMLIncorrectCharacterHandling(boolean bIsTestRequired, boolean bReplaceWithNothing) {
        this.m_bIsTestRequired = bIsTestRequired;
        this.m_bReplaceWithNothing = bReplaceWithNothing;
    }

    public boolean isTestRequired() {
        return this.m_bIsTestRequired;
    }

    public boolean isReplaceWithNothing() {
        return this.m_bReplaceWithNothing;
    }

    @Nonnull
    private static String _getAsString(@Nonnull Set<Character> aInvalidChars) {
        if (ContainerHelper.isEmpty(aInvalidChars)) {
            return "NONE";
        }
        StringBuilder aSB = new StringBuilder();
        for (Character aChar : aInvalidChars) {
            if (aSB.length() > 0) {
                aSB.append(", ");
            }
            aSB.append("0x").append(Integer.toHexString(aChar.charValue()));
        }
        return aSB.toString();
    }

    public abstract void notifyOnInvalidXMLCharacter(@Nonnull @Nonempty String var1, @Nonnull Set<Character> var2);

    static {
        DEFAULT = WRITE_TO_FILE_NO_LOG;
        s_aLogger = LoggerFactory.getLogger(EXMLIncorrectCharacterHandling.class);
    }
}

