/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.filters;

import java.util.Dictionary;
import java.util.Hashtable;
import org.w3c.jigsaw.filters.SimpleCacheEntry;
import org.w3c.jigsaw.filters.SimpleCacheException;
import org.w3c.jigsaw.filters.SimpleCacheFilter;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.util.AsyncLRUList;
import org.w3c.util.LRUList;

final class SimpleCache {
    private SimpleCacheFilter filter;
    private int size;
    private Dictionary entries;
    private LRUList lruList;

    public SimpleCache(SimpleCacheFilter simpleCacheFilter) {
        this.filter = simpleCacheFilter;
        this.size = 0;
        this.lruList = new AsyncLRUList();
        this.entries = new Hashtable(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleCacheEntry store(Request request, Reply reply) throws SimpleCacheException {
        System.out.println("**** Storing reply in cache");
        int n = this.filter.getMaxEntries();
        if (n > 0 && this.entries.size() == n) {
            this.flushLRU();
        }
        SimpleCacheEntry simpleCacheEntry = new SimpleCacheEntry(request, reply, this.filter);
        int n2 = simpleCacheEntry.getSize();
        int n3 = this.filter.getMaxSize();
        if (n3 > 0) {
            if (n2 > n3) {
                return null;
            }
            int n4 = n3 - n2;
            while (this.entries.size() > n4 && this.flushLRU()) {
            }
        }
        SimpleCache simpleCache = this;
        synchronized (simpleCache) {
            this.size += n2;
            SimpleCacheEntry simpleCacheEntry2 = this.entries.put(simpleCacheEntry.getURL(), simpleCacheEntry);
            if (simpleCacheEntry2 != null) {
                this.lruList.remove(simpleCacheEntry2);
            }
            this.lruList.toHead(simpleCacheEntry);
        }
        return simpleCacheEntry;
    }

    public SimpleCacheEntry retrieve(Request request) {
        String string = SimpleCache.getNormalizedURL(request);
        SimpleCacheEntry simpleCacheEntry = (SimpleCacheEntry)this.entries.get(string);
        if (simpleCacheEntry == null) {
            return null;
        }
        if (!simpleCacheEntry.isFresh()) {
            this.lruList.remove(simpleCacheEntry);
            this.entries.remove(string);
        }
        this.lruList.toHead(simpleCacheEntry);
        return simpleCacheEntry;
    }

    public synchronized void remove(Request request) {
        System.out.println("**** Removing from cache");
        SimpleCacheEntry simpleCacheEntry = (SimpleCacheEntry)this.entries.remove(SimpleCache.getNormalizedURL(request));
        if (simpleCacheEntry == null) {
            return;
        }
        this.lruList.remove(simpleCacheEntry);
    }

    private final synchronized boolean flushLRU() {
        if (this.entries.size() == 0) {
            return false;
        }
        System.out.println("**** flushing LRU entry");
        SimpleCacheEntry simpleCacheEntry = (SimpleCacheEntry)this.lruList.removeTail();
        this.entries.remove(simpleCacheEntry.getURL());
        this.size -= simpleCacheEntry.getSize();
        return true;
    }

    static final String getNormalizedURL(Request request) {
        return request.getURL().getFile();
    }
}

