/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.tree.utils.xml;

import com.phloc.commons.collections.NonBlockingStack;
import com.phloc.commons.convert.IUnidirectionalConverter;
import com.phloc.commons.convert.UnidirectionalConverterIdentity;
import com.phloc.commons.hierarchy.DefaultHierarchyWalkerCallback;
import com.phloc.commons.id.ComparatorHasIDString;
import com.phloc.commons.microdom.IMicroDocument;
import com.phloc.commons.microdom.IMicroElement;
import com.phloc.commons.microdom.impl.MicroElement;
import com.phloc.commons.microdom.utils.ChildrenProviderElementWithName;
import com.phloc.commons.microdom.utils.MicroWalker;
import com.phloc.commons.parent.impl.ChildrenProviderHasChildrenSorting;
import com.phloc.commons.tree.IBasicTree;
import com.phloc.commons.tree.IBasicTreeItem;
import com.phloc.commons.tree.simple.ITreeItem;
import com.phloc.commons.tree.utils.walk.TreeWalker;
import com.phloc.commons.tree.utils.xml.IConverterMicroNodeToTreeItem;
import com.phloc.commons.tree.utils.xml.IConverterTreeItemToMicroNode;
import com.phloc.commons.tree.withid.BasicTreeWithID;
import com.phloc.commons.tree.withid.DefaultTreeWithID;
import com.phloc.commons.tree.withid.ITreeItemWithID;
import com.phloc.commons.tree.withid.unique.DefaultTreeWithGlobalUniqueID;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeXMLConverter {
    private static final String ELEMENT_ROOT = "root";
    private static final String ELEMENT_ITEM = "item";
    private static final String ATTR_ID = "id";
    private static final String ELEMENT_DATA = "data";
    private static final TreeXMLConverter s_aInstance = new TreeXMLConverter();

    private TreeXMLConverter() {
    }

    @Nonnull
    public static <VALUETYPE, ITEMTYPE extends ITreeItemWithID<String, VALUETYPE, ITEMTYPE>> IMicroElement getTreeWithStringIDAsXML(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> aTree, @Nonnull IConverterTreeItemToMicroNode<? super VALUETYPE> aConverter) {
        return TreeXMLConverter.getTreeWithIDAsXML(aTree, new ComparatorHasIDString(), UnidirectionalConverterIdentity.<String>create(), aConverter);
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>> IMicroElement getTreeWithIDAsXML(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> aTree, @Nonnull Comparator<? super ITEMTYPE> aItemComparator, final @Nonnull IUnidirectionalConverter<KEYTYPE, String> aIDConverter, final @Nonnull IConverterTreeItemToMicroNode<? super VALUETYPE> aDataConverter) {
        MicroElement eRoot = new MicroElement(ELEMENT_ROOT);
        final NonBlockingStack<MicroElement> aParents = new NonBlockingStack<MicroElement>();
        aParents.push(eRoot);
        TreeWalker.walkTree(aTree, new ChildrenProviderHasChildrenSorting<ITEMTYPE>(aItemComparator), new DefaultHierarchyWalkerCallback<ITEMTYPE>(){

            @Override
            public void onItemBeforeChildren(@Nullable ITEMTYPE aItem) {
                if (aItem != null) {
                    IMicroElement eItem = ((IMicroElement)aParents.peek()).appendElement(TreeXMLConverter.ELEMENT_ITEM);
                    eItem.setAttribute(TreeXMLConverter.ATTR_ID, (String)aIDConverter.convert(aItem.getID()));
                    IMicroElement eData = eItem.appendElement(TreeXMLConverter.ELEMENT_DATA);
                    aDataConverter.appendDataValue(eData, aItem.getData());
                    aParents.push(eItem);
                }
            }

            @Override
            public void onItemAfterChildren(@Nullable ITEMTYPE aItem) {
                if (aItem != null) {
                    aParents.pop();
                }
            }
        });
        return eRoot;
    }

    @Nonnull
    public static <VALUETYPE, ITEMTYPE extends ITreeItem<VALUETYPE, ITEMTYPE>> IMicroElement getTreeAsXML(@Nonnull IBasicTree<VALUETYPE, ITEMTYPE> aTree, @Nonnull Comparator<? super ITEMTYPE> aItemComparator, final @Nonnull IConverterTreeItemToMicroNode<? super VALUETYPE> aDataConverter) {
        MicroElement eRoot = new MicroElement(ELEMENT_ROOT);
        final NonBlockingStack<MicroElement> aParents = new NonBlockingStack<MicroElement>();
        aParents.push(eRoot);
        TreeWalker.walkTree(aTree, new ChildrenProviderHasChildrenSorting<ITEMTYPE>(aItemComparator), new DefaultHierarchyWalkerCallback<ITEMTYPE>(){

            @Override
            public void onItemBeforeChildren(@Nullable ITEMTYPE aItem) {
                if (aItem != null) {
                    IMicroElement eItem = ((IMicroElement)aParents.peek()).appendElement(TreeXMLConverter.ELEMENT_ITEM);
                    IMicroElement eData = eItem.appendElement(TreeXMLConverter.ELEMENT_DATA);
                    aDataConverter.appendDataValue(eData, aItem.getData());
                    aParents.push(eItem);
                }
            }

            @Override
            public void onItemAfterChildren(@Nullable ITEMTYPE aItem) {
                if (aItem != null) {
                    aParents.pop();
                }
            }
        });
        return eRoot;
    }

    private static <KEYTYPE, VALUETYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, VALUETYPE, ITEMTYPE>> void _getXMLAsTreeWithID(@Nonnull IMicroElement aElement, final @Nonnull IUnidirectionalConverter<String, KEYTYPE> aIDConverter, final @Nonnull IConverterMicroNodeToTreeItem<? extends VALUETYPE> aDataConverter, @Nonnull BasicTreeWithID<KEYTYPE, VALUETYPE, ITEMTYPE> aTree) {
        final NonBlockingStack<IBasicTreeItem> aParents = new NonBlockingStack<IBasicTreeItem>();
        aParents.push(aTree.getRootItem());
        MicroWalker.walkNode(aElement, new ChildrenProviderElementWithName(ELEMENT_ITEM), new DefaultHierarchyWalkerCallback<IMicroElement>(){

            @Override
            public void onItemBeforeChildren(@Nullable IMicroElement eItem) {
                if (eItem != null) {
                    Object aTreeItemID = aIDConverter.convert(eItem.getAttribute(TreeXMLConverter.ATTR_ID));
                    IMicroElement eData = eItem.getFirstChildElement(TreeXMLConverter.ELEMENT_DATA);
                    Object aTreeItemValue = aDataConverter.getAsDataValue(eData);
                    Object aTreeItem = ((ITreeItemWithID)aParents.peek()).createChildItem(aTreeItemID, aTreeItemValue);
                    aParents.push(aTreeItem);
                }
            }

            @Override
            public void onItemAfterChildren(@Nullable IMicroElement aItem) {
                if (aItem != null) {
                    aParents.pop();
                }
            }
        });
    }

    @Nonnull
    public static <VALUETYPE> DefaultTreeWithGlobalUniqueID<String, VALUETYPE> getXMLAsTreeWithUniqueStringID(@Nonnull IMicroDocument aDoc, @Nonnull IConverterMicroNodeToTreeItem<? extends VALUETYPE> aDataConverter) {
        return TreeXMLConverter.getXMLAsTreeWithUniqueStringID(aDoc.getDocumentElement(), aDataConverter);
    }

    @Nonnull
    public static <VALUETYPE> DefaultTreeWithGlobalUniqueID<String, VALUETYPE> getXMLAsTreeWithUniqueStringID(@Nonnull IMicroElement aElement, @Nonnull IConverterMicroNodeToTreeItem<? extends VALUETYPE> aDataConverter) {
        return TreeXMLConverter.getXMLAsTreeWithUniqueID(aElement, UnidirectionalConverterIdentity.create(), aDataConverter);
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> DefaultTreeWithGlobalUniqueID<KEYTYPE, VALUETYPE> getXMLAsTreeWithUniqueID(@Nonnull IMicroDocument aDoc, @Nonnull IUnidirectionalConverter<String, KEYTYPE> aIDConverter, @Nonnull IConverterMicroNodeToTreeItem<? extends VALUETYPE> aDataConverter) {
        return TreeXMLConverter.getXMLAsTreeWithUniqueID(aDoc.getDocumentElement(), aIDConverter, aDataConverter);
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> DefaultTreeWithGlobalUniqueID<KEYTYPE, VALUETYPE> getXMLAsTreeWithUniqueID(@Nonnull IMicroElement aElement, @Nonnull IUnidirectionalConverter<String, KEYTYPE> aIDConverter, @Nonnull IConverterMicroNodeToTreeItem<? extends VALUETYPE> aDataConverter) {
        DefaultTreeWithGlobalUniqueID aTree = new DefaultTreeWithGlobalUniqueID();
        TreeXMLConverter._getXMLAsTreeWithID(aElement, aIDConverter, aDataConverter, aTree);
        return aTree;
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> DefaultTreeWithID<KEYTYPE, VALUETYPE> getXMLAsTreeWithID(@Nonnull IMicroDocument aDoc, @Nonnull IUnidirectionalConverter<String, KEYTYPE> aIDConverter, @Nonnull IConverterMicroNodeToTreeItem<? extends VALUETYPE> aDataConverter) {
        return TreeXMLConverter.getXMLAsTreeWithID(aDoc.getDocumentElement(), aIDConverter, aDataConverter);
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> DefaultTreeWithID<KEYTYPE, VALUETYPE> getXMLAsTreeWithID(@Nonnull IMicroElement aElement, @Nonnull IUnidirectionalConverter<String, KEYTYPE> aIDConverter, @Nonnull IConverterMicroNodeToTreeItem<? extends VALUETYPE> aDataConverter) {
        DefaultTreeWithID aTree = new DefaultTreeWithID();
        TreeXMLConverter._getXMLAsTreeWithID(aElement, aIDConverter, aDataConverter, aTree);
        return aTree;
    }
}

