/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.graph.iterate;

import com.phloc.commons.collections.NonBlockingStack;
import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.filter.IFilter;
import com.phloc.commons.graph.IGraphNode;
import com.phloc.commons.graph.IGraphRelation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class GraphIteratorForward<VALUETYPE>
implements IIterableIterator<IGraphNode<VALUETYPE>> {
    private final NonBlockingStack<IterationNode<VALUETYPE>> m_aNodeStack = new NonBlockingStack();
    private IFilter<IGraphRelation<VALUETYPE>> m_aRelationFilter;
    private final Set<String> m_aHandledNodes = new HashSet<String>();
    private boolean m_bHasCycles = false;

    public GraphIteratorForward(@Nonnull IGraphNode<VALUETYPE> aStartNode) {
        this(aStartNode, null);
    }

    public GraphIteratorForward(@Nonnull IGraphNode<VALUETYPE> aStartNode, @Nullable IFilter<IGraphRelation<VALUETYPE>> aRelationFilter) {
        if (aStartNode == null) {
            throw new NullPointerException("startNode");
        }
        this.m_aRelationFilter = aRelationFilter;
        this.m_aNodeStack.push(IterationNode.create(aStartNode));
    }

    @Override
    public boolean hasNext() {
        return !this.m_aNodeStack.isEmpty();
    }

    @Override
    @Nullable
    public IGraphNode<VALUETYPE> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        IGraphNode<VALUETYPE> ret = this.m_aNodeStack.peek().getNode();
        this.m_aHandledNodes.add((String)ret.getID());
        boolean bFoundNewNode = false;
        while (!this.m_aNodeStack.isEmpty() && !bFoundNewNode) {
            Iterator<IGraphRelation<VALUETYPE>> itPeek = this.m_aNodeStack.peek().getOutgoingRelationIterator();
            while (itPeek.hasNext()) {
                IGraphRelation<VALUETYPE> aCurrentRelation = itPeek.next();
                if (this.m_aRelationFilter != null && !this.m_aRelationFilter.matchesFilter(aCurrentRelation)) continue;
                IGraphNode<VALUETYPE> aCurrentOutgoingNode = aCurrentRelation.getTo();
                for (IterationNode iterationNode : this.m_aNodeStack) {
                    if (iterationNode.getNode() != aCurrentOutgoingNode) continue;
                    this.m_bHasCycles = true;
                    break;
                }
                if (this.m_aHandledNodes.contains(aCurrentOutgoingNode.getID())) continue;
                this.m_aNodeStack.push(IterationNode.create(aCurrentOutgoingNode));
                bFoundNewNode = true;
                break;
            }
            if (bFoundNewNode) continue;
            this.m_aNodeStack.pop();
        }
        return ret;
    }

    public boolean hasCycles() {
        return this.m_bHasCycles;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This iterator has no remove!");
    }

    @Override
    @Nonnull
    public Iterator<IGraphNode<VALUETYPE>> iterator() {
        return this;
    }

    @Nonnull
    public static <VALUETYPE> GraphIteratorForward<VALUETYPE> create(@Nonnull IGraphNode<VALUETYPE> aStartNode) {
        return new GraphIteratorForward<VALUETYPE>(aStartNode);
    }

    @Nonnull
    public static <VALUETYPE> GraphIteratorForward<VALUETYPE> create(@Nonnull IGraphNode<VALUETYPE> aStartNode, @Nullable IFilter<IGraphRelation<VALUETYPE>> aRelationFilter) {
        return new GraphIteratorForward<VALUETYPE>(aStartNode, aRelationFilter);
    }

    private static final class IterationNode<VALUETYPE> {
        private final IGraphNode<VALUETYPE> m_aNode;
        private final Iterator<IGraphRelation<VALUETYPE>> m_aOutgoingIt;

        private IterationNode(@Nonnull IGraphNode<VALUETYPE> aNode) {
            if (aNode == null) {
                throw new NullPointerException("node");
            }
            this.m_aNode = aNode;
            this.m_aOutgoingIt = aNode.getOutgoingRelations().iterator();
        }

        @Nonnull
        public IGraphNode<VALUETYPE> getNode() {
            return this.m_aNode;
        }

        @Nonnull
        public Iterator<IGraphRelation<VALUETYPE>> getOutgoingRelationIterator() {
            return this.m_aOutgoingIt;
        }

        @Nonnull
        public static <VALUETYPE> IterationNode<VALUETYPE> create(@Nonnull IGraphNode<VALUETYPE> aNode) {
            return new IterationNode<VALUETYPE>(aNode);
        }
    }
}

