/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.idfactory;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.idfactory.GlobalIDFactory;
import com.phloc.commons.idfactory.IStringIDFactory;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;

public final class StringIDFromGlobalPersistentLongIDFactory
implements IStringIDFactory {
    private final String m_sPrefix;

    public StringIDFromGlobalPersistentLongIDFactory() {
        this("id");
    }

    public StringIDFromGlobalPersistentLongIDFactory(@Nonnull String sPrefix) {
        if (sPrefix == null) {
            throw new NullPointerException("prefix");
        }
        this.m_sPrefix = sPrefix;
    }

    @Nonnull
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Override
    @Nonnull
    public String getNewID() {
        return this.m_sPrefix + Long.toString(GlobalIDFactory.getNewPersistentLongID());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringIDFromGlobalPersistentLongIDFactory)) {
            return false;
        }
        StringIDFromGlobalPersistentLongIDFactory rhs = (StringIDFromGlobalPersistentLongIDFactory)o;
        return this.m_sPrefix.equals(rhs.m_sPrefix);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPrefix).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("prefix", this.m_sPrefix).toString();
    }
}

