/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.file;

import com.phloc.commons.equals.EqualsUtils;
import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.file.EFileIOErrorCode;
import com.phloc.commons.io.file.EFileIOOperation;
import com.phloc.commons.state.ISuccessIndicator;
import com.phloc.commons.string.ToStringGenerator;
import java.io.File;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class FileIOError
implements ISuccessIndicator,
Serializable {
    private final EFileIOOperation m_eOperation;
    private final EFileIOErrorCode m_eCode;
    private final File m_aFile1;
    private final File m_aFile2;
    private final Exception m_aException;

    public FileIOError(@Nonnull EFileIOOperation eOperation, @Nonnull EFileIOErrorCode eCode) {
        if (eOperation == null) {
            throw new NullPointerException("operation");
        }
        if (eCode == null) {
            throw new NullPointerException("errorCode");
        }
        this.m_eOperation = eOperation;
        this.m_eCode = eCode;
        this.m_aFile1 = null;
        this.m_aFile2 = null;
        this.m_aException = null;
    }

    public FileIOError(@Nonnull EFileIOOperation eOperation, @Nonnull EFileIOErrorCode eCode, @Nonnull File aFile1) {
        if (eOperation == null) {
            throw new NullPointerException("operation");
        }
        if (eCode == null) {
            throw new NullPointerException("errorCode");
        }
        if (aFile1 == null) {
            throw new NullPointerException("file1");
        }
        this.m_eOperation = eOperation;
        this.m_eCode = eCode;
        this.m_aFile1 = aFile1;
        this.m_aFile2 = null;
        this.m_aException = null;
    }

    public FileIOError(@Nonnull EFileIOOperation eOperation, @Nonnull EFileIOErrorCode eCode, @Nonnull File aFile1, @Nonnull File aFile2) {
        if (eOperation == null) {
            throw new NullPointerException("operation");
        }
        if (eCode == null) {
            throw new NullPointerException("errorCode");
        }
        if (aFile1 == null) {
            throw new NullPointerException("file1");
        }
        if (aFile2 == null) {
            throw new NullPointerException("file2");
        }
        this.m_eOperation = eOperation;
        this.m_eCode = eCode;
        this.m_aFile1 = aFile1;
        this.m_aFile2 = aFile2;
        this.m_aException = null;
    }

    public FileIOError(@Nonnull EFileIOOperation eOperation, @Nonnull EFileIOErrorCode eCode, @Nonnull Exception aException) {
        if (eOperation == null) {
            throw new NullPointerException("operation");
        }
        if (eCode == null) {
            throw new NullPointerException("errorCode");
        }
        if (aException == null) {
            throw new NullPointerException("exception");
        }
        this.m_eOperation = eOperation;
        this.m_eCode = eCode;
        this.m_aFile1 = null;
        this.m_aFile2 = null;
        this.m_aException = aException;
    }

    @Nonnull
    public EFileIOOperation getOperation() {
        return this.m_eOperation;
    }

    @Nonnull
    public EFileIOErrorCode getErrorCode() {
        return this.m_eCode;
    }

    @Override
    public boolean isSuccess() {
        return this.m_eCode.isSuccess();
    }

    @Override
    public boolean isFailure() {
        return this.m_eCode.isFailure();
    }

    @Nullable
    public File getFile1() {
        return this.m_aFile1;
    }

    @Nullable
    public File getFile2() {
        return this.m_aFile2;
    }

    @Nullable
    public Exception getException() {
        return this.m_aException;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileIOError)) {
            return false;
        }
        FileIOError rhs = (FileIOError)o;
        return this.m_eOperation == rhs.m_eOperation && this.m_eCode == rhs.m_eCode && EqualsUtils.equals(this.m_aFile1, rhs.m_aFile1) && EqualsUtils.equals(this.m_aFile2, rhs.m_aFile2) && EqualsUtils.equals(this.m_aException, rhs.m_aException);
    }

    public int hashCode() {
        return ((HashCodeGenerator)((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eOperation)).append((Enum)this.m_eCode)).append(this.m_aFile1).append(this.m_aFile2).append(this.m_aException).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("operation", this.m_eOperation).append("ecode", this.m_eCode).appendIfNotNull("file1", this.m_aFile1).appendIfNotNull("file2", this.m_aFile2).appendIfNotNull("exception", this.m_aException).toString();
    }
}

