/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.resourceprovider;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.io.IReadableResource;
import com.phloc.commons.io.IReadableResourceProvider;
import com.phloc.commons.io.resource.URLResource;
import com.phloc.commons.string.ToStringGenerator;
import java.net.MalformedURLException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class URLResourceProvider
implements IReadableResourceProvider {
    @Override
    public boolean supportsReading(@Nullable String sName) {
        return URLResource.isExplicitURLResource(sName);
    }

    @Override
    public IReadableResource getReadableResource(@Nonnull String sURL) {
        if (sURL == null) {
            throw new NullPointerException("URL");
        }
        try {
            return new URLResource(sURL);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Passed name '" + sURL + "' is not an URL!", ex);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof URLResourceProvider;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).toString();
    }
}

