/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streams;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class NonBlockingByteArrayInputStream
extends InputStream
implements Serializable {
    protected byte[] m_aBuf;
    protected int m_nPos;
    protected int m_nMark;
    protected int m_nCount;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public NonBlockingByteArrayInputStream(@Nonnull byte[] aBuf) {
        this(aBuf, 0, aBuf.length);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public NonBlockingByteArrayInputStream(byte[] aBuf, int nOfs, int nLen) {
        if (aBuf == null) {
            throw new NullPointerException("buf");
        }
        if (nOfs < 0 || nLen < 0 || nOfs + nLen > aBuf.length) {
            throw new IllegalArgumentException("ofs:" + nOfs + ";len=" + nLen + ";bufLen=" + aBuf.length);
        }
        this.m_aBuf = aBuf;
        this.m_nPos = nOfs;
        this.m_nCount = Math.min(nOfs + nLen, aBuf.length);
        this.m_nMark = nOfs;
    }

    @Override
    public int read() {
        return this.m_nPos < this.m_nCount ? this.m_aBuf[this.m_nPos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] aBuf, int nOfs, int nLen) {
        int nRealLen;
        if (aBuf == null) {
            throw new NullPointerException("buf");
        }
        if (nOfs < 0 || nLen < 0 || nOfs + nLen > aBuf.length) {
            throw new IllegalArgumentException("ofs:" + nOfs + ";len=" + nLen + ";bufLen=" + aBuf.length);
        }
        if (this.m_nPos >= this.m_nCount) {
            return -1;
        }
        int n = nRealLen = this.m_nPos + nLen > this.m_nCount ? this.m_nCount - this.m_nPos : nLen;
        if (nRealLen <= 0) {
            return 0;
        }
        System.arraycopy(this.m_aBuf, this.m_nPos, aBuf, nOfs, nRealLen);
        this.m_nPos += nRealLen;
        return nRealLen;
    }

    @Override
    public long skip(long n) {
        long nSkip;
        long l = nSkip = (long)this.m_nPos + n > (long)this.m_nCount ? (long)(this.m_nCount - this.m_nPos) : n;
        if (nSkip <= 0L) {
            return 0L;
        }
        this.m_nPos = (int)((long)this.m_nPos + nSkip);
        return nSkip;
    }

    @Override
    public int available() {
        return this.m_nCount - this.m_nPos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readAheadLimit) {
        this.m_nMark = this.m_nPos;
    }

    @Override
    public synchronized void reset() {
        this.m_nPos = this.m_nMark;
    }

    @Override
    public void close() {
    }

    @Nonnegative
    public int getPosition() {
        return this.m_nPos;
    }
}

