/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.mutable;

import com.phloc.commons.hash.HashCodeGenerator;
import com.phloc.commons.mutable.IMutableInteger;
import com.phloc.commons.state.EChange;
import com.phloc.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MutableShort
extends Number
implements IMutableInteger<MutableShort> {
    public static final short DEFAULT_VALUE = 0;
    private short m_nValue;

    public MutableShort() {
        this(0);
    }

    public MutableShort(int nValue) {
        this((short)nValue);
    }

    public MutableShort(@Nonnull Short aValue) {
        this((short)aValue);
    }

    public MutableShort(short nValue) {
        this.m_nValue = nValue;
    }

    @Override
    public short shortValue() {
        return this.m_nValue;
    }

    @Nonnull
    public Short getAsShort() {
        return this.m_nValue;
    }

    @Override
    public float floatValue() {
        return this.m_nValue;
    }

    @Override
    public double doubleValue() {
        return this.m_nValue;
    }

    @Override
    public int intValue() {
        return this.m_nValue;
    }

    @Override
    public long longValue() {
        return this.m_nValue;
    }

    public int inc() {
        return this.inc(1);
    }

    public int inc(int nDelta) {
        this.m_nValue = (short)(this.m_nValue + nDelta);
        return this.m_nValue;
    }

    public int dec() {
        return this.inc(-1);
    }

    public int dec(int nDelta) {
        return this.inc(-nDelta);
    }

    @Nonnull
    public EChange set(int nValue) {
        return this.set((short)nValue);
    }

    @Nonnull
    public EChange set(short nValue) {
        if (this.m_nValue == nValue) {
            return EChange.UNCHANGED;
        }
        this.m_nValue = nValue;
        return EChange.CHANGED;
    }

    @Override
    public boolean is0() {
        return this.m_nValue == 0;
    }

    @Override
    public boolean isNot0() {
        return this.m_nValue != 0;
    }

    @Override
    public boolean isSmaller0() {
        return this.m_nValue < 0;
    }

    @Override
    public boolean isSmallerOrEqual0() {
        return this.m_nValue <= 0;
    }

    @Override
    public boolean isGreater0() {
        return this.m_nValue > 0;
    }

    @Override
    public boolean isGreaterOrEqual0() {
        return this.m_nValue >= 0;
    }

    @Override
    public boolean isEven() {
        return this.m_nValue % 2 == 0;
    }

    @Override
    public boolean isOdd() {
        return this.m_nValue % 2 != 0;
    }

    @Override
    public int compareTo(MutableShort rhs) {
        return this.m_nValue == rhs.m_nValue ? 0 : (this.m_nValue < rhs.m_nValue ? -1 : 1);
    }

    @Override
    @Nonnull
    public MutableShort getClone() {
        return new MutableShort(this.m_nValue);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MutableShort)) {
            return false;
        }
        MutableShort rhs = (MutableShort)o;
        return this.m_nValue == rhs.m_nValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("value", this.m_nValue).toString();
    }
}

