/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.system;

import com.phloc.commons.SystemProperties;
import javax.annotation.Nonnull;

public enum EJVMVendor {
    SUN_CLIENT{

        @Override
        protected boolean determineIfItIsCurrentJVMVendor() {
            boolean bIsSunJVM = EJVMVendor.SUN_VENDOR_NAME.equals(SystemProperties.getJavaVmVendor());
            return bIsSunJVM && !EJVMVendor._isSunServerJVM();
        }
    }
    ,
    SUN_SERVER{

        @Override
        protected boolean determineIfItIsCurrentJVMVendor() {
            boolean bIsSunJVM = EJVMVendor.SUN_VENDOR_NAME.equals(SystemProperties.getJavaVmVendor());
            return bIsSunJVM && EJVMVendor._isSunServerJVM();
        }
    }
    ,
    UNKNOWN{

        @Override
        protected boolean determineIfItIsCurrentJVMVendor() {
            return false;
        }
    };

    private static final String SUN_VENDOR_NAME = "Sun Microsystems Inc.";
    private static final String SYSPROP_JAVA_VM_NAME = "java.vm.name";
    private static volatile EJVMVendor s_aInstance;
    private final boolean m_bIsIt = this.determineIfItIsCurrentJVMVendor();

    private static boolean _isSunServerJVM() {
        String sVM = SystemProperties.getPropertyValue(SYSPROP_JAVA_VM_NAME);
        if ("Java HotSpot(TM) Server VM".equals(sVM)) {
            return true;
        }
        return "Java HotSpot(TM) 64-Bit Server VM".equals(sVM);
    }

    protected abstract boolean determineIfItIsCurrentJVMVendor();

    public final boolean isJVMVendor() {
        return this.m_bIsIt;
    }

    public final boolean isSun() {
        return this == SUN_CLIENT || this == SUN_SERVER;
    }

    @Nonnull
    public static EJVMVendor getCurrentVendor() {
        EJVMVendor ret = s_aInstance;
        if (ret == null) {
            for (EJVMVendor eVendor : EJVMVendor.values()) {
                if (!eVendor.isJVMVendor()) continue;
                ret = eVendor;
                break;
            }
            if (ret == null) {
                ret = UNKNOWN;
            }
            s_aInstance = ret;
        }
        return ret;
    }

    static {
        s_aInstance = null;
    }
}

