/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigsaw.filters;

import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.zip.GZIPOutputStream;
import org.w3c.jigsaw.filters.GZIPDataMover;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.ResourceFilter;
import org.w3c.tools.resources.StringArrayAttribute;
import org.w3c.www.mime.MimeType;

public class GZIPFilter
extends ResourceFilter {
    protected static int ATTR_MIME_TYPES = -1;
    protected MimeType[] types = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(int n, Object object) {
        super.setValue(n, object);
        if (n == ATTR_MIME_TYPES) {
            GZIPFilter gZIPFilter = this;
            synchronized (gZIPFilter) {
                this.types = null;
            }
        }
    }

    public synchronized MimeType[] getMimeTypes() {
        if (this.types == null) {
            String[] stringArray = (String[])this.getValue(ATTR_MIME_TYPES, null);
            if (stringArray == null) {
                return null;
            }
            this.types = new MimeType[stringArray.length];
            for (int i = 0; i < this.types.length; ++i) {
                try {
                    this.types[i] = new MimeType(stringArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    this.types[i] = null;
                }
            }
        }
        return this.types;
    }

    public ReplyInterface outgoingFilter(RequestInterface requestInterface, ReplyInterface replyInterface) throws ProtocolException {
        Request request = (Request)requestInterface;
        Reply reply = (Reply)replyInterface;
        if (!reply.hasStream()) {
            return null;
        }
        if (reply.getContentEncoding() != null) {
            return null;
        }
        MimeType[] mimeTypeArray = this.getMimeTypes();
        boolean bl = false;
        if (mimeTypeArray != null) {
            for (int i = 0; i < mimeTypeArray.length; ++i) {
                if (mimeTypeArray[i] == null || mimeTypeArray[i].match(reply.getContentType()) <= 0) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            return null;
        }
        try {
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
            new GZIPDataMover(reply.openStream(), new GZIPOutputStream(pipedOutputStream));
            reply.addContentEncoding("gzip");
            reply.setContentLength(-1);
            reply.setStream(pipedInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    static {
        Class<?> clazz = null;
        StringArrayAttribute stringArrayAttribute = null;
        try {
            clazz = Class.forName("org.w3c.jigsaw.filters.GZIPFilter");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        stringArrayAttribute = new StringArrayAttribute("mime-types", null, 2);
        ATTR_MIME_TYPES = AttributeRegistry.registerAttribute(clazz, stringArrayAttribute);
    }
}

