/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.collections;

import com.phloc.commons.annotations.ReturnsImmutableObject;
import com.phloc.commons.annotations.ReturnsMutableCopy;
import com.phloc.commons.annotations.ReturnsMutableObject;
import com.phloc.commons.collections.ArrayHelper;
import com.phloc.commons.collections.EmptySortedSet;
import com.phloc.commons.collections.NonBlockingStack;
import com.phloc.commons.collections.iterate.CombinedEnumeration;
import com.phloc.commons.collections.iterate.CombinedIterator;
import com.phloc.commons.collections.iterate.EmptyEnumeration;
import com.phloc.commons.collections.iterate.EmptyIterator;
import com.phloc.commons.collections.iterate.EnumerationFromIterator;
import com.phloc.commons.collections.iterate.IIterableIterator;
import com.phloc.commons.collections.iterate.IterableIteratorFromEnumeration;
import com.phloc.commons.collections.iterate.ReverseListIterator;
import com.phloc.commons.collections.multimap.IMultiMap;
import com.phloc.commons.collections.multimap.IMultiMapSetBased;
import com.phloc.commons.collections.multimap.MultiHashMapHashSetBased;
import com.phloc.commons.compare.ComparatorComparableNullAware;
import com.phloc.commons.compare.ComparatorUtils;
import com.phloc.commons.compare.ESortOrder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ContainerHelper {
    private static final ContainerHelper s_aInstance = new ContainerHelper();

    private ContainerHelper() {
    }

    @Nonnull
    public static <ELEMENTTYPE> List<? extends ELEMENTTYPE> getNotNull(List<? extends ELEMENTTYPE> aCollection) {
        return aCollection == null ? ContainerHelper.newList() : aCollection;
    }

    @Nonnull
    public static <ELEMENTTYPE> Set<? extends ELEMENTTYPE> getNotNull(Set<? extends ELEMENTTYPE> aCollection) {
        return aCollection == null ? ContainerHelper.newSet() : aCollection;
    }

    @Nonnull
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<? extends ELEMENTTYPE> getNotNull(SortedSet<? extends ELEMENTTYPE> aCollection) {
        return aCollection == null ? ContainerHelper.newSortedSet() : aCollection;
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> Map<? extends KEYTYPE, ? extends VALUETYPE> getNotNull(Map<? extends KEYTYPE, ? extends VALUETYPE> aCollection) {
        return aCollection == null ? ContainerHelper.newMap() : aCollection;
    }

    @Nonnull
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<? extends KEYTYPE, ? extends VALUETYPE> getNotNull(SortedMap<? extends KEYTYPE, ? extends VALUETYPE> aCollection) {
        return aCollection == null ? ContainerHelper.newSortedMap() : aCollection;
    }

    @Nullable
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Collection<ELEMENTTYPE> makeUnmodifiable(@Nullable Collection<? extends ELEMENTTYPE> aCollection) {
        return aCollection == null ? null : Collections.unmodifiableCollection(aCollection);
    }

    @Nullable
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> makeUnmodifiable(@Nullable List<? extends ELEMENTTYPE> aCollection) {
        return aCollection == null ? null : Collections.unmodifiableList(aCollection);
    }

    @Nullable
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> makeUnmodifiable(@Nullable Set<? extends ELEMENTTYPE> aCollection) {
        return aCollection == null ? null : Collections.unmodifiableSet(aCollection);
    }

    @Nullable
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> makeUnmodifiable(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> aCollection) {
        return aCollection == null ? null : Collections.unmodifiableMap(aCollection);
    }

    @Nullable
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> makeUnmodifiable(@Nullable SortedSet<ELEMENTTYPE> aCollection) {
        return aCollection == null ? null : Collections.unmodifiableSortedSet(aCollection);
    }

    @Nullable
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> makeUnmodifiable(@Nullable SortedMap<KEYTYPE, ? extends VALUETYPE> aCollection) {
        return aCollection == null ? null : Collections.unmodifiableSortedMap(aCollection);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Collection<ELEMENTTYPE> makeUnmodifiableNotNull(@Nullable Collection<? extends ELEMENTTYPE> aCollection) {
        return aCollection == null ? ContainerHelper.newUnmodifiableList() : Collections.unmodifiableCollection(aCollection);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> makeUnmodifiableNotNull(@Nullable List<? extends ELEMENTTYPE> aCollection) {
        return aCollection == null ? ContainerHelper.newUnmodifiableList() : Collections.unmodifiableList(aCollection);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> makeUnmodifiableNotNull(@Nullable Set<? extends ELEMENTTYPE> aCollection) {
        return aCollection == null ? ContainerHelper.newUnmodifiableSet() : Collections.unmodifiableSet(aCollection);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> makeUnmodifiableNotNull(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> aCollection) {
        return aCollection == null ? ContainerHelper.newUnmodifiableMap() : Collections.unmodifiableMap(aCollection);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> makeUnmodifiableNotNull(@Nullable SortedSet<ELEMENTTYPE> aCollection) {
        return aCollection == null ? ContainerHelper.newUnmodifiableSortedSet() : Collections.unmodifiableSortedSet(aCollection);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> makeUnmodifiableNotNull(@Nullable SortedMap<KEYTYPE, ? extends VALUETYPE> aCollection) {
        return Collections.unmodifiableSortedMap(aCollection == null ? ContainerHelper.newSortedMap() : aCollection);
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> getDifference(@Nullable Collection<? extends ELEMENTTYPE> aCont1, @Nullable Collection<? extends ELEMENTTYPE> aCont2) {
        if (ContainerHelper.isEmpty(aCont1)) {
            return ContainerHelper.newSet();
        }
        if (ContainerHelper.isEmpty(aCont2)) {
            return ContainerHelper.newSet(aCont1);
        }
        Set<ELEMENTTYPE> ret = ContainerHelper.newSet(aCont1);
        ret.removeAll(aCont2);
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> getIntersected(@Nullable Collection<? extends ELEMENTTYPE> aCont1, @Nullable Collection<? extends ELEMENTTYPE> aCont2) {
        if (ContainerHelper.isEmpty(aCont1)) {
            return ContainerHelper.newSet();
        }
        if (ContainerHelper.isEmpty(aCont2)) {
            return ContainerHelper.newSet();
        }
        Set<ELEMENTTYPE> ret = ContainerHelper.newSet(aCont1);
        ret.retainAll(aCont2);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newMap() {
        return new HashMap(0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newMap(@Nullable KEYTYPE aKey, @Nullable VALUETYPE aValue) {
        HashMap<KEYTYPE, VALUETYPE> ret = new HashMap<KEYTYPE, VALUETYPE>(1);
        ret.put(aKey, aValue);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Map<ELEMENTTYPE, ELEMENTTYPE> newMap(ELEMENTTYPE ... aValues) {
        if (ArrayHelper.isEmpty(aValues)) {
            return new HashMap(0);
        }
        if (aValues.length % 2 != 0) {
            throw new IllegalArgumentException("The passed array needs an even number of elements!");
        }
        HashMap<ELEMENTTYPE, ELEMENTTYPE> ret = new HashMap<ELEMENTTYPE, ELEMENTTYPE>(aValues.length / 2);
        for (int i = 0; i < aValues.length; i += 2) {
            ret.put(aValues[i], aValues[i + 1]);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newMap(@Nullable KEYTYPE[] aKeys, @Nullable VALUETYPE[] aValues) {
        if (ArrayHelper.isEmpty(aKeys) && ArrayHelper.isEmpty(aValues)) {
            return new HashMap(0);
        }
        if (ArrayHelper.getSize(aKeys) != ArrayHelper.getSize(aValues)) {
            throw new IllegalArgumentException("The passed arrays have different length!");
        }
        HashMap<KEYTYPE, VALUETYPE> ret = new HashMap<KEYTYPE, VALUETYPE>(aKeys.length);
        for (int i = 0; i < aKeys.length; ++i) {
            ret.put(aKeys[i], aValues[i]);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newMap(@Nullable Collection<? extends KEYTYPE> aKeys, @Nullable Collection<? extends VALUETYPE> aValues) {
        if (ContainerHelper.isEmpty(aKeys) && ContainerHelper.isEmpty(aValues)) {
            return new HashMap(0);
        }
        if (ContainerHelper.getSize(aKeys) != ContainerHelper.getSize(aValues)) {
            throw new IllegalArgumentException("Number of keys is different from number of values");
        }
        HashMap<KEYTYPE, VALUETYPE> ret = new HashMap<KEYTYPE, VALUETYPE>(aKeys.size());
        Iterator<KEYTYPE> itk = aKeys.iterator();
        Iterator<VALUETYPE> itv = aValues.iterator();
        while (itk.hasNext()) {
            ret.put(itk.next(), itv.next());
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> aMap) {
        if (ContainerHelper.isEmpty(aMap)) {
            return new HashMap(0);
        }
        return new HashMap<KEYTYPE, VALUETYPE>(aMap);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> aCollection) {
        if (ContainerHelper.isEmpty(aCollection)) {
            return new HashMap(0);
        }
        HashMap<KEYTYPE, VALUETYPE> ret = new HashMap<KEYTYPE, VALUETYPE>(aCollection.size());
        for (Map.Entry<KEYTYPE, VALUETYPE> aEntry : aCollection) {
            ret.put(aEntry.getKey(), aEntry.getValue());
        }
        return ret;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableMap() {
        return Collections.emptyMap();
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableMap(@Nullable KEYTYPE aKey, @Nullable VALUETYPE aValue) {
        return Collections.singletonMap(aKey, aValue);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Map<ELEMENTTYPE, ELEMENTTYPE> newUnmodifiableMap(ELEMENTTYPE ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newMap(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableMap(@Nullable KEYTYPE[] aKeys, @Nullable VALUETYPE[] aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newMap(aKeys, aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableMap(@Nullable Collection<? extends KEYTYPE> aKeys, @Nullable Collection<? extends VALUETYPE> aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newMap(aKeys, aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> aMap) {
        return ContainerHelper.makeUnmodifiable(aMap);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> aCollection) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newMap(aCollection));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newOrderedMap() {
        return new LinkedHashMap(0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable KEYTYPE aKey, @Nullable VALUETYPE aValue) {
        LinkedHashMap<KEYTYPE, VALUETYPE> ret = new LinkedHashMap<KEYTYPE, VALUETYPE>(1);
        ret.put(aKey, aValue);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Map<ELEMENTTYPE, ELEMENTTYPE> newOrderedMap(ELEMENTTYPE ... aValues) {
        if (ArrayHelper.isEmpty(aValues)) {
            return new LinkedHashMap(0);
        }
        if (aValues.length % 2 != 0) {
            throw new IllegalArgumentException("The passed array needs an even number of elements!");
        }
        LinkedHashMap<ELEMENTTYPE, ELEMENTTYPE> ret = new LinkedHashMap<ELEMENTTYPE, ELEMENTTYPE>(aValues.length / 2);
        for (int i = 0; i < aValues.length; i += 2) {
            ret.put(aValues[i], aValues[i + 1]);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable KEYTYPE[] aKeys, @Nullable VALUETYPE[] aValues) {
        if (ArrayHelper.isEmpty(aKeys) && ArrayHelper.isEmpty(aValues)) {
            return new LinkedHashMap(0);
        }
        if (ArrayHelper.getSize(aKeys) != ArrayHelper.getSize(aValues)) {
            throw new IllegalArgumentException("The passed arrays have different length!");
        }
        LinkedHashMap<KEYTYPE, VALUETYPE> ret = new LinkedHashMap<KEYTYPE, VALUETYPE>(aKeys.length);
        for (int i = 0; i < aKeys.length; ++i) {
            ret.put(aKeys[i], aValues[i]);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable Collection<? extends KEYTYPE> aKeys, @Nullable Collection<? extends VALUETYPE> aValues) {
        if (ContainerHelper.isEmpty(aKeys) && ContainerHelper.isEmpty(aValues)) {
            return new LinkedHashMap(0);
        }
        if (ContainerHelper.getSize(aKeys) != ContainerHelper.getSize(aValues)) {
            throw new IllegalArgumentException("Number of keys is different from number of values");
        }
        LinkedHashMap<KEYTYPE, VALUETYPE> ret = new LinkedHashMap<KEYTYPE, VALUETYPE>(aKeys.size());
        Iterator<KEYTYPE> itk = aKeys.iterator();
        Iterator<VALUETYPE> itv = aValues.iterator();
        while (itk.hasNext()) {
            ret.put(itk.next(), itv.next());
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> aMap) {
        if (ContainerHelper.isEmpty(aMap)) {
            return new LinkedHashMap(0);
        }
        return new LinkedHashMap<KEYTYPE, VALUETYPE>(aMap);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newOrderedMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> aCollection) {
        if (ContainerHelper.isEmpty(aCollection)) {
            return new LinkedHashMap(0);
        }
        LinkedHashMap<KEYTYPE, VALUETYPE> ret = new LinkedHashMap<KEYTYPE, VALUETYPE>(aCollection.size());
        for (Map.Entry<KEYTYPE, VALUETYPE> aEntry : aCollection) {
            ret.put(aEntry.getKey(), aEntry.getValue());
        }
        return ret;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableOrderedMap() {
        return Collections.emptyMap();
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableOrderedMap(@Nullable KEYTYPE aKey, @Nullable VALUETYPE aValue) {
        return Collections.singletonMap(aKey, aValue);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Map<ELEMENTTYPE, ELEMENTTYPE> newUnmodifiableOrderedMap(ELEMENTTYPE ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedMap(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableOrderedMap(@Nullable KEYTYPE[] aKeys, @Nullable VALUETYPE[] aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedMap(aKeys, aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableOrderedMap(@Nullable Collection<? extends KEYTYPE> aKeys, @Nullable Collection<? extends VALUETYPE> aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedMap(aKeys, aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableOrderedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> aOrderedMap) {
        return ContainerHelper.makeUnmodifiable(aOrderedMap);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> newUnmodifiableOrderedMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> aCollection) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedMap(aCollection));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> TreeMap<KEYTYPE, VALUETYPE> newSortedMap() {
        return new TreeMap(new ComparatorComparableNullAware());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> TreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable KEYTYPE aKey, @Nullable VALUETYPE aValue) {
        TreeMap ret = new TreeMap(new ComparatorComparableNullAware());
        ret.put(aKey, aValue);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeMap<ELEMENTTYPE, ELEMENTTYPE> newSortedMap(ELEMENTTYPE ... aValues) {
        if (ArrayHelper.isEmpty(aValues)) {
            return new TreeMap(new ComparatorComparableNullAware());
        }
        if (aValues.length % 2 != 0) {
            throw new IllegalArgumentException("The passed array needs an even number of elements!");
        }
        TreeMap ret = new TreeMap(new ComparatorComparableNullAware());
        for (int i = 0; i < aValues.length; i += 2) {
            ret.put(aValues[i], aValues[i + 1]);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> TreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable KEYTYPE[] aKeys, @Nullable VALUETYPE[] aValues) {
        if (ArrayHelper.isEmpty(aKeys) && ArrayHelper.isEmpty(aValues)) {
            return new TreeMap(new ComparatorComparableNullAware());
        }
        if (ArrayHelper.getSize(aKeys) != ArrayHelper.getSize(aValues)) {
            throw new IllegalArgumentException("The passed arrays have different length!");
        }
        TreeMap ret = new TreeMap(new ComparatorComparableNullAware());
        for (int i = 0; i < aKeys.length; ++i) {
            ret.put(aKeys[i], aValues[i]);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> TreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable Collection<? extends KEYTYPE> aKeys, @Nullable Collection<? extends VALUETYPE> aValues) {
        if (ContainerHelper.isEmpty(aKeys) && ContainerHelper.isEmpty(aValues)) {
            return new TreeMap(new ComparatorComparableNullAware());
        }
        if (ContainerHelper.getSize(aKeys) != ContainerHelper.getSize(aValues)) {
            throw new IllegalArgumentException("Number of keys is different from number of values");
        }
        TreeMap ret = new TreeMap(new ComparatorComparableNullAware());
        Iterator<KEYTYPE> itk = aKeys.iterator();
        Iterator<VALUETYPE> itv = aValues.iterator();
        while (itk.hasNext()) {
            ret.put(itk.next(), itv.next());
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> TreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> aMap) {
        if (ContainerHelper.isEmpty(aMap)) {
            return new TreeMap(new ComparatorComparableNullAware());
        }
        TreeMap ret = new TreeMap(new ComparatorComparableNullAware());
        ret.putAll(aMap);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> TreeMap<KEYTYPE, VALUETYPE> newSortedMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> aCollection) {
        if (ContainerHelper.isEmpty(aCollection)) {
            return new TreeMap(new ComparatorComparableNullAware());
        }
        TreeMap ret = new TreeMap(new ComparatorComparableNullAware());
        for (Map.Entry<KEYTYPE, VALUETYPE> aEntry : aCollection) {
            ret.put(aEntry.getKey(), aEntry.getValue());
        }
        return ret;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> newUnmodifiableSortedMap() {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.<KEYTYPE, VALUETYPE>newSortedMap());
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> newUnmodifiableSortedMap(@Nullable KEYTYPE aKey, @Nullable VALUETYPE aValue) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedMap(aKey, aValue));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedMap<ELEMENTTYPE, ELEMENTTYPE> newUnmodifiableSortedMap(ELEMENTTYPE ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedMap(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> newUnmodifiableSortedMap(@Nullable KEYTYPE[] aKeys, @Nullable VALUETYPE[] aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedMap(aKeys, aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> newUnmodifiableSortedMap(@Nullable Collection<? extends KEYTYPE> aKeys, @Nullable Collection<? extends VALUETYPE> aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedMap(aKeys, aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> newUnmodifiableSortedMap(@Nullable SortedMap<KEYTYPE, ? extends VALUETYPE> aMap) {
        return ContainerHelper.makeUnmodifiable(aMap);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> SortedMap<KEYTYPE, VALUETYPE> newUnmodifiableSortedMap(@Nullable Collection<? extends Map.Entry<KEYTYPE, VALUETYPE>> aCollection) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedMap(aCollection));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newSet() {
        return new HashSet(0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newSet(@Nullable ELEMENTTYPE aValue) {
        HashSet<ELEMENTTYPE> ret = new HashSet<ELEMENTTYPE>(1);
        ret.add(aValue);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newSet(ELEMENTTYPE ... aValues) {
        if (ArrayHelper.isEmpty(aValues)) {
            return new HashSet(0);
        }
        HashSet<ELEMENTTYPE> ret = new HashSet<ELEMENTTYPE>(aValues.length);
        for (ELEMENTTYPE aValue : aValues) {
            ret.add(aValue);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newSet(@Nullable Iterable<? extends ELEMENTTYPE> aCont) {
        HashSet<ELEMENTTYPE> ret = new HashSet<ELEMENTTYPE>();
        if (aCont != null) {
            for (ELEMENTTYPE aValue : aCont) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newSet(@Nullable Collection<? extends ELEMENTTYPE> aCont) {
        if (ContainerHelper.isEmpty(aCont)) {
            return new HashSet(0);
        }
        return new HashSet<ELEMENTTYPE>(aCont);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newSet(@Nullable Iterator<? extends ELEMENTTYPE> aIter) {
        HashSet<ELEMENTTYPE> ret = new HashSet<ELEMENTTYPE>();
        if (aIter != null) {
            while (aIter.hasNext()) {
                ret.add(aIter.next());
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newSet(@Nullable IIterableIterator<? extends ELEMENTTYPE> aIter) {
        if (aIter == null) {
            return new HashSet(0);
        }
        return ContainerHelper.newSet(aIter.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newSet(@Nullable Enumeration<? extends ELEMENTTYPE> aEnum) {
        HashSet<ELEMENTTYPE> ret = new HashSet<ELEMENTTYPE>();
        if (aEnum != null) {
            while (aEnum.hasMoreElements()) {
                ret.add(aEnum.nextElement());
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Boolean> newBooleanSet(boolean ... aValues) {
        HashSet<Boolean> ret = new HashSet<Boolean>();
        if (aValues != null) {
            for (boolean aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Byte> newByteSet(byte ... aValues) {
        HashSet<Byte> ret = new HashSet<Byte>();
        if (aValues != null) {
            for (byte aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Character> newCharSet(char ... aValues) {
        HashSet<Character> ret = new HashSet<Character>();
        if (aValues != null) {
            for (char aValue : aValues) {
                ret.add(Character.valueOf(aValue));
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Double> newDoubleSet(double ... aValues) {
        HashSet<Double> ret = new HashSet<Double>();
        if (aValues != null) {
            for (double aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Float> newFloatSet(float ... aValues) {
        HashSet<Float> ret = new HashSet<Float>();
        if (aValues != null) {
            for (float aValue : aValues) {
                ret.add(Float.valueOf(aValue));
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Integer> newIntSet(int ... aValues) {
        HashSet<Integer> ret = new HashSet<Integer>();
        if (aValues != null) {
            for (int aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Long> newLongSet(long ... aValues) {
        HashSet<Long> ret = new HashSet<Long>();
        if (aValues != null) {
            for (long aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Short> newShortSet(short ... aValues) {
        HashSet<Short> ret = new HashSet<Short>();
        if (aValues != null) {
            for (short aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableSet() {
        return Collections.emptySet();
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableSet(@Nullable ELEMENTTYPE aValue) {
        return Collections.singleton(aValue);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableSet(ELEMENTTYPE ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableSet(@Nullable Iterable<? extends ELEMENTTYPE> aCont) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSet(aCont));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableSet(@Nullable Collection<? extends ELEMENTTYPE> aCont) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSet(aCont));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableSet(@Nullable Iterator<? extends ELEMENTTYPE> aIter) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSet(aIter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableSet(@Nullable IIterableIterator<? extends ELEMENTTYPE> aIter) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSet(aIter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableSet(@Nullable Enumeration<? extends ELEMENTTYPE> aEnum) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSet(aEnum));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Boolean> newUnmodifiableBooleanSet(boolean ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newBooleanSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Byte> newUnmodifiableByteSet(byte ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newByteSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Character> newUnmodifiableCharSet(char ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newCharSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Double> newUnmodifiableDoubleSet(double ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newDoubleSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Float> newUnmodifiableFloatSet(float ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newFloatSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Integer> newUnmodifiableIntSet(int ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newIntSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Long> newUnmodifiableLongSet(long ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newLongSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Short> newUnmodifiableShortSet(short ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newShortSet(aValues));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeSet<ELEMENTTYPE> newSortedSet() {
        return new TreeSet(new ComparatorComparableNullAware());
    }

    @Nonnull
    @ReturnsMutableCopy
    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="When using the constructor with the Comparator it works with null values!")
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeSet<ELEMENTTYPE> newSortedSet(@Nullable ELEMENTTYPE aValue) {
        TreeSet ret = new TreeSet(new ComparatorComparableNullAware());
        ret.add(aValue);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeSet<ELEMENTTYPE> newSortedSet(ELEMENTTYPE ... aValues) {
        TreeSet ret = new TreeSet(new ComparatorComparableNullAware());
        if (!ArrayHelper.isEmpty(aValues)) {
            for (ELEMENTTYPE aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeSet<ELEMENTTYPE> newSortedSet(@Nullable Iterable<? extends ELEMENTTYPE> aCont) {
        TreeSet ret = new TreeSet(new ComparatorComparableNullAware());
        if (aCont != null) {
            for (Comparable aValue : aCont) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeSet<ELEMENTTYPE> newSortedSet(@Nullable Collection<? extends ELEMENTTYPE> aCont) {
        TreeSet ret = new TreeSet(new ComparatorComparableNullAware());
        if (ContainerHelper.isNotEmpty(aCont)) {
            ret.addAll(aCont);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeSet<ELEMENTTYPE> newSortedSet(@Nullable Iterator<? extends ELEMENTTYPE> aIter) {
        TreeSet ret = new TreeSet(new ComparatorComparableNullAware());
        if (aIter != null) {
            while (aIter.hasNext()) {
                ret.add(aIter.next());
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeSet<ELEMENTTYPE> newSortedSet(@Nullable IIterableIterator<? extends ELEMENTTYPE> aIter) {
        if (aIter == null) {
            return new TreeSet(new ComparatorComparableNullAware());
        }
        return ContainerHelper.newSortedSet(aIter.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> TreeSet<ELEMENTTYPE> newSortedSet(@Nullable Enumeration<? extends ELEMENTTYPE> aEnum) {
        TreeSet ret = new TreeSet(new ComparatorComparableNullAware());
        if (aEnum != null) {
            while (aEnum.hasMoreElements()) {
                ret.add(aEnum.nextElement());
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<Boolean> newBooleanSortedSet(boolean ... aValues) {
        TreeSet<Boolean> ret = new TreeSet<Boolean>(new ComparatorComparableNullAware());
        if (aValues != null) {
            for (boolean aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<Byte> newByteSortedSet(byte ... aValues) {
        TreeSet<Byte> ret = new TreeSet<Byte>(new ComparatorComparableNullAware());
        if (aValues != null) {
            for (byte aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<Character> newCharSortedSet(char ... aValues) {
        TreeSet<Character> ret = new TreeSet<Character>(new ComparatorComparableNullAware());
        if (aValues != null) {
            for (char aValue : aValues) {
                ret.add(Character.valueOf(aValue));
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<Double> newDoubleSortedSet(double ... aValues) {
        TreeSet<Double> ret = new TreeSet<Double>(new ComparatorComparableNullAware());
        if (aValues != null) {
            for (double aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<Float> newFloatSortedSet(float ... aValues) {
        TreeSet<Float> ret = new TreeSet<Float>(new ComparatorComparableNullAware());
        if (aValues != null) {
            for (float aValue : aValues) {
                ret.add(Float.valueOf(aValue));
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<Integer> newIntSortedSet(int ... aValues) {
        TreeSet<Integer> ret = new TreeSet<Integer>(new ComparatorComparableNullAware());
        if (aValues != null) {
            for (int aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<Long> newLongSortedSet(long ... aValues) {
        TreeSet<Long> ret = new TreeSet<Long>(new ComparatorComparableNullAware());
        if (aValues != null) {
            for (long aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static TreeSet<Short> newShortSortedSet(short ... aValues) {
        TreeSet<Short> ret = new TreeSet<Short>(new ComparatorComparableNullAware());
        if (aValues != null) {
            for (short aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> SortedSet<ELEMENTTYPE> newUnmodifiableSortedSet() {
        return EmptySortedSet.getInstance();
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> newUnmodifiableSortedSet(@Nullable ELEMENTTYPE aValue) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedSet(aValue));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> newUnmodifiableSortedSet(ELEMENTTYPE ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> newUnmodifiableSortedSet(@Nullable Iterable<? extends ELEMENTTYPE> aCont) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedSet(aCont));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> newUnmodifiableSortedSet(@Nullable Collection<? extends ELEMENTTYPE> aCont) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedSet(aCont));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> newUnmodifiableSortedSet(@Nullable Iterator<? extends ELEMENTTYPE> aIter) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedSet(aIter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> newUnmodifiableSortedSet(@Nullable IIterableIterator<? extends ELEMENTTYPE> aIter) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedSet(aIter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> SortedSet<ELEMENTTYPE> newUnmodifiableSortedSet(@Nullable Enumeration<? extends ELEMENTTYPE> aEnum) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newSortedSet(aEnum));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedSet<Boolean> newUnmodifiableBooleanSortedSet(boolean ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newBooleanSortedSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedSet<Byte> newUnmodifiableByteSortedSet(byte ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newByteSortedSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedSet<Character> newUnmodifiableCharSortedSet(char ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newCharSortedSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedSet<Double> newUnmodifiableDoubleSortedSet(double ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newDoubleSortedSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedSet<Float> newUnmodifiableFloatSortedSet(float ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newFloatSortedSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedSet<Integer> newUnmodifiableIntSortedSet(int ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newIntSortedSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedSet<Long> newUnmodifiableLongSortedSet(long ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newLongSortedSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static SortedSet<Short> newUnmodifiableShortSortedSet(short ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newShortSortedSet(aValues));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newOrderedSet() {
        return new LinkedHashSet(0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newOrderedSet(@Nullable ELEMENTTYPE aValue) {
        LinkedHashSet<ELEMENTTYPE> ret = new LinkedHashSet<ELEMENTTYPE>(1);
        ret.add(aValue);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newOrderedSet(ELEMENTTYPE ... aValues) {
        if (ArrayHelper.isEmpty(aValues)) {
            return new LinkedHashSet(0);
        }
        LinkedHashSet<ELEMENTTYPE> ret = new LinkedHashSet<ELEMENTTYPE>(aValues.length);
        for (ELEMENTTYPE aValue : aValues) {
            ret.add(aValue);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newOrderedSet(@Nullable Iterable<? extends ELEMENTTYPE> aCont) {
        LinkedHashSet<ELEMENTTYPE> ret = new LinkedHashSet<ELEMENTTYPE>();
        if (aCont != null) {
            for (ELEMENTTYPE aValue : aCont) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newOrderedSet(@Nullable Collection<? extends ELEMENTTYPE> aCont) {
        if (ContainerHelper.isEmpty(aCont)) {
            return new LinkedHashSet(0);
        }
        return new LinkedHashSet<ELEMENTTYPE>(aCont);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newOrderedSet(@Nonnull Iterator<? extends ELEMENTTYPE> aIter) {
        LinkedHashSet<ELEMENTTYPE> ret = new LinkedHashSet<ELEMENTTYPE>();
        if (aIter != null) {
            while (aIter.hasNext()) {
                ret.add(aIter.next());
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newOrderedSet(@Nullable IIterableIterator<? extends ELEMENTTYPE> aIter) {
        if (aIter == null) {
            return new LinkedHashSet(0);
        }
        return ContainerHelper.newOrderedSet(aIter.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newOrderedSet(@Nullable Enumeration<? extends ELEMENTTYPE> aEnum) {
        LinkedHashSet<ELEMENTTYPE> ret = new LinkedHashSet<ELEMENTTYPE>();
        if (aEnum != null) {
            while (aEnum.hasMoreElements()) {
                ret.add(aEnum.nextElement());
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Boolean> newBooleanOrderedSet(boolean ... aValues) {
        LinkedHashSet<Boolean> ret = new LinkedHashSet<Boolean>();
        if (aValues != null) {
            for (boolean aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Byte> newByteOrderedSet(byte ... aValues) {
        LinkedHashSet<Byte> ret = new LinkedHashSet<Byte>();
        if (aValues != null) {
            for (byte aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Character> newCharOrderedSet(char ... aValues) {
        LinkedHashSet<Character> ret = new LinkedHashSet<Character>();
        if (aValues != null) {
            for (char aValue : aValues) {
                ret.add(Character.valueOf(aValue));
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Double> newDoubleOrderedSet(double ... aValues) {
        LinkedHashSet<Double> ret = new LinkedHashSet<Double>();
        if (aValues != null) {
            for (double aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Float> newFloatOrderedSet(float ... aValues) {
        LinkedHashSet<Float> ret = new LinkedHashSet<Float>();
        if (aValues != null) {
            for (float aValue : aValues) {
                ret.add(Float.valueOf(aValue));
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Integer> newIntOrderedSet(int ... aValues) {
        LinkedHashSet<Integer> ret = new LinkedHashSet<Integer>();
        if (aValues != null) {
            for (int aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Long> newLongOrderedSet(long ... aValues) {
        LinkedHashSet<Long> ret = new LinkedHashSet<Long>();
        if (aValues != null) {
            for (long aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Set<Short> newShortOrderedSet(short ... aValues) {
        LinkedHashSet<Short> ret = new LinkedHashSet<Short>();
        if (aValues != null) {
            for (short aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableOrderedSet() {
        return Collections.emptySet();
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableOrderedSet(@Nullable ELEMENTTYPE aValue) {
        return Collections.singleton(aValue);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableOrderedSet(ELEMENTTYPE ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableOrderedSet(@Nonnull Iterable<? extends ELEMENTTYPE> aCont) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedSet(aCont));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableOrderedSet(@Nonnull Collection<? extends ELEMENTTYPE> aCont) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedSet(aCont));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableOrderedSet(@Nonnull Iterator<? extends ELEMENTTYPE> aIter) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedSet(aIter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableOrderedSet(@Nonnull IIterableIterator<? extends ELEMENTTYPE> aIter) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedSet(aIter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> newUnmodifiableOrderedSet(@Nullable Enumeration<? extends ELEMENTTYPE> aEnum) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newOrderedSet(aEnum));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Boolean> newUnmodifiableBooleanOrderedSet(boolean ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newBooleanOrderedSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Byte> newUnmodifiableByteOrderedSet(byte ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newByteOrderedSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Character> newUnmodifiableCharOrderedSet(char ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newCharOrderedSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Double> newUnmodifiableDoubleOrderedSet(double ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newDoubleOrderedSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Float> newUnmodifiableFloatOrderedSet(float ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newFloatOrderedSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Integer> newUnmodifiableIntOrderedSet(int ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newIntOrderedSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Long> newUnmodifiableLongOrderedSet(long ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newLongOrderedSet(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static Set<Short> newUnmodifiableShortOrderedSet(short ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newShortOrderedSet(aValues));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newListPrefilled(@Nullable ELEMENTTYPE aValue, @Nonnegative int nElements) {
        if (nElements < 0) {
            throw new IllegalArgumentException("Element count must be >= 0!");
        }
        ArrayList<ELEMENTTYPE> ret = new ArrayList<ELEMENTTYPE>(nElements);
        for (int i = 0; i < nElements; ++i) {
            ret.add(aValue);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newList() {
        return new ArrayList(0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newList(@Nullable ELEMENTTYPE aValue) {
        ArrayList<ELEMENTTYPE> ret = new ArrayList<ELEMENTTYPE>(1);
        ret.add(aValue);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newList(ELEMENTTYPE ... aValues) {
        if (ArrayHelper.isEmpty(aValues)) {
            return new ArrayList(0);
        }
        ArrayList<ELEMENTTYPE> ret = new ArrayList<ELEMENTTYPE>(aValues.length);
        for (ELEMENTTYPE aValue : aValues) {
            ret.add(aValue);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newList(@Nullable Enumeration<? extends ELEMENTTYPE> aEnum) {
        ArrayList<ELEMENTTYPE> ret = new ArrayList<ELEMENTTYPE>();
        if (aEnum != null) {
            while (aEnum.hasMoreElements()) {
                ret.add(aEnum.nextElement());
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newList(@Nullable Iterator<? extends ELEMENTTYPE> aIter) {
        ArrayList<ELEMENTTYPE> ret = new ArrayList<ELEMENTTYPE>();
        if (aIter != null) {
            while (aIter.hasNext()) {
                ret.add(aIter.next());
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newList(@Nullable Iterable<? extends ELEMENTTYPE> aIter) {
        ArrayList<ELEMENTTYPE> ret = new ArrayList<ELEMENTTYPE>();
        if (aIter != null) {
            for (ELEMENTTYPE aObj : aIter) {
                ret.add(aObj);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newList(@Nullable Collection<? extends ELEMENTTYPE> aCont) {
        if (ContainerHelper.isEmpty(aCont)) {
            return new ArrayList(0);
        }
        return new ArrayList<ELEMENTTYPE>(aCont);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newList(@Nullable IIterableIterator<? extends ELEMENTTYPE> aIter) {
        if (aIter == null) {
            return new ArrayList(0);
        }
        return ContainerHelper.newList(aIter.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVectorPrefilled(@Nullable ELEMENTTYPE aValue, @Nonnegative int nElements) {
        if (nElements < 0) {
            throw new IllegalArgumentException("Element count must be >= 0!");
        }
        Vector<ELEMENTTYPE> ret = new Vector<ELEMENTTYPE>(nElements);
        for (int i = 0; i < nElements; ++i) {
            ret.add(aValue);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVector() {
        return new Vector(0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVector(@Nullable ELEMENTTYPE aValue) {
        Vector<ELEMENTTYPE> ret = new Vector<ELEMENTTYPE>(1);
        ret.add(aValue);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVector(ELEMENTTYPE ... aValues) {
        if (ArrayHelper.isEmpty(aValues)) {
            return new Vector(0);
        }
        Vector<ELEMENTTYPE> ret = new Vector<ELEMENTTYPE>(aValues.length);
        for (ELEMENTTYPE aValue : aValues) {
            ret.add(aValue);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVector(@Nullable Enumeration<? extends ELEMENTTYPE> aEnum) {
        Vector<ELEMENTTYPE> ret = new Vector<ELEMENTTYPE>();
        if (aEnum != null) {
            while (aEnum.hasMoreElements()) {
                ret.add(aEnum.nextElement());
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVector(@Nullable Iterator<? extends ELEMENTTYPE> aIter) {
        Vector<ELEMENTTYPE> ret = new Vector<ELEMENTTYPE>();
        if (aIter != null) {
            while (aIter.hasNext()) {
                ret.add(aIter.next());
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVector(@Nullable Iterable<? extends ELEMENTTYPE> aIter) {
        Vector<ELEMENTTYPE> ret = new Vector<ELEMENTTYPE>();
        if (aIter != null) {
            for (ELEMENTTYPE aObj : aIter) {
                ret.add(aObj);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVector(@Nullable Collection<? extends ELEMENTTYPE> aCont) {
        if (ContainerHelper.isEmpty(aCont)) {
            return new Vector(0);
        }
        return new Vector<ELEMENTTYPE>(aCont);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Vector<ELEMENTTYPE> newVector(@Nullable IIterableIterator<? extends ELEMENTTYPE> aIter) {
        if (aIter == null) {
            return new Vector(0);
        }
        return ContainerHelper.newVector(aIter.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Boolean> newBooleanList(boolean ... aValues) {
        ArrayList<Boolean> ret = new ArrayList<Boolean>();
        if (aValues != null) {
            for (boolean aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Byte> newByteList(byte ... aValues) {
        ArrayList<Byte> ret = new ArrayList<Byte>();
        if (aValues != null) {
            for (byte aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Character> newCharList(char ... aValues) {
        ArrayList<Character> ret = new ArrayList<Character>();
        if (aValues != null) {
            for (char aValue : aValues) {
                ret.add(Character.valueOf(aValue));
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Double> newDoubleList(double ... aValues) {
        ArrayList<Double> ret = new ArrayList<Double>();
        if (aValues != null) {
            for (double aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Float> newFloatList(float ... aValues) {
        ArrayList<Float> ret = new ArrayList<Float>();
        if (aValues != null) {
            for (float aValue : aValues) {
                ret.add(Float.valueOf(aValue));
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Integer> newIntList(int ... aValues) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        if (aValues != null) {
            for (int aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Long> newLongList(long ... aValues) {
        ArrayList<Long> ret = new ArrayList<Long>();
        if (aValues != null) {
            for (long aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static List<Short> newShortList(short ... aValues) {
        ArrayList<Short> ret = new ArrayList<Short>();
        if (aValues != null) {
            for (short aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Vector<Boolean> newBooleanVector(boolean ... aValues) {
        Vector<Boolean> ret = new Vector<Boolean>();
        if (aValues != null) {
            for (boolean aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Vector<Byte> newByteVector(byte ... aValues) {
        Vector<Byte> ret = new Vector<Byte>();
        if (aValues != null) {
            for (byte aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Vector<Character> newCharVector(char ... aValues) {
        Vector<Character> ret = new Vector<Character>();
        if (aValues != null) {
            for (char aValue : aValues) {
                ret.add(Character.valueOf(aValue));
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Vector<Double> newDoubleVector(double ... aValues) {
        Vector<Double> ret = new Vector<Double>();
        if (aValues != null) {
            for (double aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Vector<Float> newFloatVector(float ... aValues) {
        Vector<Float> ret = new Vector<Float>();
        if (aValues != null) {
            for (float aValue : aValues) {
                ret.add(Float.valueOf(aValue));
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Vector<Integer> newIntVector(int ... aValues) {
        Vector<Integer> ret = new Vector<Integer>();
        if (aValues != null) {
            for (int aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Vector<Long> newLongVector(long ... aValues) {
        Vector<Long> ret = new Vector<Long>();
        if (aValues != null) {
            for (long aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Vector<Short> newShortVector(short ... aValues) {
        Vector<Short> ret = new Vector<Short>();
        if (aValues != null) {
            for (short aValue : aValues) {
                ret.add(aValue);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newUnmodifiableList() {
        return Collections.emptyList();
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newUnmodifiableList(@Nullable ELEMENTTYPE aValue) {
        return Collections.singletonList(aValue);
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newUnmodifiableList(ELEMENTTYPE ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newList(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newUnmodifiableList(@Nullable Enumeration<? extends ELEMENTTYPE> aIter) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newList(aIter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newUnmodifiableList(@Nullable Iterator<? extends ELEMENTTYPE> aIter) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newList(aIter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newUnmodifiableList(@Nullable Iterable<? extends ELEMENTTYPE> aCont) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newList(aCont));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newUnmodifiableList(@Nullable Collection<? extends ELEMENTTYPE> aCont) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newList(aCont));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static <ELEMENTTYPE> List<ELEMENTTYPE> newUnmodifiableList(@Nullable IIterableIterator<? extends ELEMENTTYPE> aIter) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newList(aIter));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Boolean> newUnmodifiableBooleanList(boolean ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newBooleanList(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Byte> newUnmodifiableByteList(byte ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newByteList(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Character> newUnmodifiableCharList(char ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newCharList(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Double> newUnmodifiableDoubleList(double ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newDoubleList(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Float> newUnmodifiableFloatList(float ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newFloatList(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Integer> newUnmodifiableIntList(int ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newIntList(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Long> newUnmodifiableLongList(long ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newLongList(aValues));
    }

    @Nonnull
    @ReturnsImmutableObject
    public static List<Short> newUnmodifiableShortList(short ... aValues) {
        return ContainerHelper.makeUnmodifiable(ContainerHelper.newShortList(aValues));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> newStack() {
        return new NonBlockingStack();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> newStack(@Nullable ELEMENTTYPE aValue) {
        NonBlockingStack<ELEMENTTYPE> ret = new NonBlockingStack<ELEMENTTYPE>();
        ret.push(aValue);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> newStack(ELEMENTTYPE ... aValues) {
        return new NonBlockingStack<ELEMENTTYPE>(aValues);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> newStack(@Nullable Collection<? extends ELEMENTTYPE> aValues) {
        return new NonBlockingStack<ELEMENTTYPE>(aValues);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Queue<ELEMENTTYPE> newQueue() {
        return new PriorityQueue(0);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Queue<ELEMENTTYPE> newQueue(@Nonnull ELEMENTTYPE aValue) {
        PriorityQueue<ELEMENTTYPE> ret = new PriorityQueue<ELEMENTTYPE>(1);
        ret.add(aValue);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Queue<ELEMENTTYPE> newQueue(ELEMENTTYPE ... aValues) {
        if (ArrayHelper.isEmpty(aValues)) {
            return new PriorityQueue(0);
        }
        PriorityQueue<ELEMENTTYPE> ret = new PriorityQueue<ELEMENTTYPE>(aValues.length);
        for (ELEMENTTYPE aValue : aValues) {
            ret.add(aValue);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Queue<ELEMENTTYPE> newQueue(@Nullable Enumeration<? extends ELEMENTTYPE> aEnum) {
        PriorityQueue<ELEMENTTYPE> ret = new PriorityQueue<ELEMENTTYPE>();
        if (aEnum != null) {
            while (aEnum.hasMoreElements()) {
                ret.add(aEnum.nextElement());
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Queue<ELEMENTTYPE> newQueue(@Nullable Iterator<? extends ELEMENTTYPE> aIter) {
        PriorityQueue<ELEMENTTYPE> ret = new PriorityQueue<ELEMENTTYPE>();
        if (aIter != null) {
            while (aIter.hasNext()) {
                ret.add(aIter.next());
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Queue<ELEMENTTYPE> newQueue(@Nullable Iterable<? extends ELEMENTTYPE> aIter) {
        PriorityQueue<ELEMENTTYPE> ret = new PriorityQueue<ELEMENTTYPE>();
        if (aIter != null) {
            for (ELEMENTTYPE aObj : aIter) {
                ret.add(aObj);
            }
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Queue<ELEMENTTYPE> newQueue(@Nullable Collection<? extends ELEMENTTYPE> aCont) {
        if (ContainerHelper.isEmpty(aCont)) {
            return new PriorityQueue(0);
        }
        return new PriorityQueue<ELEMENTTYPE>(aCont);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Queue<ELEMENTTYPE> newQueue(@Nullable IIterableIterator<? extends ELEMENTTYPE> aIter) {
        if (aIter == null) {
            return new PriorityQueue(0);
        }
        return ContainerHelper.newQueue(aIter.iterator());
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> List<ELEMENTTYPE> getSorted(@Nullable IIterableIterator<? extends ELEMENTTYPE> aIter) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(aIter));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> List<ELEMENTTYPE> getSorted(@Nullable IIterableIterator<? extends ELEMENTTYPE> aIter, @Nonnull Comparator<? super ELEMENTTYPE> aComparator) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(aIter), aComparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> List<ELEMENTTYPE> getSorted(@Nullable Iterator<? extends ELEMENTTYPE> aIter) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(aIter));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getSorted(@Nullable Iterator<? extends ELEMENTTYPE> aIter, @Nonnull Comparator<? super ELEMENTTYPE> aComparator) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(aIter), aComparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> List<ELEMENTTYPE> getSorted(@Nullable Iterable<? extends ELEMENTTYPE> aCont) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(aCont));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getSorted(@Nullable Iterable<? extends ELEMENTTYPE> aCont, @Nonnull Comparator<? super ELEMENTTYPE> aComparator) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(aCont), aComparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> List<ELEMENTTYPE> getSorted(@Nullable Collection<? extends ELEMENTTYPE> aCont) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(aCont));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getSorted(@Nullable Collection<? extends ELEMENTTYPE> aCont, @Nonnull Comparator<? super ELEMENTTYPE> aComparator) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(aCont), aComparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> List<ELEMENTTYPE> getSorted(ELEMENTTYPE ... aCont) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(aCont));
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getSorted(@Nullable ELEMENTTYPE[] aCont, @Nonnull Comparator<? super ELEMENTTYPE> aComparator) {
        return ContainerHelper.getSortedInline(ContainerHelper.newList(aCont), aComparator);
    }

    @Nullable
    @ReturnsMutableObject(reason="design")
    public static <ELEMENTTYPE extends Comparable<? super ELEMENTTYPE>> List<ELEMENTTYPE> getSortedInline(@Nullable List<ELEMENTTYPE> aList) {
        if (ContainerHelper.isNotEmpty(aList)) {
            Collections.sort(aList);
        }
        return aList;
    }

    @Nullable
    @ReturnsMutableObject(reason="design")
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getSortedInline(@Nullable List<ELEMENTTYPE> aList, @Nonnull Comparator<? super ELEMENTTYPE> aComparator) {
        if (aComparator == null) {
            throw new NullPointerException("comparator");
        }
        if (ContainerHelper.isNotEmpty(aList)) {
            Collections.sort(aList, aComparator);
        }
        return aList;
    }

    @Nullable
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> Map<KEYTYPE, VALUETYPE> getSortedByKey(@Nullable Map<KEYTYPE, VALUETYPE> aMap) {
        return ContainerHelper.getSortedByKey(aMap, ESortOrder.DEFAULT);
    }

    @Nullable
    public static <KEYTYPE extends Comparable<? super KEYTYPE>, VALUETYPE> Map<KEYTYPE, VALUETYPE> getSortedByKey(@Nullable Map<KEYTYPE, VALUETYPE> aMap, @Nonnull ESortOrder eSortOrder) {
        if (ContainerHelper.isEmpty(aMap)) {
            return aMap;
        }
        List<Map.Entry<KEYTYPE, VALUETYPE>> aList = ContainerHelper.newList(aMap.entrySet());
        Collections.sort(aList, ComparatorUtils.getComparatorMapEntryKey(eSortOrder));
        return ContainerHelper.newOrderedMap(aList);
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> getSortedByKey(@Nullable Map<KEYTYPE, VALUETYPE> aMap, @Nonnull Comparator<? super KEYTYPE> aKeyComparator) {
        if (aKeyComparator == null) {
            throw new NullPointerException("keyComparator");
        }
        if (ContainerHelper.isEmpty(aMap)) {
            return aMap;
        }
        List<Map.Entry<KEYTYPE, VALUETYPE>> aList = ContainerHelper.newList(aMap.entrySet());
        Collections.sort(aList, ComparatorUtils.getComparatorMapEntryKey(aKeyComparator));
        return ContainerHelper.newOrderedMap(aList);
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE extends Comparable<? super VALUETYPE>> Map<KEYTYPE, VALUETYPE> getSortedByValue(@Nullable Map<KEYTYPE, VALUETYPE> aMap) {
        return ContainerHelper.getSortedByValue(aMap, ESortOrder.DEFAULT);
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE extends Comparable<? super VALUETYPE>> Map<KEYTYPE, VALUETYPE> getSortedByValue(@Nullable Map<KEYTYPE, VALUETYPE> aMap, @Nonnull ESortOrder eSortOrder) {
        if (ContainerHelper.isEmpty(aMap)) {
            return aMap;
        }
        List<Map.Entry<KEYTYPE, VALUETYPE>> aList = ContainerHelper.newList(aMap.entrySet());
        Collections.sort(aList, ComparatorUtils.getComparatorMapEntryValue(eSortOrder));
        return ContainerHelper.newOrderedMap(aList);
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE> Map<KEYTYPE, VALUETYPE> getSortedByValue(@Nullable Map<KEYTYPE, VALUETYPE> aMap, @Nonnull Comparator<? super VALUETYPE> aValueComparator) {
        if (aValueComparator == null) {
            throw new NullPointerException("valueComparator");
        }
        if (ContainerHelper.isEmpty(aMap)) {
            return aMap;
        }
        List<Map.Entry<KEYTYPE, VALUETYPE>> aList = ContainerHelper.newList(aMap.entrySet());
        Collections.sort(aList, ComparatorUtils.getComparatorMapEntryValue(aValueComparator));
        return ContainerHelper.newOrderedMap(aList);
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getReverseList(@Nullable Collection<? extends ELEMENTTYPE> aCollection) {
        if (ContainerHelper.isEmpty(aCollection)) {
            return new ArrayList(0);
        }
        ArrayList<? extends ELEMENTTYPE> ret = new ArrayList<ELEMENTTYPE>(aCollection);
        Collections.reverse(ret);
        return ret;
    }

    @Nullable
    @ReturnsMutableObject(reason="semantics of this method")
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getReverseInlineList(@Nullable List<ELEMENTTYPE> aList) {
        if (aList == null) {
            return null;
        }
        Collections.reverse(aList);
        return aList;
    }

    @Nonnull
    public static <ELEMENTTYPE> IIterableIterator<ELEMENTTYPE> getIterator(@Nullable Enumeration<? extends ELEMENTTYPE> aEnum) {
        return new IterableIteratorFromEnumeration<ELEMENTTYPE>(aEnum);
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getIterator(@Nullable Iterable<ELEMENTTYPE> aCont) {
        return aCont == null ? EmptyIterator.getInstance() : ContainerHelper.getIterator(aCont.iterator());
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getIterator(@Nullable Iterator<ELEMENTTYPE> aIter) {
        return aIter == null ? EmptyIterator.getInstance() : aIter;
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getIterator(ELEMENTTYPE ... aArray) {
        return ArrayHelper.isEmpty(aArray) ? EmptyIterator.getInstance() : ContainerHelper.getIterator(ContainerHelper.newList(aArray).iterator());
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getReverseIterator(@Nullable List<ELEMENTTYPE> aCont) {
        if (ContainerHelper.isEmpty(aCont)) {
            return EmptyIterator.getInstance();
        }
        return new ReverseListIterator<ELEMENTTYPE>(aCont);
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getEmptyIterator() {
        return EmptyIterator.getInstance();
    }

    @Nonnull
    public static <ELEMENTTYPE> Iterator<ELEMENTTYPE> getCombinedIterator(@Nullable Iterator<? extends ELEMENTTYPE> aIter1, @Nullable Iterator<? extends ELEMENTTYPE> aIter2) {
        return new CombinedIterator<ELEMENTTYPE>(aIter1, aIter2);
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEnumeration(@Nullable Iterable<ELEMENTTYPE> aCont) {
        return ContainerHelper.isEmpty(aCont) ? EmptyEnumeration.getInstance() : ContainerHelper.getEnumeration(aCont.iterator());
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEnumeration(ELEMENTTYPE ... aArray) {
        return ContainerHelper.getEnumeration(ContainerHelper.getIterator(aArray));
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEnumeration(@Nullable Iterator<ELEMENTTYPE> aIter) {
        if (aIter == null) {
            return EmptyEnumeration.getInstance();
        }
        return new EnumerationFromIterator<ELEMENTTYPE>(aIter);
    }

    @Nonnull
    public static <KEYTYPE, VALUETYPE> Enumeration<Map.Entry<KEYTYPE, VALUETYPE>> getEnumeration(@Nullable Map<KEYTYPE, VALUETYPE> aMap) {
        if (aMap == null) {
            return EmptyEnumeration.getInstance();
        }
        return ContainerHelper.getEnumeration(aMap.entrySet());
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getCombinedEnumeration(@Nullable Enumeration<? extends ELEMENTTYPE> aEnum1, @Nullable Enumeration<? extends ELEMENTTYPE> aEnum2) {
        return new CombinedEnumeration<ELEMENTTYPE>(aEnum1, aEnum2);
    }

    @Nonnull
    public static <ELEMENTTYPE> Enumeration<ELEMENTTYPE> getEmptyEnumeration() {
        return EmptyEnumeration.getInstance();
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> NonBlockingStack<ELEMENTTYPE> getStackCopyWithoutTop(@Nullable NonBlockingStack<ELEMENTTYPE> aStack) {
        if (ContainerHelper.isEmpty(aStack)) {
            return null;
        }
        NonBlockingStack<ELEMENTTYPE> ret = new NonBlockingStack<ELEMENTTYPE>(aStack);
        ret.pop();
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <KEY, VALUE> Map<KEY, VALUE> getFilteredMap(@Nullable Map<KEY, VALUE> aValues, @Nullable Collection<KEY> aKeys) {
        if (ContainerHelper.isEmpty(aValues) || ContainerHelper.isEmpty(aKeys)) {
            return null;
        }
        HashMap<KEY, VALUE> ret = new HashMap<KEY, VALUE>();
        for (KEY aKey : aKeys) {
            if (!aValues.containsKey(aKey)) continue;
            ret.put(aKey, aValues.get(aKey));
        }
        return ret;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirstElement(@Nullable List<ELEMENTTYPE> aList) {
        return ContainerHelper.isEmpty(aList) ? null : (ELEMENTTYPE)aList.get(0);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirstElement(@Nullable Collection<ELEMENTTYPE> aCont) {
        return ContainerHelper.isEmpty(aCont) ? null : (ELEMENTTYPE)aCont.iterator().next();
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getFirstElement(@Nullable Iterable<ELEMENTTYPE> aCont) {
        if (aCont == null) {
            return null;
        }
        Iterator<ELEMENTTYPE> it = aCont.iterator();
        return it.hasNext() ? (ELEMENTTYPE)it.next() : null;
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE> Map.Entry<KEYTYPE, VALUETYPE> getFirstElement(@Nullable Map<KEYTYPE, VALUETYPE> aMap) {
        return ContainerHelper.isEmpty(aMap) ? null : ContainerHelper.getFirstElement(aMap.entrySet());
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE> KEYTYPE getFirstKey(@Nullable Map<KEYTYPE, VALUETYPE> aMap) {
        return ContainerHelper.isEmpty(aMap) ? null : (KEYTYPE)ContainerHelper.getFirstElement(aMap.keySet());
    }

    @Nullable
    public static <KEYTYPE, VALUETYPE> VALUETYPE getFirstValue(@Nullable Map<KEYTYPE, VALUETYPE> aMap) {
        return ContainerHelper.isEmpty(aMap) ? null : (VALUETYPE)ContainerHelper.getFirstElement(aMap.values());
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE removeFirstElement(@Nullable List<ELEMENTTYPE> aList) {
        return ContainerHelper.isEmpty(aList) ? null : (ELEMENTTYPE)aList.remove(0);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getLastElement(@Nullable List<ELEMENTTYPE> aList) {
        int nSize = ContainerHelper.getSize(aList);
        return nSize == 0 ? null : (ELEMENTTYPE)aList.get(nSize - 1);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getLastElement(@Nullable Collection<ELEMENTTYPE> aCont) {
        if (ContainerHelper.isEmpty(aCont)) {
            return null;
        }
        ELEMENTTYPE aLast2 = null;
        for (ELEMENTTYPE aLast2 : aCont) {
        }
        return aLast2;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getLastElement(@Nullable Iterable<ELEMENTTYPE> aCont) {
        if (aCont == null) {
            return null;
        }
        ELEMENTTYPE aLast2 = null;
        for (ELEMENTTYPE aLast2 : aCont) {
        }
        return aLast2;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE removeLastElement(@Nullable List<ELEMENTTYPE> aList) {
        int nSize = ContainerHelper.getSize(aList);
        return nSize == 0 ? null : (ELEMENTTYPE)aList.remove(nSize - 1);
    }

    public static boolean isEmpty(@Nullable Iterable<?> aCont) {
        return aCont == null || !aCont.iterator().hasNext();
    }

    public static boolean isEmpty(@Nullable Iterator<?> aIter) {
        return aIter == null || !aIter.hasNext();
    }

    public static boolean isEmpty(@Nullable IIterableIterator<?> aIter) {
        return aIter == null || !aIter.hasNext();
    }

    public static boolean isEmpty(@Nullable Enumeration<?> aEnum) {
        return aEnum == null || !aEnum.hasMoreElements();
    }

    public static boolean isEmpty(@Nullable Collection<?> aCont) {
        return aCont == null || aCont.isEmpty();
    }

    public static boolean isEmpty(@Nullable Map<?, ?> aCont) {
        return aCont == null || aCont.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable Iterable<?> aCont) {
        return aCont != null && aCont.iterator().hasNext();
    }

    public static boolean isNotEmpty(@Nullable Iterator<?> aIter) {
        return aIter != null && aIter.hasNext();
    }

    public static boolean isNotEmpty(@Nullable IIterableIterator<?> aIter) {
        return aIter != null && aIter.hasNext();
    }

    public static boolean isNotEmpty(@Nullable Enumeration<?> aEnum) {
        return aEnum != null && aEnum.hasMoreElements();
    }

    public static boolean isNotEmpty(@Nullable Collection<?> aCont) {
        return aCont != null && !aCont.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable Map<?, ?> aCont) {
        return aCont != null && !aCont.isEmpty();
    }

    @Nonnegative
    public static int getSize(@Nullable Collection<?> aObj) {
        return aObj == null ? 0 : aObj.size();
    }

    @Nonnegative
    public static int getSize(@Nullable Map<?, ?> aObj) {
        return aObj == null ? 0 : aObj.size();
    }

    @Nonnegative
    public static int getSize(@Nullable Iterable<?> aCont) {
        return aCont == null ? 0 : ContainerHelper.getSize(aCont.iterator());
    }

    @Nonnegative
    public static int getSize(@Nullable IIterableIterator<?> aCont) {
        return aCont == null ? 0 : ContainerHelper.getSize(aCont.iterator());
    }

    @Nonnegative
    public static int getSize(@Nullable Iterator<?> aIter) {
        int ret = 0;
        if (aIter != null) {
            while (aIter.hasNext()) {
                aIter.next();
                ++ret;
            }
        }
        return ret;
    }

    @Nonnegative
    public static int getSize(@Nullable Enumeration<?> aEnum) {
        int ret = 0;
        if (aEnum != null) {
            while (aEnum.hasMoreElements()) {
                aEnum.nextElement();
                ++ret;
            }
        }
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getConcatenatedList(@Nullable Collection<? extends ELEMENTTYPE> aCont1, @Nullable Collection<? extends ELEMENTTYPE> aCont2) {
        int nSize1 = ContainerHelper.getSize(aCont1);
        int nSize2 = ContainerHelper.getSize(aCont2);
        if (nSize1 == 0) {
            return ContainerHelper.newList(aCont2);
        }
        if (nSize2 == 0) {
            return ContainerHelper.newList(aCont1);
        }
        ArrayList<Object> ret = new ArrayList<Object>(nSize1 + nSize2);
        ret.addAll(aCont1);
        ret.addAll(aCont2);
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getConcatenatedList(@Nullable Collection<? extends ELEMENTTYPE> aCont1, ELEMENTTYPE ... aCont2) {
        int nSize1 = ContainerHelper.getSize(aCont1);
        int nSize2 = ArrayHelper.getSize(aCont2);
        if (nSize1 == 0) {
            return ContainerHelper.newList(aCont2);
        }
        if (nSize2 == 0) {
            return ContainerHelper.newList(aCont1);
        }
        ArrayList<Object> ret = new ArrayList<Object>(nSize1 + nSize2);
        ret.addAll(aCont1);
        for (ELEMENTTYPE aElement : aCont2) {
            ret.add(aElement);
        }
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getConcatenatedList(@Nullable ELEMENTTYPE[] aCont1, @Nullable Collection<? extends ELEMENTTYPE> aCont2) {
        int nSize1 = ArrayHelper.getSize(aCont1);
        int nSize2 = ContainerHelper.getSize(aCont2);
        if (nSize1 == 0) {
            return ContainerHelper.newList(aCont2);
        }
        if (nSize2 == 0) {
            return ContainerHelper.newList(aCont1);
        }
        ArrayList<Object> ret = new ArrayList<Object>(nSize1 + nSize2);
        for (ELEMENTTYPE aElement : aCont1) {
            ret.add(aElement);
        }
        ret.addAll(aCont2);
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> getConcatenatedSet(@Nullable Collection<? extends ELEMENTTYPE> aCont1, @Nullable Collection<? extends ELEMENTTYPE> aCont2) {
        int nSize1 = ContainerHelper.getSize(aCont1);
        int nSize2 = ContainerHelper.getSize(aCont2);
        if (nSize1 == 0) {
            return ContainerHelper.newSet(aCont2);
        }
        if (nSize2 == 0) {
            return ContainerHelper.newSet(aCont1);
        }
        HashSet<Object> ret = new HashSet<Object>(nSize1 + nSize2);
        ret.addAll(aCont1);
        ret.addAll(aCont2);
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> getConcatenatedSet(@Nullable Collection<? extends ELEMENTTYPE> aCont1, ELEMENTTYPE ... aCont2) {
        int nSize1 = ContainerHelper.getSize(aCont1);
        int nSize2 = ArrayHelper.getSize(aCont2);
        if (nSize1 == 0) {
            return ContainerHelper.newSet(aCont2);
        }
        if (nSize2 == 0) {
            return ContainerHelper.newSet(aCont1);
        }
        HashSet<Object> ret = new HashSet<Object>(nSize1 + nSize2);
        ret.addAll(aCont1);
        for (ELEMENTTYPE aElement : aCont2) {
            ret.add(aElement);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> Set<ELEMENTTYPE> getConcatenatedSet(@Nullable ELEMENTTYPE[] aCont1, @Nullable Collection<? extends ELEMENTTYPE> aCont2) {
        int nSize1 = ArrayHelper.getSize(aCont1);
        int nSize2 = ContainerHelper.getSize(aCont2);
        if (nSize1 == 0) {
            return ContainerHelper.newSet(aCont2);
        }
        if (nSize2 == 0) {
            return ContainerHelper.newSet(aCont1);
        }
        HashSet<Object> ret = new HashSet<Object>(nSize1 + nSize2);
        for (ELEMENTTYPE aElement : aCont1) {
            ret.add(aElement);
        }
        ret.addAll(aCont2);
        return ret;
    }

    @Nonnull
    @ReturnsMutableObject(reason="design")
    public static <ELEMENTTYPE, COLLTYPE extends Collection<? super ELEMENTTYPE>> COLLTYPE getConcatenatedInline(@Nonnull COLLTYPE aCont, ELEMENTTYPE ... aElementsToAdd) {
        if (aCont == null) {
            throw new NullPointerException("cont");
        }
        if (aElementsToAdd != null) {
            for (ELEMENTTYPE aElement : aElementsToAdd) {
                aCont.add(aElement);
            }
        }
        return aCont;
    }

    @Nonnull
    @ReturnsMutableObject(reason="design")
    public static <ELEMENTTYPE, COLLTYPE extends Collection<? super ELEMENTTYPE>> COLLTYPE getConcatenatedInline(@Nonnull COLLTYPE aCont, @Nullable Collection<? extends ELEMENTTYPE> aElementsToAdd) {
        if (aCont == null) {
            throw new NullPointerException("cont");
        }
        if (aElementsToAdd != null) {
            aCont.addAll(aElementsToAdd);
        }
        return aCont;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <KEY, VALUE> Map<KEY, VALUE> getCombinedMap(@Nullable Map<KEY, VALUE> aMap1, @Nullable Map<KEY, VALUE> aMap2) {
        if (ContainerHelper.isEmpty(aMap1)) {
            return ContainerHelper.newMap(aMap2);
        }
        if (ContainerHelper.isEmpty(aMap2)) {
            return ContainerHelper.newMap(aMap1);
        }
        HashMap<KEY, VALUE> ret = new HashMap<KEY, VALUE>(aMap1);
        ret.putAll(aMap2);
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<Boolean> newObjectListFromArray(@Nullable boolean[] aArray) {
        if (ArrayHelper.isEmpty(aArray)) {
            return null;
        }
        ArrayList<Boolean> ret = new ArrayList<Boolean>(aArray.length);
        for (boolean x : aArray) {
            ret.add(x);
        }
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<Byte> newObjectListFromArray(@Nullable byte[] aArray) {
        if (ArrayHelper.isEmpty(aArray)) {
            return null;
        }
        ArrayList<Byte> ret = new ArrayList<Byte>(aArray.length);
        for (byte x : aArray) {
            ret.add(x);
        }
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<Character> newObjectListFromArray(@Nullable char[] aArray) {
        if (ArrayHelper.isEmpty(aArray)) {
            return null;
        }
        ArrayList<Character> ret = new ArrayList<Character>(aArray.length);
        for (char x : aArray) {
            ret.add(Character.valueOf(x));
        }
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<Double> newObjectListFromArray(@Nullable double[] aArray) {
        if (ArrayHelper.isEmpty(aArray)) {
            return null;
        }
        ArrayList<Double> ret = new ArrayList<Double>(aArray.length);
        for (double x : aArray) {
            ret.add(x);
        }
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<Float> newObjectListFromArray(@Nullable float[] aArray) {
        if (ArrayHelper.isEmpty(aArray)) {
            return null;
        }
        ArrayList<Float> ret = new ArrayList<Float>(aArray.length);
        for (float x : aArray) {
            ret.add(Float.valueOf(x));
        }
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<Integer> newObjectListFromArray(@Nullable int[] aArray) {
        if (ArrayHelper.isEmpty(aArray)) {
            return null;
        }
        ArrayList<Integer> ret = new ArrayList<Integer>(aArray.length);
        for (int x : aArray) {
            ret.add(x);
        }
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<Long> newObjectListFromArray(@Nullable long[] aArray) {
        if (ArrayHelper.isEmpty(aArray)) {
            return null;
        }
        ArrayList<Long> ret = new ArrayList<Long>(aArray.length);
        for (long x : aArray) {
            ret.add(x);
        }
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<Short> newObjectListFromArray(@Nullable short[] aArray) {
        if (ArrayHelper.isEmpty(aArray)) {
            return null;
        }
        ArrayList<Short> ret = new ArrayList<Short>(aArray.length);
        for (short x : aArray) {
            ret.add(x);
        }
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static List<?> newObjectListFromArray(@Nullable Object aValue, @Nonnull Class<?> aComponentType) {
        if (aComponentType == Boolean.TYPE) {
            return ContainerHelper.newObjectListFromArray((boolean[])aValue);
        }
        if (aComponentType == Byte.TYPE) {
            return ContainerHelper.newObjectListFromArray((byte[])aValue);
        }
        if (aComponentType == Character.TYPE) {
            return ContainerHelper.newObjectListFromArray((char[])aValue);
        }
        if (aComponentType == Double.TYPE) {
            return ContainerHelper.newObjectListFromArray((double[])aValue);
        }
        if (aComponentType == Float.TYPE) {
            return ContainerHelper.newObjectListFromArray((float[])aValue);
        }
        if (aComponentType == Integer.TYPE) {
            return ContainerHelper.newObjectListFromArray((int[])aValue);
        }
        if (aComponentType == Long.TYPE) {
            return ContainerHelper.newObjectListFromArray((long[])aValue);
        }
        if (aComponentType == Short.TYPE) {
            return ContainerHelper.newObjectListFromArray((short[])aValue);
        }
        Object[] aArray = (Object[])aValue;
        if (ArrayHelper.isEmpty(aArray)) {
            return null;
        }
        ArrayList<Object> ret = new ArrayList<Object>(aArray.length);
        for (Object x : aArray) {
            ret.add(x);
        }
        return ret;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> List<ELEMENTTYPE> getSubList(@Nullable List<ELEMENTTYPE> aCont, @Nonnegative int nStartIndex, @Nonnegative int nSectionLength) {
        if (nStartIndex < 0) {
            throw new IllegalArgumentException("Start index must be >= 0: " + nStartIndex);
        }
        if (nSectionLength < 0) {
            throw new IllegalArgumentException("Length must be >= 0: " + nSectionLength);
        }
        int nSize = ContainerHelper.getSize(aCont);
        if (nSize == 0) {
            return new ArrayList(0);
        }
        int nEndIndex = nStartIndex + nSectionLength;
        if (nEndIndex > nSize) {
            nEndIndex = nSize;
        }
        return ContainerHelper.newList(aCont.subList(nStartIndex, nEndIndex));
    }

    @Nullable
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> Map<VALUETYPE, KEYTYPE> getSwappedKeyValues(@Nullable Map<KEYTYPE, VALUETYPE> aMap) {
        if (ContainerHelper.isEmpty(aMap)) {
            return null;
        }
        HashMap<VALUETYPE, KEYTYPE> ret = new HashMap<VALUETYPE, KEYTYPE>(aMap.size());
        for (Map.Entry<KEYTYPE, VALUETYPE> aEntry : aMap.entrySet()) {
            ret.put(aEntry.getValue(), aEntry.getKey());
        }
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> IMultiMapSetBased<VALUETYPE, KEYTYPE> getReverseLookupSet(@Nullable IMultiMap<KEYTYPE, VALUETYPE, ? extends Collection<VALUETYPE>> aMap) {
        if (ContainerHelper.isEmpty(aMap)) {
            return null;
        }
        MultiHashMapHashSetBased ret = new MultiHashMapHashSetBased();
        for (Map.Entry aEntry : aMap.entrySet()) {
            for (Object aValue : (Collection)aEntry.getValue()) {
                ret.putSingle(aValue, aEntry.getKey());
            }
        }
        return ret;
    }

    @Nullable
    @ReturnsMutableCopy
    public static <KEYTYPE, VALUETYPE> IMultiMapSetBased<VALUETYPE, KEYTYPE> getReverseLookup(@Nullable IMultiMapSetBased<KEYTYPE, VALUETYPE> aMap) {
        if (ContainerHelper.isEmpty(aMap)) {
            return null;
        }
        MultiHashMapHashSetBased aRet = new MultiHashMapHashSetBased();
        for (Map.Entry aEntry : aMap.entrySet()) {
            for (Object aValue : (Set)aEntry.getValue()) {
                aRet.putSingle(aValue, aEntry.getKey());
            }
        }
        return aRet;
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getSafe(@Nullable List<ELEMENTTYPE> aList, int nIndex) {
        return ContainerHelper.getSafe(aList, nIndex, null);
    }

    @Nullable
    public static <ELEMENTTYPE> ELEMENTTYPE getSafe(@Nullable List<ELEMENTTYPE> aList, int nIndex, @Nullable ELEMENTTYPE aDefault) {
        return aList != null && nIndex >= 0 && nIndex < aList.size() ? aList.get(nIndex) : aDefault;
    }

    public static boolean containsAnyNullElement(@Nullable Iterable<?> aCont) {
        if (aCont != null) {
            for (Object aObj : aCont) {
                if (aObj != null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsOnlyNullElements(@Nullable Iterable<?> aCont) {
        if (ContainerHelper.isEmpty(aCont)) {
            return false;
        }
        for (Object aObj : aCont) {
            if (aObj == null) continue;
            return false;
        }
        return true;
    }
}

