/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.io.streamprovider;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.charset.CharsetManager;
import com.phloc.commons.io.IInputStreamAndReaderProvider;
import com.phloc.commons.io.IReaderProvider;
import com.phloc.commons.io.streams.NonBlockingStringReader;
import com.phloc.commons.io.streams.StringInputStream;
import com.phloc.commons.string.ToStringGenerator;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class StringInputStreamProvider
implements IInputStreamAndReaderProvider,
IReaderProvider {
    private final String m_sData;
    private final Charset m_aCharset;

    public StringInputStreamProvider(@Nonnull char[] aChars, @Nonnull @Nonempty String sCharset) {
        this(new String(aChars), sCharset);
    }

    public StringInputStreamProvider(@Nonnull char[] aChars, @Nonnull Charset aCharset) {
        this(new String(aChars), aCharset);
    }

    public StringInputStreamProvider(@Nonnull char[] aChars, @Nonnegative int nOfs, @Nonnegative int nLen, @Nonnull @Nonempty String sCharset) {
        this(new String(aChars, nOfs, nLen), sCharset);
    }

    public StringInputStreamProvider(@Nonnull char[] aChars, @Nonnegative int nOfs, @Nonnegative int nLen, @Nonnull Charset aCharset) {
        this(new String(aChars, nOfs, nLen), aCharset);
    }

    public StringInputStreamProvider(@Nonnull CharSequence aData, @Nonnull @Nonempty String sCharset) {
        this(((Object)aData).toString(), sCharset);
    }

    public StringInputStreamProvider(@Nonnull CharSequence aData, @Nonnull Charset aCharset) {
        this(((Object)aData).toString(), aCharset);
    }

    public StringInputStreamProvider(@Nonnull String sData, @Nonnull @Nonempty String sCharset) {
        this(sData, CharsetManager.getCharsetFromName(sCharset));
    }

    public StringInputStreamProvider(@Nonnull String sData, @Nonnull Charset aCharset) {
        if (sData == null) {
            throw new NullPointerException("data");
        }
        if (aCharset == null) {
            throw new NullPointerException("charset");
        }
        this.m_sData = sData;
        this.m_aCharset = aCharset;
    }

    @Nonnull
    public String getData() {
        return this.m_sData;
    }

    @Nonnull
    public Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    @Nonnull
    public final StringInputStream getInputStream() {
        return new StringInputStream(this.m_sData, this.m_aCharset);
    }

    @Override
    @Nonnull
    public final NonBlockingStringReader getReader(@Nonnull String sCharset) {
        return new NonBlockingStringReader(this.m_sData);
    }

    @Override
    @Nonnull
    public final NonBlockingStringReader getReader(@Nonnull Charset aCharset) {
        return new NonBlockingStringReader(this.m_sData);
    }

    @Override
    @Nonnull
    public final NonBlockingStringReader getReader() {
        return new NonBlockingStringReader(this.m_sData);
    }

    public String toString() {
        return new ToStringGenerator(null).append("data", this.m_sData).append("charset", this.m_aCharset).toString();
    }
}

